/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplaySavedWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayUserWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.ManageUserWindowsAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICPTMClusterAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICPTMSitesAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICPeptideIonAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICPeptideSetAction;
import fr.proline.studio.rsmexplorer.actions.xic.DisplayXICProteinSetAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.NbBundle;

public class DisplayXICAction
extends AbstractRSMAction {
    private JMenu m_menu;
    private DisplayXICProteinSetAction m_displayXICProteinSetAction;
    private DisplayXICPeptideSetAction m_displayXICPeptideSetAction;
    private DisplayXICPeptideIonAction m_displayXICPeptideIonAction;
    private DisplayXICPTMSitesAction m_displayXICPtmSiteProteinAction;
    private DisplayXICPTMClusterAction m_displayXICPtmClusterProteinAction;
    private DisplayUserWindowAction m_displayUserWindowAction;
    private ManageUserWindowsAction m_manageUserWindowsAction;
    private ArrayList<DisplaySavedWindowAction> m_displaySavedWindowActionList;

    public DisplayXICAction(AbstractTree tree) {
        super(NbBundle.getMessage(DisplayXICAction.class, (String)"CTL_DisplayXicAction"), tree);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        this.m_menu = new JMenu((String)this.getValue("Name"));
        this.m_displayXICProteinSetAction = new DisplayXICProteinSetAction(this.getTree());
        this.m_displayXICPeptideSetAction = new DisplayXICPeptideSetAction(this.getTree());
        this.m_displayXICPeptideIonAction = new DisplayXICPeptideIonAction(this.getTree());
        this.m_displayXICPtmSiteProteinAction = new DisplayXICPTMSitesAction(this.getTree());
        this.m_displayXICPtmClusterProteinAction = new DisplayXICPTMClusterAction(this.getTree());
        this.m_manageUserWindowsAction = new ManageUserWindowsAction('3', this.getTree());
        this.m_displayUserWindowAction = new DisplayUserWindowAction('3', this.getTree());
        ArrayList<String> savedWindowsList = WindowSavedManager.readSavedWindows();
        int nb = savedWindowsList.size();
        this.m_displaySavedWindowActionList = new ArrayList();
        for (int i = 0; i < nb; ++i) {
            String wndSaved = savedWindowsList.get(i);
            if (!WindowSavedManager.hasQuantiParameter(wndSaved)) continue;
            String name = WindowSavedManager.getWindowName(wndSaved);
            this.m_displaySavedWindowActionList.add(new DisplaySavedWindowAction(name, i, this.getTree()));
        }
        JMenuItem displayXICProteinSetItem = new JMenuItem(this.m_displayXICProteinSetAction);
        JMenuItem displayXICPeptideSetItem = new JMenuItem(this.m_displayXICPeptideSetAction);
        JMenuItem displayXICPeptideIonItem = new JMenuItem(this.m_displayXICPeptideIonAction);
        JMenuItem displayXICPtmSiteProteinItem = new JMenuItem(this.m_displayXICPtmSiteProteinAction);
        JMenuItem displayXICPtmClusterProteinItem = new JMenuItem(this.m_displayXICPtmClusterProteinAction);
        JMenuItem displayUserWindowItem = new JMenuItem(this.m_displayUserWindowAction);
        JMenuItem manageUserWindowsItem = new JMenuItem(this.m_manageUserWindowsAction);
        this.m_menu.add(displayXICPeptideIonItem);
        this.m_menu.add(displayXICPeptideSetItem);
        this.m_menu.add(displayXICProteinSetItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayXICPtmSiteProteinItem);
        this.m_menu.add(displayXICPtmClusterProteinItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayUserWindowItem);
        this.m_menu.add(manageUserWindowsItem);
        int nbUserWindows = this.m_displaySavedWindowActionList.size();
        if (nbUserWindows > 0) {
            this.m_menu.addSeparator();
        }
        for (int i = 0; i < nbUserWindows; ++i) {
            this.m_menu.add(new JMenuItem(this.m_displaySavedWindowActionList.get(i)));
        }
        return this.m_menu;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        this.m_displayXICProteinSetAction.updateEnabled(selectedNodes);
        this.m_displayXICPeptideSetAction.updateEnabled(selectedNodes);
        this.m_displayXICPeptideIonAction.updateEnabled(selectedNodes);
        this.m_displayXICPtmSiteProteinAction.updateEnabled(selectedNodes);
        this.m_displayXICPtmClusterProteinAction.updateEnabled(selectedNodes);
        this.m_displayUserWindowAction.updateEnabled(selectedNodes);
        this.m_manageUserWindowsAction.updateEnabled(selectedNodes);
        boolean listEnabled = false;
        for (DisplaySavedWindowAction m_displaySavedWindowActionList1 : this.m_displaySavedWindowActionList) {
            m_displaySavedWindowActionList1.updateEnabled(selectedNodes);
            listEnabled |= m_displaySavedWindowActionList1.isEnabled();
        }
        boolean isEnabled = this.m_displayXICProteinSetAction.isEnabled() || this.m_displayXICPtmSiteProteinAction.isEnabled() || this.m_displayXICPtmClusterProteinAction.isEnabled() || this.m_displayXICPeptideSetAction.isEnabled() || this.m_displayXICPeptideIonAction.isEnabled() || this.m_displayUserWindowAction.isEnabled() || this.m_manageUserWindowsAction.isEnabled() || listEnabled;
        this.setEnabled(isEnabled);
        this.m_menu.setEnabled(isEnabled);
    }
}

