/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.jdesktop.swingx.JXTable;
import org.openide.windows.WindowManager;

public class FlipButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String m_exportName;
    private JXTable m_table = null;
    private RsetMSDiagPanel msdiagPanel = null;
    private String m_buttonStatus = "default";
    private ProgressInterface m_progressInterface = null;

    public FlipButton(ProgressInterface progressInterface, String exportName, JXTable table) {
        this.setProgressInterface(progressInterface);
        this.m_exportName = exportName;
        this.m_table = table;
        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE));
        this.setToolTipText("Export Data...");
        this.setFocusPainted(false);
        this.addActionListener(this);
    }

    public final void setProgressInterface(ProgressInterface progressInterface) {
        this.m_progressInterface = progressInterface;
    }

    public FlipButton(String exportName) {
        this.m_exportName = exportName;
        this.msdiagPanel = null;
        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE));
        this.addActionListener(this);
    }

    public FlipButton(String exportName, RsetMSDiagPanel msdiagPanel) {
        this.m_exportName = exportName;
        this.msdiagPanel = msdiagPanel;
        this.m_buttonStatus = msdiagPanel.m_displayType;
        if (this.m_buttonStatus.equals("default")) {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE));
            msdiagPanel.setDisplayType("default");
            this.m_buttonStatus = "default";
            this.setToolTipText("Switch to table view");
        } else {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
            msdiagPanel.setDisplayType("table");
            this.m_buttonStatus = "table";
            this.setToolTipText("Switch to graphical view");
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
            ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)this.m_progressInterface, (String)"Data loading", (String)"Export is not available while data is loading. Please Wait.");
            dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
            dialog.setVisible(true);
            if (!dialog.isWaitingFinished()) {
                return;
            }
        }
        if (this.m_buttonStatus.equals("table")) {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE));
            this.msdiagPanel.setDisplayType("default");
            this.m_buttonStatus = "default";
        } else {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
            this.msdiagPanel.setDisplayType("table");
            this.m_buttonStatus = "table";
        }
        int selectedTabIndex = this.msdiagPanel.m_tabbedPane.getSelectedIndex();
        this.msdiagPanel.m_tabbedPane.removeAll();
        this.msdiagPanel.displayData();
        this.msdiagPanel.m_tabbedPane.setSelectedIndex(selectedTabIndex);
    }
}

