/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.mzscope.utils.IPopupMenuDelegate;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.msfiles.ExportMgfDialog;
import fr.proline.studio.msfiles.FileDeletionBatch;
import fr.proline.studio.msfiles.FileToTransfer;
import fr.proline.studio.msfiles.MsFilesExplorer;
import fr.proline.studio.msfiles.MzdbEncodingVerificationBatch;
import fr.proline.studio.pattern.MzScopeWindowBoxManager;
import fr.proline.studio.rsmexplorer.gui.LocalFileSystemModel;
import fr.proline.studio.rsmexplorer.gui.LocalFileSystemTransferHandler;
import fr.proline.studio.rsmexplorer.gui.MzScope;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.rsmexplorer.gui.dialog.ConvertRawDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.UploadMzdbDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemView
extends JPanel
implements IPopupMenuDelegate {
    private LocalFileSystemModel m_fileSystemDataModel;
    private JTree m_tree;
    private JPopupMenu m_popupMenu;
    private JMenuItem m_detectPeakelsItem;
    private JMenuItem m_viewRawFileItem;
    private JMenuItem m_convertRawFileItem;
    private JMenuItem m_uploadMzdbFileItem;
    private JMenuItem m_exportMgfItem;
    private JMenuItem m_deleteFileItem;
    private JMenuItem m_verifyEncodingItem;
    private ActionListener viewRawFileAction;
    private ArrayList<File> m_selectedFiles;
    private final LocalFileSystemTransferHandler m_transferHandler;
    private boolean m_showUpdateButton;
    private JComboBox m_rootsComboBox;
    private Preferences m_preferences;
    private MsFilesExplorer.FileSelectionInterface m_fileSelectionInterface = null;
    private HashSet<String> m_paths;
    private boolean m_updating;
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.LocalFileSystemView");
    private static final String LOCAL_FILE_SYSTEM_LIST_KEY = "LOCAL_FILE_SYSTEM_VIEW";
    private static final String DRIVE_PARAM_KEY = "DRIVE_KEY";

    public LocalFileSystemView(LocalFileSystemTransferHandler transferHandler) {
        this.m_transferHandler = transferHandler;
        this.m_preferences = NbPreferences.root();
        this.m_paths = new HashSet();
        this.initComponents();
    }

    public LocalFileSystemView(LocalFileSystemTransferHandler transferHandler, boolean showUpdateButton) {
        this(transferHandler);
        this.m_showUpdateButton = showUpdateButton;
        this.m_updating = false;
    }

    private void initComponents() {
        this.m_selectedFiles = new ArrayList();
        this.setBorder(BorderFactory.createTitledBorder("Local File System"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        JButton updateButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFRESH));
        updateButton.setToolTipText("Refresh");
        updateButton.setFocusPainted(false);
        updateButton.setOpaque(true);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LocalFileSystemView.this.m_updating) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LocalFileSystemView.this.updateTree();
                        }
                    });
                }
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(updateButton);
        this.add((Component)toolbar, c);
        ++c.gridy;
        this.add((Component)Box.createVerticalBox(), c);
        c.gridy = 0;
        c.gridheight = 2;
        ++c.gridx;
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout(0, 5));
        File[] roots = File.listRoots();
        this.m_rootsComboBox = new JComboBox<File>(roots);
        this.m_rootsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                LocalFileSystemView.this.reloadTree();
                LocalFileSystemView.this.resetTreeState();
                LocalFileSystemView.this.m_preferences.put("LOCAL_FILE_SYSTEM_VIEW.DRIVE_KEY", LocalFileSystemView.this.m_rootsComboBox.getSelectedItem().toString());
            }
        });
        treePanel.add((Component)this.m_rootsComboBox, "North");
        this.m_popupMenu = new JPopupMenu();
        this.initPopupMenu(this.m_popupMenu);
        this.m_fileSystemDataModel = new LocalFileSystemModel(this.m_rootsComboBox.getSelectedItem().toString());
        this.m_tree = new JTree(this.m_fileSystemDataModel);
        this.m_tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (((DefaultMutableTreeNode)value).isRoot()) {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DRIVE));
                } else {
                    File f = (File)((DefaultMutableTreeNode)value).getUserObject();
                    if (f.isDirectory()) {
                        if (expanded) {
                            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER_EXPANDED));
                        } else {
                            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER));
                        }
                    } else if (f.getAbsolutePath().toLowerCase().endsWith(".raw")) {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SPECTRUM));
                    } else if (f.getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SPECTRUM_EMISSION));
                    } else {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FILE));
                    }
                }
                return c;
            }
        });
        HashSet<String> set = TreeUtils.loadExpansionState(TreeUtils.TreeType.LOCAL, this.m_rootsComboBox.getSelectedItem().toString());
        TreeUtils.setExpansionState(set, this.m_tree, (DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), TreeUtils.TreeType.LOCAL, this.m_rootsComboBox.getSelectedItem().toString());
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(LocalFileSystemView.this.m_tree, TreeUtils.TreeType.LOCAL, LocalFileSystemView.this.m_rootsComboBox.getSelectedItem().toString());
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)tee.getPath().getLastPathComponent();
                LocalFileSystemView.this.traverseAndExpand(expandedNode);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(LocalFileSystemView.this.m_tree, TreeUtils.TreeType.LOCAL, LocalFileSystemView.this.m_rootsComboBox.getSelectedItem().toString());
            }
        });
        this.m_tree.setTransferHandler(this.m_transferHandler);
        this.m_tree.setDragEnabled(true);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    LocalFileSystemView.this.updatePopupMenu();
                    LocalFileSystemView.this.m_popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LocalFileSystemView.this.m_fileSelectionInterface == null) {
                    return;
                }
                ArrayList<FileToTransfer> files = new ArrayList<FileToTransfer>();
                ArrayList<FileToTransfer> directories = new ArrayList<FileToTransfer>();
                ArrayList<FileToTransfer> parentDirectory = new ArrayList<FileToTransfer>();
                LocalFileSystemView.this.getSelectedFilesAndDirectories(files, directories, parentDirectory);
                LocalFileSystemView.this.m_fileSelectionInterface.upSelectionChanged(files, directories, parentDirectory);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        treePanel.add((Component)scrollPane, "Center");
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)treePanel, c);
        this.initRoot();
    }

    public void setFileSelectionListener(MsFilesExplorer.FileSelectionInterface fileSelectionInterface) {
        this.m_fileSelectionInterface = fileSelectionInterface;
    }

    private void initRoot() {
        String previousDrive = this.m_preferences.get("LOCAL_FILE_SYSTEM_VIEW.DRIVE_KEY", null);
        if (previousDrive != null) {
            ComboBoxModel model = this.m_rootsComboBox.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                File f = (File)model.getElementAt(i);
                if (!f.getAbsolutePath().equalsIgnoreCase(previousDrive)) continue;
                this.m_rootsComboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private ArrayList<String> getSelectedURLs() {
        this.m_selectedFiles.clear();
        ArrayList<String> selectedURLs = new ArrayList<String>();
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                File f = (File)node.getUserObject();
                if (!f.isFile()) continue;
                selectedURLs.add(f.getAbsolutePath());
                this.m_selectedFiles.add(f);
            }
        }
        return selectedURLs;
    }

    private void getSelectedFilesAndDirectories(ArrayList<FileToTransfer> files, ArrayList<FileToTransfer> directories, ArrayList<FileToTransfer> parentDirectory) {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            String url;
            File f;
            DefaultMutableTreeNode node;
            for (TreePath path : paths) {
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
                f = (File)node.getUserObject();
                if (f.isFile()) {
                    url = f.getAbsolutePath().toLowerCase();
                    if (!url.endsWith(".mzdb") && !url.endsWith(".raw") && !url.endsWith(".wiff") && !url.endsWith(".dat")) continue;
                    files.add(new FileToTransfer(f, path));
                    continue;
                }
                if (!f.isDirectory()) continue;
                directories.add(new FileToTransfer(f, path));
            }
            if (directories.isEmpty() && files.size() == 1) {
                for (TreePath path : paths) {
                    TreePath parentPath;
                    DefaultMutableTreeNode parentNode;
                    File parentFile;
                    node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    f = (File)node.getUserObject();
                    if (!f.isFile() || !(url = f.getAbsolutePath().toLowerCase()).endsWith(".mzdb") && !url.endsWith(".raw") && !url.endsWith(".wiff") && !url.endsWith(".dat") || !(parentFile = (File)(parentNode = (DefaultMutableTreeNode)(parentPath = path.getParentPath()).getLastPathComponent()).getUserObject()).isDirectory()) continue;
                    parentDirectory.add(new FileToTransfer(parentFile, parentPath));
                    break;
                }
            }
        }
    }

    public void resetTreeState() {
        TreeUtils.setExpansionState(TreeUtils.loadExpansionState(TreeUtils.TreeType.LOCAL, this.m_rootsComboBox.getSelectedItem().toString()), this.m_tree, (DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), TreeUtils.TreeType.LOCAL, this.m_rootsComboBox.getSelectedItem().toString());
    }

    public void expandTreePath(TreePath path) {
        this.m_tree.expandPath(path);
    }

    public void expandMultipleTreePath(HashSet<String> directories) {
        for (String s : directories) {
            this.m_paths.add(s);
        }
        this.traverseAndExpand((DefaultMutableTreeNode)this.m_fileSystemDataModel.getRoot());
    }

    private void traverseAndExpand(DefaultMutableTreeNode root) {
        boolean found = false;
        String rootAbsolutePath = ((File)root.getUserObject()).getAbsolutePath();
        for (String s : this.m_paths) {
            if (!s.contains(rootAbsolutePath)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        Enumeration<TreeNode> totalNodes = root.depthFirstEnumeration();
        while (totalNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)totalNodes.nextElement();
            File f = (File)node.getUserObject();
            String absolutePath = f.getAbsolutePath();
            if (!this.m_paths.contains(absolutePath)) continue;
            this.m_paths.remove(node.toString());
            TreePath tp = new TreePath(node.getPath());
            if (!this.m_tree.isExpanded(tp)) {
                this.m_tree.expandPath(new TreePath(node.getPath()));
                continue;
            }
            this.m_fileSystemDataModel.fireTreeNodesChanged(new TreeModelEvent((Object)node, node.getPath()));
        }
    }

    public void updateTree() {
        if (!this.m_updating) {
            this.m_updating = true;
            this.reloadTree();
            this.resetTreeState();
            this.m_updating = false;
        }
    }

    public void reloadTree() {
        if (this.m_fileSystemDataModel != null) {
            this.m_tree.setModel(null);
            this.m_fileSystemDataModel = new LocalFileSystemModel(this.m_rootsComboBox.getSelectedItem().toString());
            this.m_tree.setModel(this.m_fileSystemDataModel);
        }
    }

    private boolean isSelectionHomogeneous(ArrayList<String> selectedURLs) {
        if (selectedURLs.size() > 0) {
            int lastIndexOfDot = selectedURLs.get(0).lastIndexOf(".");
            if (lastIndexOfDot == -1) {
                return false;
            }
            String firstSuffix = selectedURLs.get(0).substring(lastIndexOfDot);
            for (String url : selectedURLs) {
                if (url.endsWith(firstSuffix)) continue;
                return false;
            }
        }
        return true;
    }

    private void displayRaw(ArrayList<File> rawfiles) {
        MzScope mzScope = new MzScope(1, rawfiles);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    private void detectPeakels(ArrayList<File> rawfiles) {
        MzScope mzScope = new MzScope(0, rawfiles);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    public void initPopupMenu(JPopupMenu popupMenu) {
        this.viewRawFileAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalFileSystemView.this.displayRaw(LocalFileSystemView.this.m_selectedFiles);
            }
        };
        this.m_viewRawFileItem = new JMenuItem("View");
        this.m_viewRawFileItem.addActionListener(this.viewRawFileAction);
        popupMenu.add(this.m_viewRawFileItem);
        this.m_detectPeakelsItem = new JMenuItem("Detect Peakels");
        this.m_detectPeakelsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalFileSystemView.this.detectPeakels(LocalFileSystemView.this.m_selectedFiles);
            }
        });
        popupMenu.add(this.m_detectPeakelsItem);
        this.m_convertRawFileItem = new JMenuItem("Convert to mzDB");
        this.m_convertRawFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConvertRawDialog dialog = ConvertRawDialog.getDialog(null);
                dialog.setFiles(LocalFileSystemView.this.m_selectedFiles);
                dialog.setVisible(true);
            }
        });
        popupMenu.add(this.m_convertRawFileItem);
        this.m_verifyEncodingItem = new JMenuItem("Verify Encoding");
        this.m_verifyEncodingItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MzdbEncodingVerificationBatch batch = new MzdbEncodingVerificationBatch(LocalFileSystemView.this.m_selectedFiles);
                Thread thread = new Thread(batch);
                thread.start();
            }
        });
        popupMenu.add(this.m_verifyEncodingItem);
        this.m_uploadMzdbFileItem = new JMenuItem("Upload to Server");
        this.m_uploadMzdbFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UploadMzdbDialog dialog = UploadMzdbDialog.getDialog(WindowManager.getDefault().getMainWindow());
                dialog.setFiles(LocalFileSystemView.this.m_selectedFiles);
                dialog.setVisible(true);
            }
        });
        popupMenu.add(this.m_uploadMzdbFileItem);
        this.m_exportMgfItem = new JMenuItem("Export .mgf");
        this.m_exportMgfItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExportMgfDialog dialog = ExportMgfDialog.getDialog(null, "Export .mgf file(s)");
                dialog.setLocationRelativeTo(null);
                dialog.setFiles(LocalFileSystemView.this.m_selectedFiles);
                dialog.setVisible(true);
            }
        });
        popupMenu.add(this.m_exportMgfItem);
        this.m_deleteFileItem = new JMenuItem("Delete file(s)");
        this.m_deleteFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FileDeletionBatch batch = new FileDeletionBatch(LocalFileSystemView.this.m_selectedFiles);
                Thread thread = new Thread(batch);
                thread.start();
            }
        });
        popupMenu.add(this.m_deleteFileItem);
    }

    public void updatePopupMenu() {
        ArrayList<String> selectedURLs = this.getSelectedURLs();
        if (!selectedURLs.isEmpty()) {
            if (this.isSelectionHomogeneous(selectedURLs)) {
                String firstURL = selectedURLs.get(0).toLowerCase();
                if (firstURL.endsWith(".mzdb")) {
                    this.setPopupEnabled(true);
                    this.m_convertRawFileItem.setEnabled(false);
                    this.m_uploadMzdbFileItem.setEnabled(DatabaseDataManager.getDatabaseDataManager().getLoggedUser() != null);
                } else if (firstURL.endsWith(".raw") || firstURL.endsWith(".wiff")) {
                    this.setPopupEnabled(false);
                    this.m_convertRawFileItem.setEnabled(true);
                    this.m_deleteFileItem.setEnabled(true);
                } else if (firstURL.endsWith(".mgf")) {
                    this.setPopupEnabled(false);
                    this.m_deleteFileItem.setEnabled(true);
                } else {
                    this.setPopupEnabled(false);
                }
            } else {
                this.setPopupEnabled(false);
            }
        } else {
            this.setPopupEnabled(false);
        }
    }

    private void setPopupEnabled(boolean b) {
        this.m_viewRawFileItem.setEnabled(b);
        this.m_detectPeakelsItem.setEnabled(b);
        this.m_convertRawFileItem.setEnabled(b);
        this.m_verifyEncodingItem.setEnabled(b);
        this.m_uploadMzdbFileItem.setEnabled(b);
        this.m_exportMgfItem.setEnabled(b);
        this.m_deleteFileItem.setEnabled(b);
    }

    public ActionListener getDefaultAction() {
        return null;
    }

    public String getSelectedRoot() {
        if (this.m_rootsComboBox != null) {
            return this.m_rootsComboBox.getSelectedItem().toString();
        }
        return "";
    }
}

