/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.FlipButton;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_BoxChart
extends HourglassPanel {
    public static final String SERIES_NAME = "BoxChart";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final DefaultBoxAndWhiskerCategoryDataset m_dataSet;
    private final JFreeChart m_chart;
    private JPanel m_boxChartPanel;
    private final CategoryPlot m_subplot;
    private final RsetMSDiagPanel m_msdiagPanel;

    public MSDiag_BoxChart(RsetMSDiagPanel rsetMSDiagPanel) {
        this.m_msdiagPanel = rsetMSDiagPanel;
        this.m_dataSet = new DefaultBoxAndWhiskerCategoryDataset();
        NumberAxis rangeAxis = new NumberAxis("");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setFillBox(true);
        renderer.setSeriesPaint(0, (Paint)new Color(220, 220, 220));
        renderer.setSeriesPaint(1, (Paint)new Color(176, 190, 255));
        renderer.setSeriesPaint(2, (Paint)new Color(132, 153, 255));
        renderer.setSeriesPaint(3, (Paint)new Color(91, 120, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(64, 98, 255));
        renderer.setSeriesPaint(5, (Paint)new Color(42, 71, 255));
        renderer.setSeriesPaint(6, (Paint)new Color(11, 191, 220));
        renderer.setSeriesPaint(7, (Paint)new Color(126, 94, 214));
        renderer.setItemMargin(0.2);
        renderer.setMaximumBarWidth(1.0);
        renderer.setBaseLegendShape((Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setSeriesPaint(0, (Paint)Color.red);
        renderer.setSeriesPaint(0, (Paint)Color.blue);
        renderer.setSeriesPaint(0, (Paint)Color.green);
        this.m_subplot = new CategoryPlot((CategoryDataset)this.m_dataSet, null, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
        this.m_subplot.setDomainGridlinesVisible(true);
        CategoryAxis domainAxis = new CategoryAxis("");
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.7853981633974483));
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        plot.add(this.m_subplot, 1);
        this.m_chart = new JFreeChart("Combined Chart title", new Font("SansSerif", 1, 12), (Plot)plot, true);
        this.m_chart.setBackgroundPaint((Paint)Color.white);
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true){};
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_boxChartPanel = cp;
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(this.m_boxChartPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FlipButton flipModeButton = new FlipButton("flip button text", this.m_msdiagPanel);
        toolbar.add(flipModeButton);
        ExportButton exportImageButton = new ExportButton("pieChart", this.m_boxChartPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructBoxChart(msdo);
    }

    private void constructBoxChart(MSDiagOutput_AW msdo) {
        this.m_dataSet.clear();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_subplot.getRangeAxis().setLabel(msdo.y_axis_description);
        this.m_chart.getCategoryPlot().getDomainAxis().setLabel(msdo.x_axis_description);
        int nbSeries = msdo.matrix.length;
        for (int serie = 0; serie < nbSeries; ++serie) {
            String serieString = msdo.matrix[serie][0].toString();
            String catString = msdo.matrix[serie][1].toString();
            double mean = (Double)msdo.matrix[serie][4];
            double median = (Double)msdo.matrix[serie][5];
            double minRegularValue = (Double)msdo.matrix[serie][2];
            double maxRegularValue = (Double)msdo.matrix[serie][3];
            Double q1 = minRegularValue;
            Double q3 = maxRegularValue;
            Double minOutlier = minRegularValue;
            Double maxOutlier = maxRegularValue;
            List listOutliers = null;
            this.m_dataSet.add(new BoxAndWhiskerItem((Number)mean, (Number)median, (Number)q1, (Number)q3, (Number)minRegularValue, (Number)maxRegularValue, (Number)minOutlier, (Number)maxOutlier, listOutliers), (Comparable)((Object)catString), (Comparable)((Object)serieString));
        }
    }
}

