/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.BookmarkMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.PTMClusterTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.ImportTableSelectionInterface;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class PTMClustersPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_scrollPane;
    private PTMClusterTable m_ptmClusterTable;
    private JTextField m_countModificationTextField;
    private MarkerContainerPanel m_markerContainerPanel;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private boolean m_hideFirstTime = true;

    public PTMClustersPanel() {
        this.initComponents();
    }

    public void setData(Long taskId, ArrayList<PTMCluster> ptmClusters, boolean finished) {
        PTMClusterTableModel model = (PTMClusterTableModel)((CompoundTableModel)this.m_ptmClusterTable.getModel()).getBaseModel();
        model.setData(taskId, ptmClusters);
        if (ptmClusters != null && ptmClusters.size() > 0) {
            this.m_ptmClusterTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(ptmClusters.size());
            if (this.m_hideFirstTime) {
                this.setColumnsVisibility();
                this.m_hideFirstTime = false;
            }
        }
        this.m_infoToggleButton.updateInfo();
        this.m_countModificationTextField.setText(model.getModificationsInfo());
        if (finished) {
            this.m_ptmClusterTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_ptmClusterTable.dataUpdated(subTask, finished);
        PTMClusterTableModel model = (PTMClusterTableModel)((CompoundTableModel)this.m_ptmClusterTable.getModel()).getBaseModel();
        this.m_countModificationTextField.setText(model.getModificationsInfo());
    }

    public PTMCluster getSelectedProteinPTMCluster() {
        int selectedRow = this.m_ptmClusterTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_ptmClusterTable.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmClusterTable.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        PTMClusterTableModel tableModel = (PTMClusterTableModel)compoundTableModel.getBaseModel();
        return tableModel.getProteinPTMCluster(selectedRow);
    }

    public List<PTMCluster> getSelectedPTMClusters() {
        int[] selectedRows = this.m_ptmClusterTable.getSelectedRows();
        int nbSelectedRows = selectedRows.length;
        ArrayList<PTMCluster> selectedPtmClusters = new ArrayList<PTMCluster>(nbSelectedRows);
        if (nbSelectedRows == 0) {
            return selectedPtmClusters;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmClusterTable.getModel();
        PTMClusterTableModel tableModel = (PTMClusterTableModel)compoundTableModel.getBaseModel();
        for (int i = 0; i < nbSelectedRows; ++i) {
            int rowModelIndex = this.m_ptmClusterTable.convertRowIndexToModel(selectedRows[i]);
            int convertedSelectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(rowModelIndex);
            selectedPtmClusters.add(tableModel.getProteinPTMCluster(convertedSelectedRow));
        }
        return selectedPtmClusters;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_ptmClusterTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_ptmClusterTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_ptmClusterTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel proteinPTMClusterPanel = this.createProteinPTMClusterPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinPTMClusterPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinPTMClusterPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), new Integer(JLayeredPane.PALETTE_LAYER + 1));
        this.setColumnsVisibility();
    }

    private void setColumnsVisibility() {
        List<Integer> listIdsToHide = ((PTMClusterTableModel)((CompoundTableModel)this.m_ptmClusterTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
        List columns = this.m_ptmClusterTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible) continue;
            this.m_ptmClusterTable.getColumnExt(this.m_ptmClusterTable.convertColumnIndexToView(id)).setVisible(false);
        }
    }

    private JPanel createProteinPTMClusterPanel() {
        JPanel proteinPTMClusterPanel = new JPanel();
        proteinPTMClusterPanel.setBounds(0, 0, 500, 400);
        proteinPTMClusterPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        proteinPTMClusterPanel.add((Component)toolbar, "West");
        proteinPTMClusterPanel.add((Component)internalPanel, "Center");
        return proteinPTMClusterPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_ptmClusterTable.getModel(), (SettingsInterface)this.m_ptmClusterTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_ptmClusterTable, (JXTable)this.m_ptmClusterTable, (FilterTableModelInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel())){

            protected void filteringDone() {
                PTMClustersPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                PTMClustersPanel.this.m_dataBox.propagateDataChanged();
                PTMClustersPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel()), "Protein Sets", (JXTable)this.m_ptmClusterTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel())){

            public void actionPerformed() {
                JXTable table = PTMClustersPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(PTMClustersPanel.this.m_dataBox.getId(), PTMClustersPanel.this.m_dataBox.getUserName(), PTMClustersPanel.this.m_dataBox.getDataName(), PTMClustersPanel.this.m_dataBox.getTypeName(), table);
                Image i = PTMClustersPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_ptmClusterTable, (InfoInterface)this.m_ptmClusterTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_ptmClusterTable = new PTMClusterTable();
        PTMClusterTableModel model = new PTMClusterTableModel(this.m_ptmClusterTable);
        this.m_ptmClusterTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)model, true));
        this.m_ptmClusterTable.getColumnExt(this.m_ptmClusterTable.convertColumnIndexToView(1)).setVisible(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.m_ptmClusterTable.getModel());
        this.m_ptmClusterTable.setRowSorter(sorter);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_ptmClusterTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_ptmClusterTable));
        this.m_ptmClusterTable.setFillsViewportHeight(true);
        this.m_ptmClusterTable.setViewport(this.m_scrollPane.getViewport());
        this.m_countModificationTextField = new JTextField();
        this.m_countModificationTextField.setEditable(false);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        internalPanel.add((Component)this.m_countModificationTextField, c);
        return internalPanel;
    }

    private class PTMClusterTable
    extends LazyTable
    implements ImportTableSelectionInterface,
    CrossSelectionInterface,
    InfoInterface {
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public PTMClusterTable() {
            super(PTMClustersPanel.this.m_scrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public void tableChanged(TableModelEvent e) {
            CompoundTableModel model;
            super.tableChanged(e);
            if (PTMClustersPanel.this.m_ptmClusterTable != null && PTMClustersPanel.this.m_countModificationTextField != null && (model = (CompoundTableModel)PTMClustersPanel.this.m_ptmClusterTable.getModel()) != null) {
                ArrayList<PTMCluster> proteinPTMCluster = new ArrayList<PTMCluster>();
                int nbRows = model.getRowCount();
                for (int i = 0; i < nbRows; ++i) {
                    proteinPTMCluster.add((PTMCluster)model.getRowValue(PTMCluster.class, i));
                }
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            PTMClustersPanel.this.m_dataBox.addDataChanged(DProteinSet.class);
            PTMClustersPanel.this.m_dataBox.addDataChanged(DProteinMatch.class);
            PTMClustersPanel.this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
            PTMClustersPanel.this.m_dataBox.propagateDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PTMClusterTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                    PTMClustersPanel.this.setColumnsVisibility();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask != null && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return PTMClustersPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return PTMClustersPanel.this.m_dataBox.isLoaded();
        }

        public void importSelection(HashSet selectedData) {
            ListSelectionModel selectionTableModel = this.getSelectionModel();
            selectionTableModel.clearSelection();
            int firstRow = -1;
            PTMClusterTableModel model = (PTMClusterTableModel)((CompoundTableModel)PTMClustersPanel.this.m_ptmClusterTable.getModel()).getBaseModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Object v = model.getValueAt(i, 1);
                if (!selectedData.remove(v)) continue;
                if (firstRow == -1) {
                    firstRow = i;
                }
                selectionTableModel.addSelectionInterval(i, i);
                BookmarkMarker marker = new BookmarkMarker(i);
                PTMClustersPanel.this.m_markerContainerPanel.addMarker((AbstractMarker)marker);
                if (selectedData.isEmpty()) break;
            }
            if (firstRow != -1) {
                int row = firstRow;
                this.scrollToVisible(row);
            }
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(PTMClustersPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            PTMClusterTableModel model = (PTMClusterTableModel)((CompoundTableModel)PTMClustersPanel.this.m_ptmClusterTable.getModel()).getBaseModel();
            String modifInfo = model.getModificationsInfo();
            return count + (count > 1 ? " PTM Clusters" : " PTM Cluster") + " \n " + modifInfo;
        }
    }
}

