/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.Peaklist;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseRsetProperties;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.DataboxGeneric;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.PropertiesAction;
import fr.proline.studio.rsmexplorer.gui.GenericPanel;
import fr.proline.studio.rsmexplorer.gui.model.properties.IdentificationPropertiesTableModel;
import fr.proline.studio.rsmexplorer.gui.renderer.TimestampRenderer;
import fr.proline.studio.rsmexplorer.tree.identification.IdTransferable;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.PropertiesProviderInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class RsetAllPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private AbstractDataBox m_dataBox;
    private ResultSetTable m_resultSetTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private SearchToggleButton m_searchToggleButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private JScrollPane m_scrollPane;

    public RsetAllPanel() {
        this.setLayout(new BorderLayout());
        final JPanel resultSetPanel = this.createResultSetPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                resultSetPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)resultSetPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), JLayeredPane.PALETTE_LAYER);
    }

    private JPanel createResultSetPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBounds(0, 0, 500, 400);
        JPanel internalPanel = this.initInternalPanel();
        panel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        panel.add((Component)toolbar, "West");
        return panel;
    }

    private JPanel initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_resultSetTable = new ResultSetTable();
        ResultSetTableModel resultSetTableModel = new ResultSetTableModel();
        this.m_resultSetTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)resultSetTableModel, true));
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_resultSetTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_resultSetTable));
        this.m_resultSetTable.setFillsViewportHeight(true);
        this.m_resultSetTable.setViewport(this.m_scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        JButton refreshButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFRESH));
        refreshButton.setToolTipText("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RsetAllPanel.this.m_dataBox.dataChanged();
            }
        });
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_resultSetTable, (JXTable)this.m_resultSetTable, (FilterTableModelInterface)((CompoundTableModel)this.m_resultSetTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_resultSetTable.getModel())){

            protected void filteringDone() {
                RsetAllPanel.this.m_dataBox.dataChanged();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)this.m_resultSetTable, "All Imported Sets", (JXTable)this.m_resultSetTable);
        toolbar.add(refreshButton);
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_exportButton);
        return toolbar;
    }

    public void setData(long taskId, ArrayList<ResultSet> resultSetList) {
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_resultSetTable.getModel();
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)compoundTableModel.getBaseModel();
        resultSetTableModel.setData(resultSetList);
        if (resultSetList != null && resultSetList.size() > 0) {
            this.m_resultSetTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(resultSetList.size());
        }
        this.m_resultSetTable.setSortable(true);
    }

    public ResultSet getSelectedResultSet() {
        int selectedRow = this.m_resultSetTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_resultSetTable.convertRowIndexToModel(selectedRow);
        ResultSetTableModel tableModel = (ResultSetTableModel)((Object)this.m_resultSetTable.getModel());
        return tableModel.getResultSet(selectedRow);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        ((CompoundTableModel)this.m_resultSetTable.getModel()).addSingleValue(v);
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public class TableTransferHandler
    extends TransferHandler {
        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            ResultSetTable table = (ResultSetTable)((Object)c);
            CompoundTableModel compoundTableModel = (CompoundTableModel)table.getModel();
            ResultSetTableModel model = (ResultSetTableModel)compoundTableModel.getBaseModel();
            int[] rows = table.getSelectedRows();
            int nbRows = rows.length;
            if (nbRows == 0) {
                return null;
            }
            ArrayList<ResultSet> resultSetList = new ArrayList<ResultSet>(nbRows);
            for (int i = 0; i < nbRows; ++i) {
                int row = table.convertRowIndexToNonFilteredModel(rows[i]);
                ResultSet rset = model.getResultSet(row);
                resultSetList.add(rset);
            }
            IdTransferable.TransferData data = new IdTransferable.TransferData();
            data.setResultSetList(resultSetList);
            Integer transferKey = IdTransferable.register(data);
            return new IdTransferable(transferKey, RsetAllPanel.this.m_dataBox.getProjectId());
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            IdTransferable.clearRegisteredData();
        }
    }

    private static class ResultSetTableModel
    extends DecoratedTableModel
    implements GlobalTableModelInterface {
        public static final int COLTYPE_RSET_ID = 0;
        public static final int COLTYPE_RSET_NAME = 1;
        public static final int COLTYPE_PEAKLIST_PATH = 2;
        public static final int COLTYPE_MSISEARCH_FILE_NAME = 3;
        public static final int COLTYPE_MSISEARCH_FILE_DIRECTORY = 4;
        public static final int COLTYPE_MSISEARCH_SEARCH_DATE = 5;
        private static final String[] columnNames = new String[]{"id", "Search Result Name", "Peaklist Path", "MSISearch File Name", "MSISearch File Directory", "Search Date"};
        private ArrayList<ResultSet> m_resultSetList = null;

        private ResultSetTableModel() {
        }

        public void setData(ArrayList<ResultSet> resultSetList) {
            this.m_resultSetList = resultSetList;
            this.fireTableDataChanged();
        }

        public ResultSet getResultSet(int row) {
            if (this.m_resultSetList == null) {
                return null;
            }
            if (this.m_resultSetList.size() <= row) {
                return null;
            }
            return this.m_resultSetList.get(row);
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Long.class;
                }
                case 5: {
                    return Timestamp.class;
                }
            }
            return String.class;
        }

        public int getRowCount() {
            if (this.m_resultSetList == null) {
                return 0;
            }
            return this.m_resultSetList.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ResultSet rset = this.m_resultSetList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rset.getId();
                }
                case 1: {
                    return rset.getName();
                }
                case 2: {
                    MsiSearch msiSearch = rset.getMsiSearch();
                    if (msiSearch == null) {
                        return "";
                    }
                    Peaklist peaklist = msiSearch.getPeaklist();
                    if (peaklist == null) {
                        return "";
                    }
                    return peaklist.getPath();
                }
                case 3: {
                    MsiSearch msiSearch = rset.getMsiSearch();
                    if (msiSearch == null) {
                        return "";
                    }
                    return msiSearch.getResultFileName();
                }
                case 4: {
                    MsiSearch msiSearch = rset.getMsiSearch();
                    if (msiSearch == null) {
                        return "";
                    }
                    return msiSearch.getResultFileDirectory();
                }
                case 5: {
                    MsiSearch msiSearch = rset.getMsiSearch();
                    if (msiSearch == null) {
                        return null;
                    }
                    return msiSearch.getDate();
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return this.getColumnName(col);
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }

        public GlobalTableModelInterface getFrozzenModel() {
            return this;
        }

        public Long getTaskId() {
            return -1L;
        }

        public LazyData getLazyData(int row, int col) {
            return null;
        }

        public void givePriorityTo(Long taskId, int row, int col) {
        }

        public void sortingChanged(int col) {
        }

        public int getSubTaskId(int col) {
            return -1;
        }

        public String getDataColumnIdentifier(int columnIndex) {
            return this.getColumnName(columnIndex);
        }

        public Class getDataColumnClass(int columnIndex) {
            return this.getColumnClass(columnIndex);
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex);
        }

        public int[] getKeysColumn() {
            return null;
        }

        public int getInfoColumn() {
            return -1;
        }

        public void setName(String name) {
        }

        public String getName() {
            return null;
        }

        public Map<String, Object> getExternalData() {
            return null;
        }

        public PlotInformation getPlotInformation() {
            return null;
        }

        public ArrayList<ExtraDataType> getExtraDataTypes() {
            return null;
        }

        public Object getValue(Class c) {
            return this.getSingleValue(c);
        }

        public Object getRowValue(Class c, int row) {
            return null;
        }

        public Object getColValue(Class c, int col) {
            return null;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
            ConvertValueInterface longConverter = new ConvertValueInterface(){

                public Object convertValue(Object o) {
                    if (o == null) {
                        return null;
                    }
                    return Integer.parseInt(o.toString());
                }
            };
            filtersMap.put(0, (Filter)new IntegerFilter(this.getColumnName(0), longConverter, 0));
            filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), null, 1));
            filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), null, 2));
            filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), null, 3));
            filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), null, 4));
            ConvertValueInterface dateConverter = new ConvertValueInterface(){

                public Object convertValue(Object o) {
                    if (o == null) {
                        return null;
                    }
                    Timestamp timestamp = Timestamp.valueOf(o.toString());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(timestamp.getTime());
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH);
                    return dateFormatter.format(timestamp).toString();
                }
            };
            filtersMap.put(5, (Filter)new StringDiffFilter(this.getColumnName(5), dateConverter, 5));
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }

        public PlotType getBestPlotType() {
            return null;
        }

        public int[] getBestColIndex(PlotType plotType) {
            return null;
        }

        public String getExportRowCell(int row, int col) {
            return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return null;
        }

        public String getExportColumnName(int col) {
            return this.getColumnName(col);
        }
    }

    public class ResultsetPropertiesProvider
    implements PropertiesProviderInterface {
        private ResultSet m_rset = null;
        private String m_name = null;
        private long m_projectId = -1L;

        public ResultsetPropertiesProvider(ResultSet rset, long projectId, String name) {
            this.m_rset = rset;
            this.m_name = name;
            this.m_projectId = projectId;
        }

        public void loadDataForProperties(final Runnable callback) {
            AbstractDatabaseCallback taskCallback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    callback.run();
                }
            };
            DatabaseRsetProperties task = new DatabaseRsetProperties(taskCallback, this.m_projectId, this.m_rset, this.m_name);
            task.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }

        public ResultSet getResultset() {
            return this.m_rset;
        }

        public Sheet createSheet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public abstract class RsetCallback
    extends AbstractDatabaseCallback {
        protected int m_nbDataToLoad;

        public RsetCallback(int nbDataToLoad) {
            this.m_nbDataToLoad = nbDataToLoad;
        }
    }

    private class PropertiesFromTableAction
    extends AbstractTableAction {
        public PropertiesFromTableAction() {
            super(NbBundle.getMessage(PropertiesAction.class, (String)"CTL_PropertiesAction"));
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            GenericPanel genericPanel;
            int nbResultSet = selectedRows.length;
            ResultSetTableModel rsetModel = (ResultSetTableModel)((CompoundTableModel)RsetAllPanel.this.m_resultSetTable.getModel()).getBaseModel();
            final long projectId = RsetAllPanel.this.m_dataBox.getProjectId();
            final ArrayList<ResultSet> resultSetList = new ArrayList<ResultSet>(nbResultSet);
            for (int i = 0; i < nbResultSet; ++i) {
                int rowInModel = RsetAllPanel.this.m_resultSetTable.convertRowIndexToModel(selectedRows[i]);
                ResultSet rset = rsetModel.getResultSet(rowInModel);
                resultSetList.add(rset);
            }
            String rsetFileName = ((ResultSet)resultSetList.get(0)).getMsiSearch().getResultFileName();
            if (rsetFileName != null) {
                int index = rsetFileName.lastIndexOf(46);
                if (index != -1) {
                    rsetFileName = rsetFileName.substring(0, index);
                }
            } else {
                rsetFileName = "";
            }
            String dialogName = "Properties " + rsetFileName;
            WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(dialogName, "Properties", IconManager.IconType.DOCUMENT_LIST, true);
            final IdentificationPropertiesTableModel _model = new IdentificationPropertiesTableModel();
            windowBox.setEntryData(-1L, (Object)_model);
            DataBoxViewerTopComponent win2 = new DataBoxViewerTopComponent(windowBox);
            win2.open();
            win2.requestActive();
            final DataboxGeneric databoxGeneric = (DataboxGeneric)windowBox.getEntryBox();
            final GenericPanel _genericPanel = genericPanel = (GenericPanel)databoxGeneric.getPanel();
            final int loadingId = databoxGeneric.setLoading();
            RsetCallback dataLoadedCallback2 = new RsetCallback(nbResultSet){

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    --this.m_nbDataToLoad;
                    if (this.m_nbDataToLoad == 0) {
                        databoxGeneric.setLoaded(loadingId);
                        if (_model != null) {
                            _model.setData(projectId, resultSetList);
                            _genericPanel.setMaxLineNumber(_model.getRowCount());
                        }
                    }
                }

                public boolean mustBeCalledInAWT() {
                    return true;
                }
            };
            for (int i = 0; i < nbResultSet; ++i) {
                ResultSet rset = (ResultSet)resultSetList.get(i);
                DatabaseRsetProperties task = new DatabaseRsetProperties((AbstractDatabaseCallback)dataLoadedCallback2, projectId, rset, rset.getName());
                task.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(selectedRows.length > 0);
        }
    }

    private class ResultSetTable
    extends LazyTable
    implements ProgressInterface {
        public ResultSetTable() {
            MouseListener[] ls;
            super(RsetAllPanel.this.m_scrollPane.getVerticalScrollBar());
            this.setDragEnabled(true);
            TableTransferHandler handler = new TableTransferHandler();
            this.setTransferHandler(handler);
            this.setDefaultRenderer(Timestamp.class, new TimestampRenderer(this.getDefaultRenderer(String.class)));
            for (MouseListener l : ls = this.getMouseListeners()) {
                this.removeMouseListener(l);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    int row = RsetAllPanel.this.m_resultSetTable.rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    int[] selectedRows = RsetAllPanel.this.m_resultSetTable.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (selectedRows[i] != row) continue;
                        return;
                    }
                    if (e.isControlDown()) {
                        RsetAllPanel.this.m_resultSetTable.addRowSelectionInterval(row, row);
                    } else if (e.isShiftDown()) {
                        int maxIndex;
                        int minIndex = RsetAllPanel.this.m_resultSetTable.getSelectionModel().getMinSelectionIndex();
                        if (minIndex == -1 || row < minIndex) {
                            minIndex = row;
                        }
                        if ((maxIndex = RsetAllPanel.this.m_resultSetTable.getSelectionModel().getMaxSelectionIndex()) == -1 || row > maxIndex) {
                            maxIndex = row;
                        }
                        RsetAllPanel.this.m_resultSetTable.setRowSelectionInterval(minIndex, maxIndex);
                    } else {
                        RsetAllPanel.this.m_resultSetTable.setRowSelectionInterval(row, row);
                    }
                    ResultSetTable.this.getTransferHandler().exportAsDrag((JComponent)((Object)RsetAllPanel.this.m_resultSetTable), e, 1);
                }
            });
            for (MouseListener l : ls) {
                this.addMouseListener(l);
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsetAllPanel.this.m_dataBox.addDataChanged(ResultSet.class);
            RsetAllPanel.this.m_dataBox.propagateDataChanged();
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            popupMenu.addAction((AbstractTableAction)new PropertiesFromTableAction());
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }
    }
}

