/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.PeptideTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class RsmPeptidesOfProteinPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private PeptideTable m_peptidesTable;
    private JScrollPane m_scrollPane;
    private MarkerContainerPanel m_markerContainerPanel;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private DProteinMatch m_currentProteinMatch = null;
    private DPeptideMatch m_currentPeptideMatch = null;

    public RsmPeptidesOfProteinPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel peptidesPanel = this.createPeptidesPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peptidesPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peptidesPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_peptidesTable.getModel(), (SettingsInterface)this.m_peptidesTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_peptidesTable.getModel())){

            protected void filteringDone() {
                RsmPeptidesOfProteinPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsmPeptidesOfProteinPanel.this.m_dataBox.propagateDataChanged();
                RsmPeptidesOfProteinPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)this.m_peptidesTable.getModel(), "Peptides", (JXTable)this.m_peptidesTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_peptidesTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsmPeptidesOfProteinPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsmPeptidesOfProteinPanel.this.m_dataBox.getId(), RsmPeptidesOfProteinPanel.this.m_dataBox.getUserName(), RsmPeptidesOfProteinPanel.this.m_dataBox.getDataName(), RsmPeptidesOfProteinPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsmPeptidesOfProteinPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_peptidesTable.getModel(), (InfoInterface)this.m_peptidesTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createPeptidesPanel() {
        JPanel peptidesPanel = new JPanel();
        peptidesPanel.setBounds(0, 0, 500, 400);
        peptidesPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        peptidesPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        peptidesPanel.add((Component)toolbar, "West");
        return peptidesPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_peptidesTable = new PeptideTable();
        this.m_peptidesTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new PeptideTableModel(), true));
        this.m_peptidesTable.getColumnExt(this.m_peptidesTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_scrollPane = new JScrollPane();
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_peptidesTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_peptidesTable));
        this.m_peptidesTable.setFillsViewportHeight(true);
        this.m_peptidesTable.setViewport(this.m_scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public DPeptideInstance getSelectedPeptide() {
        int selectedIndex = this.m_peptidesTable.getSelectionModel().getMinSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        int indexInModelSelected = this.m_peptidesTable.convertRowIndexToModel(selectedIndex);
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_peptidesTable.getModel();
        indexInModelSelected = compoundTableModel.convertCompoundRowToBaseModelRow(indexInModelSelected);
        return ((PeptideTableModel)compoundTableModel.getBaseModel()).getPeptide(indexInModelSelected);
    }

    public void setData(DProteinMatch proteinMatch, DPeptideMatch peptideMatch, ResultSummary rsm) {
        boolean proteinMatchChanged;
        if (proteinMatch == this.m_currentProteinMatch && peptideMatch == this.m_currentPeptideMatch) {
            return;
        }
        boolean bl = proteinMatchChanged = proteinMatch != this.m_currentProteinMatch;
        if (proteinMatchChanged) {
            this.m_currentProteinMatch = proteinMatch;
            if (proteinMatch == null || rsm == null) {
                ((PeptideTableModel)((CompoundTableModel)this.m_peptidesTable.getModel()).getBaseModel()).setData(null);
            } else {
                DPeptideSet peptideSet = proteinMatch.getPeptideSet(Long.valueOf(rsm.getId()));
                DPeptideInstance[] peptideInstances = peptideSet.getPeptideInstances();
                ((PeptideTableModel)((CompoundTableModel)this.m_peptidesTable.getModel()).getBaseModel()).setData(peptideInstances);
            }
        }
        this.m_infoToggleButton.updateInfo();
        if (proteinMatch != null) {
            boolean peptideMatchChanged;
            boolean bl2 = peptideMatchChanged = peptideMatch != this.m_currentPeptideMatch;
            if ((!peptideMatchChanged || peptideMatchChanged && this.m_currentPeptideMatch == null) && proteinMatchChanged) {
                DPeptideSet peptideSet = proteinMatch.getPeptideSet(Long.valueOf(rsm.getId()));
                DPeptideInstance[] peptideInstances = peptideSet.getPeptideInstances();
                if (peptideInstances != null && peptideInstances.length > 0) {
                    this.m_peptidesTable.getSelectionModel().setSelectionInterval(0, 0);
                    this.m_markerContainerPanel.setMaxLineNumber(peptideInstances.length);
                    this.m_markerContainerPanel.removeAllMarkers();
                }
            } else if (peptideMatchChanged && !proteinMatchChanged) {
                int row = ((PeptideTableModel)((CompoundTableModel)this.m_peptidesTable.getModel()).getBaseModel()).findRow(peptideMatch.getId());
                if (row != -1) {
                    row = ((CompoundTableModel)this.m_peptidesTable.getModel()).convertBaseModelRowToCompoundRow(row);
                }
                this.m_peptidesTable.getSelectionModel().setSelectionInterval(row, row);
                this.m_peptidesTable.scrollRowToVisible(row);
            }
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_peptidesTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_peptidesTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_peptidesTable;
    }

    private class PeptideTable
    extends DecoratedMarkerTable
    implements InfoInterface {
        private DisplayTablePopupMenu m_popupMenu;

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsmPeptidesOfProteinPanel.this.m_dataBox.addDataChanged(DPeptideInstance.class);
            RsmPeptidesOfProteinPanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
            RsmPeptidesOfProteinPanel.this.m_dataBox.propagateDataChanged();
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(RsmPeptidesOfProteinPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            return count + (count > 1 ? " Peptides" : " Peptide");
        }
    }
}

