/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.mzscope.MzScope;
import fr.proline.mzscope.ui.event.ExtractionEvent;
import fr.proline.mzscope.ui.event.ExtractionStateListener;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.mzscope.MzdbInfo;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioMzScopePanel
extends HourglassPanel
implements DataBoxPanelInterface,
ExtractionStateListener {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private AbstractDataBox m_dataBox;
    private JScrollPane m_mzscopeScrollPane;
    private MzScope m_mzScope;
    private JPanel m_mzScopePanel;

    public StudioMzScopePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel mzscopePanel = this.createMzScopePanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                mzscopePanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)mzscopePanel, JLayeredPane.DEFAULT_LAYER);
    }

    private JPanel createMzScopePanel() {
        JPanel mzScopePanel = new JPanel();
        mzScopePanel.setBounds(0, 0, 500, 400);
        mzScopePanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        mzScopePanel.add((Component)toolbar, "West");
        mzScopePanel.add((Component)internalPanel, "Center");
        return mzScopePanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_mzScope = new MzScope();
        this.m_mzScopePanel = this.m_mzScope.createMzScopePanel(WindowManager.getDefault().getMainWindow());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_mzScopePanel, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        return toolbar;
    }

    public void setData(Long taskId, List<MzdbInfo> mzdbList, boolean finished) {
        for (MzdbInfo info : mzdbList) {
            int action;
            if (info.isMultiFile()) {
                List files = info.getMzdbFiles();
                action = info.getAction();
                switch (action) {
                    case 1: {
                        this.m_mzScope.openRaw(files, true);
                        break;
                    }
                    case 0: {
                        this.m_mzScope.openRaw(files, false);
                        this.m_mzScope.detectPeakels(files);
                        break;
                    }
                }
                continue;
            }
            File file = info.getMzdbFile();
            action = info.getAction();
            switch (action) {
                case 1: {
                    this.m_mzScope.openRaw(file, true);
                    break;
                }
                case 0: {
                    this.m_mzScope.openRaw(file, false);
                    this.m_mzScope.detectPeakels(file);
                    break;
                }
                case 2: {
                    this.m_mzScope.openRawAndExtract(file, info.getMoz().doubleValue(), info.getElutionTime().doubleValue(), info.getFirstScan().doubleValue(), info.getLastScan().doubleValue());
                    break;
                }
            }
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void extractionStateChanged(ExtractionEvent event) {
    }
}

