/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.id.ProjectId;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.parameters.CheckParameterInterface;
import fr.proline.studio.rsmexplorer.gui.calc.parameters.FunctionParametersDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.openide.windows.WindowManager;

public abstract class AbstractFunction
implements CheckParameterInterface {
    protected ArrayList<GlobalTableModelInterface> m_globalTableModelInterface;
    protected ParameterList[] m_parameters = null;
    private boolean m_calculating = false;
    private boolean m_inError = false;
    protected boolean m_settingsBeingDone = false;
    private String m_errorMessage = null;
    private ArrayList<SplittedPanelContainer.PanelLayout> m_autoDisplayLayoutDuringProcess = null;
    protected GraphPanel m_panel;
    private FUNCTION_TYPE m_type;

    public AbstractFunction(GraphPanel panel, FUNCTION_TYPE type) {
        this.m_panel = panel;
        this.m_type = type;
    }

    public int getTypeId() {
        return this.m_type.getId();
    }

    public void inLinkModified() {
        this.m_parameters = null;
        this.m_globalTableModelInterface = null;
    }

    public void setAutoDisplayLayoutDuringProcess(ArrayList<SplittedPanelContainer.PanelLayout> layout) {
        this.m_autoDisplayLayoutDuringProcess = layout;
    }

    public ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess() {
        return this.m_autoDisplayLayoutDuringProcess;
    }

    protected void setCalculating(boolean v) {
        if (v ^ this.m_calculating) {
            this.m_calculating = v;
            this.m_panel.repaint();
        }
    }

    protected void setInError(CalcError error) {
        if (error == null) {
            this.setInError(false, null);
        } else {
            this.setInError(true, error.getFullErrorMessage());
        }
    }

    protected void setInError(boolean v, String errorMessage) {
        if (v ^ this.m_inError) {
            this.m_inError = v;
            this.m_panel.repaint();
        }
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public String getName() {
        return this.getName(-1);
    }

    public abstract String getName(int var1);

    public abstract int getNumberOfInParameters();

    public abstract int getNumberOfOutParameters();

    public int getMaximumNumberOfInParameters() {
        return this.getNumberOfInParameters();
    }

    public String getOutTooltip(int index) {
        return null;
    }

    public abstract void process(GraphConnector[] var1, FunctionGraphNode var2, ProcessCallbackInterface var3);

    public abstract void askDisplay(FunctionGraphNode var1, int var2);

    public abstract ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode var1, int var2);

    public GlobalTableModelInterface getMainGlobalTableModelInterface(int index) {
        if (this.m_globalTableModelInterface == null) {
            return null;
        }
        return this.m_globalTableModelInterface.get(index);
    }

    public ArrayList<GlobalTableModelInterface> getGlobalTableModelInterfaceList() {
        return this.m_globalTableModelInterface;
    }

    public int getNumberOfResults() {
        if (this.m_globalTableModelInterface == null) {
            return 0;
        }
        return this.m_globalTableModelInterface.size();
    }

    public void addModel(GlobalTableModelInterface model) {
        if (this.m_globalTableModelInterface == null) {
            this.m_globalTableModelInterface = new ArrayList();
        }
        this.m_globalTableModelInterface.add(model);
    }

    public abstract void generateDefaultParameters(GraphConnector[] var1);

    public abstract void userParametersChanged();

    public abstract AbstractFunction cloneFunction(GraphPanel var1);

    protected void display(String dataName, String functionName, int resultIndex) {
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(dataName, functionName, IconManager.IconType.CHALKBOARD, false);
        ProjectId projectId = (ProjectId)this.m_globalTableModelInterface.get(resultIndex).getSingleValue(ProjectId.class);
        long id = projectId != null ? projectId.getId() : -1L;
        windowBox.setEntryData(id, this.m_globalTableModelInterface.get(resultIndex));
        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(windowBox);
        win.open();
        win.requestActive();
    }

    protected ArrayList<WindowBox> getDisplayWindowBoxList(String dataName, String functionName, int resultIndex) {
        if (this.m_globalTableModelInterface == null) {
            return null;
        }
        ArrayList<WindowBox> windowBoxList = null;
        int size = this.m_globalTableModelInterface.size();
        if (resultIndex == -1 || resultIndex >= size) {
            windowBoxList = new ArrayList<WindowBox>(size);
            for (int i = 0; i < size; ++i) {
                windowBoxList.add(this.getDisplayWindowBoxSingle(dataName, functionName, i));
            }
        } else {
            windowBoxList = new ArrayList(1);
            windowBoxList.add(this.getDisplayWindowBoxSingle(dataName, functionName, resultIndex));
        }
        return windowBoxList;
    }

    protected WindowBox getDisplayWindowBoxSingle(String dataName, String functionName, int resultIndex) {
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(dataName, functionName, IconManager.IconType.CHALKBOARD, false);
        ProjectId projectId = (ProjectId)this.m_globalTableModelInterface.get(resultIndex).getSingleValue(ProjectId.class);
        long id = projectId != null ? projectId.getId() : -1L;
        windowBox.setEntryData(id, this.m_globalTableModelInterface.get(resultIndex));
        return windowBox;
    }

    public abstract boolean calculationDone();

    public abstract boolean settingsDone();

    public boolean isCalculating() {
        return this.m_calculating;
    }

    public boolean inError() {
        return this.m_inError;
    }

    public void resetError() {
        this.m_inError = false;
        this.m_errorMessage = null;
    }

    public boolean isSettingsBeingDone() {
        return this.m_settingsBeingDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean settings(GraphConnector[] graphObjects, GraphNode node) {
        boolean thereIsNoParameterAtStart;
        boolean bl = thereIsNoParameterAtStart = this.m_parameters == null;
        if (thereIsNoParameterAtStart) {
            this.generateDefaultParameters(graphObjects);
        }
        if (this.m_parameters == null) {
            return false;
        }
        this.m_settingsBeingDone = true;
        try {
            FunctionParametersDialog dialog = new FunctionParametersDialog(this.getName(), WindowManager.getDefault().getMainWindow(), this.m_parameters, this, graphObjects);
            dialog.setImageInfo(this.m_panel, node.getX() - 60, node.getY() - 40, node.getXEnd() - node.getX() + 120, node.getYEnd() - node.getY() + 80);
            dialog.centerToWindow(WindowManager.getDefault().getMainWindow());
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                this.userParametersChanged();
                boolean bl2 = true;
                return bl2;
            }
            if (thereIsNoParameterAtStart) {
                this.m_parameters = null;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.m_settingsBeingDone = false;
        }
    }

    public ImageIcon getIcon() {
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.FUNCTION);
    }

    public Color getFrameColor() {
        return null;
    }

    public String getDataName() {
        return null;
    }

    public void cloneInfo(AbstractFunction src) {
        this.m_autoDisplayLayoutDuringProcess = src.m_autoDisplayLayoutDuringProcess;
    }

    public static enum FUNCTION_TYPE {
        AdjustPFunction(0),
        ColumnFilterFunction(1),
        ComputeFDRFunction(2),
        DiffAnalysisFunction(3),
        DiffFunction(4),
        ExpressionFunction(5),
        FilterFunction(6),
        ImportTSVFunction(7),
        JoinFunction(8),
        Log2Function(9),
        Log10Function(10),
        MissingValuesImputationFunction(11),
        NormalizationFunction(12),
        PValueFunction(13),
        QuantiFilterFunction(14),
        SCDiffAnalysisFunction(15),
        TtdFunction(16);

        private int m_id;

        private FUNCTION_TYPE(int id) {
            this.m_id = id;
        }

        public int getId() {
            return this.m_id;
        }
    }
}

