/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.graphics.cursor.CursorInfo;
import fr.proline.studio.graphics.cursor.CursorInfoList;
import fr.proline.studio.graphics.cursor.HorizontalCursor;
import fr.proline.studio.graphics.cursor.VerticalCursor;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ComponentParameterInterface;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.ValuesFromComponentParameter;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataboxGraphics;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.python.model.ExprTableModel;
import fr.proline.studio.python.model.ValuesTableModel;
import fr.proline.studio.rsmexplorer.gui.GraphicsPanel;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AdjustPFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.LockedDataGraphicsModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.types.LogInfo;
import fr.proline.studio.types.LogRatio;
import fr.proline.studio.types.PValue;
import fr.proline.studio.types.PvalueAdjusted;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.python.core.PyFloat;
import org.python.core.PyObject;

public class ComputeFDRFunction
extends AbstractFunction {
    private static final String PVALUE_THRESHOLD = "PVALUE_THRESHOLD";
    private static final String LOGFC_THRESHOLD = "LOGFC_THRESHOLD";
    private static final String PVALUE_COL_PARAMETER = "PVALUE_COL_PARAMETER";
    private static final String LOGFC_COL_PARAMETER = "FCLOG_COL_PARAMETER";
    private static final String PI0PARAMETER = "PI0PARAMETER";
    private static final String ALPHAPARAMETER = "ALPHAPARAMETER";
    private static final String NBBINSPARAMETER = "NBBINSPARAMETER";
    private static final String PZPARAMETER = "PZPARAMETER";
    private static final String NUMERICVALUEARAMETER = "NUMERICVALUEARAMETER";
    private ObjectParameter m_pValueColumnParameter = null;
    private ObjectParameter m_logFCColumnParameter = null;
    private DoubleParameter m_pvalueThresholdParameter;
    private DoubleParameter m_logFCThresholdParameter;
    private ObjectParameter m_pi0MethodParameter = null;
    private DoubleParameter m_numericValueParameter = null;
    private DoubleParameter m_alphaParameter = null;
    private IntegerParameter m_nbinsParameter = null;
    private DoubleParameter m_pzParameter = null;
    private ValuesFromComponentParameter m_graphicalParameter = null;
    private VerticalCursor m_verticalCursor = null;
    private VerticalCursor m_mirrorVerticalCursor = null;
    private HorizontalCursor m_horizontalCursor = null;
    public static final int OUT_DATA_FDR = 0;
    public static final int OUT_DATA_DIFFERENTIAL_PROTEINS = 1;
    public static final int OUT_VALUES_NUMBER = 2;
    private int m_stepCounts = 0;

    public ComputeFDRFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.ComputeFDRFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_pValueColumnParameter = null;
        this.m_logFCColumnParameter = null;
        this.m_pvalueThresholdParameter = null;
        this.m_logFCThresholdParameter = null;
        this.m_pi0MethodParameter = null;
        this.m_numericValueParameter = null;
        this.m_alphaParameter = null;
        this.m_nbinsParameter = null;
        this.m_pzParameter = null;
    }

    @Override
    public String getName(int index) {
        if (this.m_pi0MethodParameter == null) {
            return "FDR Computation";
        }
        StringBuilder columnNameSb = new StringBuilder("FDR Computation ");
        String pi0Method = this.m_pi0MethodParameter.getStringValue();
        if (pi0Method.compareTo("Numeric Value") == 0) {
            columnNameSb.append(this.m_numericValueParameter.getStringValue());
        } else {
            columnNameSb.append(pi0Method);
        }
        if (index >= 0) {
            columnNameSb.append(" / ");
            columnNameSb.append(this.getOutTooltip(index));
        }
        return columnNameSb.toString();
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 2;
    }

    @Override
    public String getOutTooltip(int index) {
        switch (index) {
            case 0: {
                return "FDR";
            }
            case 1: {
                return "Differential Proteins";
            }
        }
        return null;
    }

    @Override
    public void process(final GraphConnector[] graphObjects, final FunctionGraphNode functionGraphNode, final ProcessCallbackInterface callback) {
        this.setInError(false, null);
        if (this.m_parameters == null) {
            callback.finished(functionGraphNode);
            return;
        }
        Integer pvalueColIndex = (Integer)this.m_pValueColumnParameter.getAssociatedObjectValue();
        if (pvalueColIndex == null || pvalueColIndex == -1) {
            callback.finished(functionGraphNode);
            return;
        }
        Integer logFCColIndex = (Integer)this.m_logFCColumnParameter.getAssociatedObjectValue();
        if (logFCColIndex == null || logFCColIndex == -1) {
            callback.finished(functionGraphNode);
            return;
        }
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            final Table sourceTable = new Table(srcModel);
            ResultVariable[] parameters = new ResultVariable[2];
            ColRef pvalueCol = sourceTable.getCol(pvalueColIndex.intValue());
            parameters[0] = new ResultVariable((PyObject)pvalueCol);
            ColRef logFCCol = sourceTable.getCol(logFCColIndex.intValue());
            parameters[1] = new ResultVariable((PyObject)logFCCol);
            ResultVariable[] parametersForAdjustP = new ResultVariable[]{parameters[0]};
            StringBuilder codeSB1 = new StringBuilder();
            StringBuilder codeSB2 = new StringBuilder();
            codeSB1.append("computedFDR=Stats.computeFDR(");
            codeSB2.append("differentialProteins=Stats.differentialProteins(");
            StringBuilder codeSB3 = new StringBuilder();
            final StringBuilder columnNameSb3 = new StringBuilder();
            AdjustPFunction.createRCode(codeSB3, columnNameSb3, parametersForAdjustP, this.m_pi0MethodParameter, this.m_numericValueParameter, this.m_alphaParameter, this.m_nbinsParameter, this.m_pzParameter);
            StringBuilder codeSBFirstParameters = new StringBuilder();
            for (int i = 0; i < parameters.length; ++i) {
                codeSBFirstParameters.append(parameters[i].getName());
                codeSBFirstParameters.append(',');
            }
            codeSBFirstParameters.append(this.m_pvalueThresholdParameter.getStringValue());
            codeSBFirstParameters.append(',');
            codeSBFirstParameters.append(this.m_logFCThresholdParameter.getStringValue());
            String firstParameters = codeSBFirstParameters.toString();
            codeSB1.append(firstParameters);
            codeSB2.append(firstParameters);
            String pi0Method = this.m_pi0MethodParameter.getStringValue();
            if (pi0Method.compareTo("Numeric Value") == 0) {
                codeSB1.append(',');
                codeSB1.append(this.m_numericValueParameter.getStringValue());
            } else {
                codeSB1.append(",\"").append(pi0Method).append("\"");
            }
            codeSB1.append(",").append(this.m_alphaParameter.getStringValue());
            codeSB1.append(",").append(this.m_nbinsParameter.getStringValue());
            codeSB1.append(",").append(this.m_pzParameter.getStringValue());
            codeSB1.append(')');
            codeSB2.append(')');
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    ComputeFDRFunction.this.m_stepCounts++;
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("computedFDR") == 0) {
                                    PyFloat fdr = (PyFloat)var.getValue();
                                    ArrayList<String> valuesName = new ArrayList<String>(1);
                                    valuesName.add("FDR");
                                    ArrayList<String> values = new ArrayList<String>(1);
                                    values.add(fdr.toString() + "%");
                                    ComputeFDRFunction.this.addModel((GlobalTableModelInterface)new ValuesTableModel(valuesName, values));
                                    continue;
                                }
                                if (var.getName().compareTo("differentialProteins") == 0) {
                                    Table resTable = (Table)var.getValue();
                                    ExprTableModel model = (ExprTableModel)resTable.getModel();
                                    GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
                                    int[] cols = srcModel.getBestColIndex(PlotType.SCATTER_PLOT);
                                    int bestXColumnIndex = cols != null ? cols[0] : -1;
                                    int bestYColumnIndex = cols != null ? cols[1] : -1;
                                    CursorInfoList cursorInfoListX = new CursorInfoList();
                                    CursorInfo cursorInfo1 = new CursorInfo(ComputeFDRFunction.this.m_verticalCursor.getValue());
                                    cursorInfo1.setColor(Color.blue);
                                    cursorInfo1.setStroke(AbstractCursor.LINE2_STROKE);
                                    cursorInfo1.setSelectable(Boolean.FALSE);
                                    cursorInfoListX.addCursorInfo(cursorInfo1);
                                    CursorInfo cursorInfo2 = new CursorInfo(ComputeFDRFunction.this.m_mirrorVerticalCursor.getValue());
                                    cursorInfo2.setColor(Color.blue);
                                    cursorInfo2.setStroke(AbstractCursor.LINE2_STROKE);
                                    cursorInfo2.setSelectable(Boolean.FALSE);
                                    cursorInfoListX.addCursorInfo(cursorInfo2);
                                    model.addExtraColumnInfo(bestXColumnIndex, (Object)cursorInfoListX);
                                    CursorInfoList cursorInfoListY = new CursorInfoList();
                                    CursorInfo cursorInfoY = new CursorInfo(ComputeFDRFunction.this.m_horizontalCursor.getValue());
                                    cursorInfoY.setColor(Color.blue);
                                    cursorInfoY.setStroke(AbstractCursor.LINE2_STROKE);
                                    cursorInfoY.setSelectable(Boolean.FALSE);
                                    cursorInfoListY.addCursorInfo(cursorInfoY);
                                    model.addExtraColumnInfo(bestYColumnIndex, (Object)cursorInfoListY);
                                    ComputeFDRFunction.this.addModel((GlobalTableModelInterface)model);
                                    continue;
                                }
                                if (var.getName().compareTo("adjustP") != 0) continue;
                                ColDoubleData col = (ColDoubleData)var.getValue();
                                col.setColumnName(columnNameSb3.toString());
                                sourceTable.addColumn((Col)col, (Object)new PvalueAdjusted(), (TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true));
                            }
                        } else if (error != null) {
                            ComputeFDRFunction.this.setInError(error);
                        }
                        ComputeFDRFunction.this.setCalculating(false);
                    }
                    finally {
                        if (ComputeFDRFunction.this.m_stepCounts == 3) {
                            callback.finished(functionGraphNode);
                        }
                    }
                }
            };
            this.m_stepCounts = 0;
            CalcInterpreterTask task1 = new CalcInterpreterTask(codeSB1.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task1);
            CalcInterpreterTask task3 = new CalcInterpreterTask(codeSB3.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task3);
            CalcInterpreterTask task2 = new CalcInterpreterTask(codeSB2.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task2);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        int nbColumns = model1.getColumnCount();
        int nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            ++nbColumnsKept;
        }
        Object[] pValueObjectArray = new Object[nbColumnsKept];
        Object[] pValueAssociatedObjectArray = new Object[nbColumnsKept];
        int iKept = 0;
        int selectedIndexPValue = -1;
        for (int i = 0; i < nbColumns; ++i) {
            LogInfo log;
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            pValueObjectArray[iKept] = model1.getColumnName(i);
            PValue pvalue = (PValue)model1.getColValue(PValue.class, i);
            if (pvalue != null && ((log = (LogInfo)model1.getColValue(LogInfo.class, i)) == null || log.noLog())) {
                selectedIndexPValue = iKept;
            }
            pValueAssociatedObjectArray[iKept] = i + 1;
            ++iKept;
        }
        Object[] logFCObjectArray = new Object[nbColumnsKept];
        Object[] logFCAssociatedObjectArray = new Object[nbColumnsKept];
        iKept = 0;
        int selectedIndexLogFC = -1;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            logFCObjectArray[iKept] = model1.getColumnName(i);
            LogRatio logRatio = (LogRatio)model1.getColValue(LogRatio.class, i);
            if (logRatio != null) {
                selectedIndexLogFC = iKept;
            }
            logFCAssociatedObjectArray[iKept] = i + 1;
            ++iKept;
        }
        ParameterList parameterList1 = new ParameterList("param1");
        this.m_pValueColumnParameter = new ObjectParameter(PVALUE_COL_PARAMETER, "P Values Column", null, pValueObjectArray, pValueAssociatedObjectArray, selectedIndexPValue, null);
        this.m_logFCColumnParameter = new ObjectParameter(LOGFC_COL_PARAMETER, "Log FC Column", null, logFCObjectArray, logFCAssociatedObjectArray, selectedIndexLogFC, null);
        this.m_pvalueThresholdParameter = new DoubleParameter(PVALUE_THRESHOLD, "-Log10(PValue) Threshold", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        this.m_logFCThresholdParameter = new DoubleParameter(LOGFC_THRESHOLD, "Log FC Threshold", JTextField.class, Double.valueOf(0.0), Double.valueOf(0.0), null);
        Object[] pi0Values = new String[]{"Numeric Value", "abh", "bky", "jiang", "histo", "langaas", "pounds", "slim", "st.boot", "st.spline"};
        this.m_pi0MethodParameter = new ObjectParameter(PI0PARAMETER, "pi0 Method", pi0Values, 0, null);
        this.m_numericValueParameter = new DoubleParameter(NUMERICVALUEARAMETER, "Pi0 Value", JTextField.class, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_alphaParameter = new DoubleParameter(ALPHAPARAMETER, "Alpha", JTextField.class, Double.valueOf(0.05), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_nbinsParameter = new IntegerParameter(NBBINSPARAMETER, "Number of Bins", JSpinner.class, Integer.valueOf(20), Integer.valueOf(5), Integer.valueOf(100));
        this.m_pzParameter = new DoubleParameter(PZPARAMETER, "Pz", JTextField.class, Double.valueOf(0.05), Double.valueOf(0.01), Double.valueOf(0.1));
        final GraphicsPanel graphicsPanel = this.createScatterParameter(model1);
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(parameterList1){

            public void valueChanged(String value, Object associatedValue) {
                this.showParameter((AbstractParameter)ComputeFDRFunction.this.m_numericValueParameter, value.compareTo("Numeric Value") == 0);
                this.showParameter((AbstractParameter)ComputeFDRFunction.this.m_alphaParameter, value.compareTo("bky") == 0);
                this.showParameter((AbstractParameter)ComputeFDRFunction.this.m_nbinsParameter, value.compareTo("jiang") == 0 || value.compareTo("histo") == 0);
                this.showParameter((AbstractParameter)ComputeFDRFunction.this.m_pzParameter, value.compareTo("slim") == 0);
                this.updateParameterListPanel();
            }
        };
        AbstractLinkedParameters graphicalLinkParameterVerticalCursor = new AbstractLinkedParameters(parameterList1){

            public void valueChanged(String value, Object associatedValue) {
                Double d = (Double)associatedValue;
                ComputeFDRFunction.this.m_verticalCursor.setValue(d.doubleValue());
                ComputeFDRFunction.this.m_mirrorVerticalCursor.setValue(-d.doubleValue());
                graphicsPanel.getPlotPanel().repaint();
            }
        };
        AbstractLinkedParameters graphicalLinkParameterHorizontalCursor = new AbstractLinkedParameters(parameterList1){

            public void valueChanged(String value, Object associatedValue) {
                Double d = (Double)associatedValue;
                ComputeFDRFunction.this.m_horizontalCursor.setValue(d.doubleValue());
                graphicsPanel.getPlotPanel().repaint();
            }
        };
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterList1;
        parameterList1.add((Object)this.m_pValueColumnParameter);
        parameterList1.add((Object)this.m_logFCColumnParameter);
        parameterList1.add((Object)this.m_pvalueThresholdParameter);
        parameterList1.add((Object)this.m_logFCThresholdParameter);
        parameterList1.add((Object)this.m_pi0MethodParameter);
        parameterList1.add((Object)this.m_numericValueParameter);
        parameterList1.add((Object)this.m_alphaParameter);
        parameterList1.add((Object)this.m_nbinsParameter);
        parameterList1.add((Object)this.m_pzParameter);
        parameterList1.add((Object)this.m_graphicalParameter);
        parameterList1.getPanel();
        this.m_pi0MethodParameter.addLinkedParameters(linkedParameters);
        this.m_logFCThresholdParameter.addLinkedParameters(graphicalLinkParameterVerticalCursor);
        this.m_pvalueThresholdParameter.addLinkedParameters(graphicalLinkParameterHorizontalCursor);
        this.m_nbinsParameter.getComponent().setEnabled(false);
        this.m_pzParameter.getComponent().setEnabled(false);
        this.m_alphaParameter.getComponent().setEnabled(false);
    }

    private GraphicsPanel createScatterParameter(GlobalTableModelInterface srcModel) {
        int[] cols = srcModel.getBestColIndex(PlotType.SCATTER_PLOT);
        LockedDataGraphicsModel graphicsModelInterface = new LockedDataGraphicsModel((ExtendedTableModelInterface)srcModel, PlotType.SCATTER_PLOT, cols);
        DataboxGraphics box = new DataboxGraphics(true);
        ((AbstractDataBox)box).createPanel();
        ((AbstractDataBox)box).setEntryData((Object)graphicsModelInterface);
        GraphicsPanel graphicsPanel = (GraphicsPanel)box.getPanel();
        PlotBaseAbstract plot = graphicsPanel.getPlotGraphics();
        final BasePlotPanel basePlotPanel = plot.getBasePlotPanel();
        basePlotPanel.setPreferredSize(new Dimension(600, 400));
        this.m_verticalCursor = new VerticalCursor(basePlotPanel, 0.0);
        this.m_verticalCursor.setMinValue(new Double(0.0));
        this.m_verticalCursor.setColor(Color.blue);
        this.m_verticalCursor.setStroke(AbstractCursor.LINE2_STROKE);
        this.m_mirrorVerticalCursor = new VerticalCursor(basePlotPanel, 0.0);
        this.m_mirrorVerticalCursor.setColor(Color.blue);
        this.m_mirrorVerticalCursor.setStroke(AbstractCursor.LINE2_STROKE);
        this.m_horizontalCursor = new HorizontalCursor(basePlotPanel, 0.0);
        this.m_horizontalCursor.setMinValue(new Double(0.0));
        this.m_horizontalCursor.setColor(Color.blue);
        this.m_horizontalCursor.setStroke(AbstractCursor.LINE2_STROKE);
        plot.addCursor((AbstractCursor)this.m_horizontalCursor);
        plot.addCursor((AbstractCursor)this.m_mirrorVerticalCursor);
        plot.addCursor((AbstractCursor)this.m_verticalCursor);
        ComponentParameterInterface componentParameter = new ComponentParameterInterface(){

            public JComponent getComponent() {
                return basePlotPanel;
            }

            public ParameterError checkParameter() {
                return null;
            }

            public String getStringValue() {
                return String.valueOf(ComputeFDRFunction.this.m_verticalCursor.getValue());
            }

            public Object getObjectValue() {
                return ComputeFDRFunction.this.m_verticalCursor.getValue();
            }

            public void actionPerformed(ActionEvent e) {
                AbstractCursor c = (AbstractCursor)e.getSource();
                if (c instanceof VerticalCursor) {
                    String v = ((VerticalCursor)c).getFormattedValue();
                    double d = new BigDecimal(v = v.replaceAll(",", ".")).doubleValue();
                    if (d < 0.0) {
                        d = -d;
                    }
                    ComputeFDRFunction.this.m_logFCThresholdParameter.setValue(String.valueOf(d));
                } else if (c instanceof HorizontalCursor) {
                    String v = ((HorizontalCursor)c).getFormattedValue();
                    v = v.replaceAll(",", ".");
                    double d = new BigDecimal(v).doubleValue();
                    ComputeFDRFunction.this.m_pvalueThresholdParameter.setValue(String.valueOf(d));
                }
            }
        };
        this.m_verticalCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalCursor c = (VerticalCursor)e.getSource();
                double v = c.getValue();
                if (ComputeFDRFunction.this.m_mirrorVerticalCursor.getValue() == -v) {
                    return;
                }
                ComputeFDRFunction.this.m_mirrorVerticalCursor.setValue(-v);
            }
        });
        this.m_verticalCursor.addActionListener((ActionListener)componentParameter);
        this.m_mirrorVerticalCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalCursor c = (VerticalCursor)e.getSource();
                double v = c.getValue();
                if (ComputeFDRFunction.this.m_verticalCursor.getValue() == -v) {
                    return;
                }
                ComputeFDRFunction.this.m_verticalCursor.setValue(-v);
            }
        });
        this.m_mirrorVerticalCursor.addActionListener((ActionListener)componentParameter);
        this.m_horizontalCursor.addActionListener((ActionListener)componentParameter);
        this.m_graphicalParameter = new ValuesFromComponentParameter("LogFCAndPValue", "LogFCAndPValue", componentParameter);
        this.m_graphicalParameter.forceShowLabel(AbstractParameter.LabelVisibility.NO_VISIBLE);
        return graphicsPanel;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        ComputeFDRFunction clone = new ComputeFDRFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null && !this.m_globalTableModelInterface.isEmpty();
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null) {
            return false;
        }
        if (this.m_pValueColumnParameter == null) {
            return false;
        }
        Integer colIndex = (Integer)this.m_pValueColumnParameter.getAssociatedObjectValue();
        return colIndex != null && colIndex != -1;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }
}

