/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngine;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class FunctionGraphNode
extends GraphNode {
    private static final Color FRAME_COLOR = new Color(149, 195, 95);
    private final AbstractFunction m_function;

    public FunctionGraphNode(AbstractFunction function, GraphPanel panel) {
        super(panel);
        int nbInParameters;
        this.m_function = function;
        int nbOutParameters = function.getNumberOfOutParameters();
        if (nbOutParameters > 0) {
            this.m_outConnector = new LinkedList();
            for (int i = 0; i < nbOutParameters; ++i) {
                this.m_outConnector.add(new GraphConnector(this, true, i, panel));
            }
        }
        if ((nbInParameters = function.getNumberOfInParameters()) > 0) {
            this.m_inConnectors = new LinkedList();
            for (int i = 0; i < nbInParameters; ++i) {
                this.m_inConnectors.add(new GraphConnector(this, false, i, panel));
            }
        }
    }

    @Override
    public String getFullName() {
        String dataName = this.getDataName();
        if (dataName == null) {
            return this.m_function.getName();
        }
        return dataName + ' ' + this.m_function.getName();
    }

    @Override
    public String getFullName(int index) {
        if (index >= 0) {
            return this.getFullName() + " / " + this.getOutTooltip(index);
        }
        return this.getFullName();
    }

    @Override
    public String getDataName() {
        String dataName = this.m_function.getDataName();
        if (dataName != null) {
            return dataName;
        }
        return this.getPreviousDataName();
    }

    @Override
    public String getTypeName() {
        return this.m_function.getName();
    }

    @Override
    public String getErrorMessage() {
        return this.m_function.getErrorMessage();
    }

    @Override
    public Color getFrameColor() {
        Color frameColor = this.m_function.getFrameColor();
        if (frameColor != null) {
            return frameColor;
        }
        return FRAME_COLOR;
    }

    @Override
    public ImageIcon getIcon() {
        return this.m_function.getIcon();
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (!this.isConnected(false)) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.WARNING);
        }
        if (!this.isConnected(true)) {
            return null;
        }
        if (!this.settingsDone()) {
            if (this.canSetSettings()) {
                return IconManager.getIcon((IconManager.IconType)IconManager.IconType.SETTINGS);
            }
            return null;
        }
        if (this.m_function.isCalculating()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS);
        }
        if (this.m_function.inError()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXCLAMATION);
        }
        if (this.m_function.calculationDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_CIRCLE);
        }
        if (this.m_function.isSettingsBeingDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.SETTINGS);
        }
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.CONTROL_PLAY);
    }

    @Override
    public ImageIcon getDisplayIcon() {
        if (this.m_function.calculationDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE);
        }
        return null;
    }

    @Override
    public GraphNode.NodeAction possibleAction() {
        if (!this.isConnected(true)) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        if (!this.settingsDone()) {
            return this.canSetSettings() ? GraphNode.NodeAction.STEP_ACTION : GraphNode.NodeAction.NO_ACTION;
        }
        if (this.m_function.isCalculating()) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        if (this.m_function.inError()) {
            return GraphNode.NodeAction.ERROR_ACTION;
        }
        if (this.m_function.calculationDone()) {
            return GraphNode.NodeAction.RESULT_ACTION;
        }
        if (this.m_function.isSettingsBeingDone()) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        return GraphNode.NodeAction.STEP_ACTION;
    }

    @Override
    public void doAction(int x, int y) {
        if (this.m_graphNodeAction.isHighlighted()) {
            this.m_graphNodeAction.setHighlighted(false);
            if (!this.settingsDone()) {
                int nbConnections = this.m_inConnectors == null ? 0 : this.m_inConnectors.size();
                new GraphNode.SettingsAction(this, this, nbConnections).actionPerformed(null);
                return;
            }
            if (this.m_function.inError()) {
                new GraphNode.ErrorAction(this, this).actionPerformed(null);
                return;
            }
            if (this.m_function.calculationDone()) {
                new GraphNode.DisplayInNewWindowAction(this, this, 0, null).actionPerformed(null);
                return;
            }
            new GraphNode.ProcessAction(this, this).actionPerformed(null);
        } else if (this.m_menuAction.isHighlighted()) {
            this.m_menuAction.setHighlighted(false);
            JPopupMenu popup = this.createPopup(this.m_graphPanel);
            if (popup != null) {
                popup.show(this.m_graphPanel, x, y);
            }
        }
    }

    @Override
    public boolean canBeProcessed() {
        return this.isConnected(true) && this.settingsDone() && !this.m_function.isCalculating() && !this.m_function.inError() && !this.m_function.calculationDone() && !this.m_function.isSettingsBeingDone();
    }

    @Override
    public void propagateSourceChanged() {
        this.m_function.inLinkModified();
        super.propagateSourceChanged();
    }

    @Override
    public boolean isConnected(boolean recursive) {
        int countUnlinkedConnectors = this.m_function.getNumberOfInParameters();
        if (this.m_inConnectors != null) {
            for (GraphConnector connector : this.m_inConnectors) {
                if (!connector.isConnected(recursive)) continue;
                --countUnlinkedConnectors;
            }
        }
        return countUnlinkedConnectors <= 0;
    }

    @Override
    public boolean canAddConnector() {
        if (this.m_inConnectors == null) {
            return true;
        }
        return this.m_function.getMaximumNumberOfInParameters() - this.m_inConnectors.size() > 0;
    }

    @Override
    public void addFreeConnector() {
        this.m_inConnectors.add(new GraphConnector(this, false, this.m_inConnectors.size(), this.m_graphPanel));
        this.setConnectorsPosition();
    }

    @Override
    public void updateNumberOfInConnections() {
        int nbInParameters = this.m_function.getNumberOfInParameters();
        boolean modification = false;
        for (int nbConnections = this.m_inConnectors.size(); nbConnections > 2 && nbConnections > nbInParameters && !((GraphConnector)this.m_inConnectors.get(nbConnections - 1)).isConnected(false) && !((GraphConnector)this.m_inConnectors.get(this.m_inConnectors.size() - 2)).isConnected(false); --nbConnections) {
            this.m_inConnectors.removeLast();
            modification = true;
        }
        if (modification) {
            this.setConnectorsPosition();
        }
    }

    @Override
    public boolean canSetSettings() {
        if (!this.isConnected(true)) {
            return false;
        }
        int countSettingsDone = this.m_function.getNumberOfInParameters();
        if (this.m_inConnectors != null) {
            for (GraphConnector connector : this.m_inConnectors) {
                GraphNode graphNode;
                if (!connector.isConnected(true) || !(graphNode = connector.getLinkedSourceGraphConnector().getGraphNode()).settingsDone() || !graphNode.calculationDone()) continue;
                --countSettingsDone;
            }
        }
        return countSettingsDone <= 0;
    }

    @Override
    public boolean settingsDone() {
        return this.m_function.settingsDone();
    }

    @Override
    public boolean calculationDone() {
        if (!this.isConnected(true)) {
            return false;
        }
        if (!this.settingsDone()) {
            return false;
        }
        return this.m_function.calculationDone();
    }

    @Override
    public void process(ProcessCallbackInterface callback) {
        GraphConnector[] graphObjectArray;
        if (!this.isConnected(true)) {
            callback.finished(this);
            return;
        }
        if (!this.m_function.settingsDone()) {
            boolean settingsDone = this.settings();
            this.m_graphPanel.repaint();
            if (!settingsDone) {
                callback.stopped(this);
            } else {
                callback.reprocess(this);
            }
            return;
        }
        if (this.m_inConnectors != null) {
            int nbLinkedConnectors = 0;
            for (GraphConnector connector : this.m_inConnectors) {
                GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
                if (srcConnector == null) continue;
                ++nbLinkedConnectors;
            }
            graphObjectArray = new GraphConnector[nbLinkedConnectors];
            int i = 0;
            for (GraphConnector connector : this.m_inConnectors) {
                GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
                if (srcConnector == null) continue;
                graphObjectArray[i++] = srcConnector;
            }
        } else {
            graphObjectArray = new GraphConnector[]{};
        }
        this.m_function.process(graphObjectArray, this, callback);
    }

    @Override
    public void askDisplay(int index) {
        this.m_function.askDisplay(this, index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(int index) {
        return this.m_function.getDisplayWindowBox(this, index);
    }

    @Override
    public ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess() {
        return this.m_function.getAutoDisplayLayoutDuringProcess();
    }

    @Override
    public boolean settings() {
        boolean settingsChanged;
        GraphConnector[] graphObjectArray;
        if (this.m_inConnectors != null) {
            int nbLinkedConnectors = 0;
            for (GraphConnector connector : this.m_inConnectors) {
                GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
                if (srcConnector == null) continue;
                ++nbLinkedConnectors;
            }
            graphObjectArray = new GraphConnector[nbLinkedConnectors];
            int i = 0;
            for (GraphConnector connector : this.m_inConnectors) {
                GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
                if (srcConnector == null) continue;
                graphObjectArray[i++] = srcConnector;
            }
        } else {
            graphObjectArray = new GraphConnector[]{};
        }
        if (settingsChanged = this.m_function.settings(graphObjectArray, this)) {
            this.m_function.resetError();
            super.propagateSourceChanged();
            if (!ProcessEngine.getProcessEngine().isRunAll()) {
                ProcessEngine.getProcessEngine().runANode(this, this.m_graphPanel);
            }
        }
        return settingsChanged;
    }

    @Override
    public GlobalTableModelInterface getGlobalTableModelInterface(int index) {
        return this.m_function.getMainGlobalTableModelInterface(index);
    }

    @Override
    public String getOutTooltip(int index) {
        return this.m_function.getOutTooltip(index);
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }

    @Override
    public void saveGraph(StringBuilder sb) {
        sb.append("<graphnode id=\"").append(this.m_id).append("\" x=\"").append(this.getCenterX()).append("\" y=\"").append(this.getCenterY()).append("\" type=\"Function\"").append(" subtype=\"").append(this.m_function.getTypeId()).append('\"').append(">");
        sb.append("</graphnode>");
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                connector.saveGraph(sb);
            }
        }
    }
}

