/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.LinkedList;
import javax.swing.JPopupMenu;

public class GraphGroup
extends AbstractGraphObject {
    private static final int DELTA_PIXEL_TOP = 50;
    private static final int DELTA_PIXEL = 25;
    private LinkedList<GraphNode> m_groupedGraphNodes = new LinkedList();
    private final String m_groupName;
    private int m_xMin = 0;
    private int m_yMin = 0;
    private int m_xMax = 0;
    private int m_yMax = 0;

    public GraphGroup(String groupName) {
        super(AbstractGraphObject.TypeGraphObject.GROUP);
        this.m_groupName = groupName;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public void addObject(GraphNode graphNode) {
        this.m_groupedGraphNodes.add(graphNode);
        graphNode.setGroup(this);
        this.calculatePosition();
    }

    public void removeObject(GraphNode graphNode) {
        this.m_groupedGraphNodes.remove(graphNode);
        this.calculatePosition();
    }

    public void objectMoved() {
        this.calculatePosition();
    }

    private void calculatePosition() {
        this.m_xMin = Integer.MAX_VALUE;
        this.m_yMin = Integer.MAX_VALUE;
        this.m_xMax = 0;
        this.m_yMax = 0;
        for (GraphNode graphNode : this.m_groupedGraphNodes) {
            int y2;
            int x2;
            int y1;
            int x1 = graphNode.getX();
            if (x1 < this.m_xMin) {
                this.m_xMin = x1;
            }
            if ((y1 = graphNode.getY()) < this.m_yMin) {
                this.m_yMin = y1;
            }
            if ((x2 = graphNode.getXEnd()) > this.m_xMax) {
                this.m_xMax = x2;
            }
            if ((y2 = graphNode.getYEnd()) <= this.m_yMax) continue;
            this.m_yMax = y2;
        }
        this.m_xMin -= 25;
        this.m_yMin -= 50;
        this.m_xMax += 25;
        this.m_yMax += 25;
    }

    private void initFonts(Graphics g) {
        if (m_font != null) {
            return;
        }
        m_font = new Font(" TimesRoman ", 0, 11);
        m_fontBold = m_font.deriveFont(1);
        FontMetrics metricsBold = g.getFontMetrics(m_fontBold);
        FontMetrics metricsPlain = g.getFontMetrics(m_font);
        m_hgtBold = metricsBold.getHeight();
        m_ascentBold = metricsBold.getAscent();
        m_hgtPlain = metricsPlain.getHeight();
    }

    @Override
    public void draw(Graphics g) {
        if (this.m_groupedGraphNodes.isEmpty()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.initFonts(g);
        g.setColor(Color.gray);
        Stroke previousStroke = g2.getStroke();
        BasicStroke stroke = this.m_selected ? STROKE_SELECTED : STROKE_NOT_SELECTED;
        g2.setStroke(stroke);
        g.drawRoundRect(this.m_xMin, this.m_yMin, this.m_xMax - this.m_xMin, this.m_yMax - this.m_yMin, 8, 8);
        g2.setStroke(previousStroke);
        FontMetrics metricsBold = g.getFontMetrics(m_fontBold);
        int stringWidth = metricsBold.stringWidth(this.m_groupName);
        int xText = this.m_xMin + (this.m_xMax - this.m_xMin - stringWidth) / 2;
        int yText = this.m_yMin - m_hgtBold;
        g.setFont(m_fontBold);
        g.setColor(Color.black);
        g.drawString(this.m_groupName, xText, yText);
    }

    @Override
    public AbstractGraphObject inside(int x, int y) {
        if (x >= this.m_xMin && y >= this.m_yMin && x <= this.m_xMax && y <= this.m_yMin) {
            return this;
        }
        return null;
    }

    @Override
    public void move(int dx, int dy) {
    }

    @Override
    public void delete() {
    }

    @Override
    public JPopupMenu createPopup(GraphPanel panel) {
        return null;
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }
}

