/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngine;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractConnectedGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNodeAction;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.openide.windows.WindowManager;

public abstract class GraphNode
extends AbstractConnectedGraphObject {
    public static final int WIDTH = 60;
    public static final int HEIGHT_MIN = 60;
    private static final int MARGIN = 5;
    protected LinkedList<GraphConnector> m_inConnectors = null;
    protected LinkedList<GraphConnector> m_outConnector = null;
    protected int m_x = 0;
    protected int m_y = 0;
    protected int m_extraHeight = 0;
    protected GraphNodeAction m_graphNodeAction = new GraphNodeAction();
    protected GraphNodeAction m_menuAction = new GraphNodeAction();
    protected GraphPanel m_graphPanel = null;
    private long m_startTime = System.currentTimeMillis();
    protected int m_id;
    public static int INCREMANTAL_ID = 0;
    private LinearGradientPaint m_gradient = null;
    private int m_gradientStartY = -1;

    public GraphNode(GraphPanel panel) {
        super(AbstractGraphObject.TypeGraphObject.GRAPH_NODE);
        this.m_graphPanel = panel;
        this.m_menuAction.setAction(true);
        this.m_id = INCREMANTAL_ID++;
    }

    public int getId() {
        return this.m_id;
    }

    public GraphConnector getFirstFreeConnector() {
        if (this.m_inConnectors == null) {
            return null;
        }
        for (GraphConnector inConnector : this.m_inConnectors) {
            if (inConnector.isConnected(false)) continue;
            return inConnector;
        }
        return null;
    }

    public boolean canAddConnector() {
        return false;
    }

    public void addFreeConnector() {
    }

    public void updateNumberOfInConnections() {
    }

    public void connectTo(GraphNode inGraphNode, int outConnectorIndex) {
        GraphConnector inConnector = inGraphNode.getFirstFreeConnector();
        this.m_outConnector.get(outConnectorIndex).addConnection(inConnector);
        inConnector.addConnection(this.m_outConnector.get(0));
    }

    public boolean hasInConnector() {
        return this.m_inConnectors != null && !this.m_inConnectors.isEmpty();
    }

    public void propagateSourceChanged() {
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                connector.propagateSourceChanged();
            }
        }
    }

    public void setCenter(int x, int y) {
        this.m_x = x - 30;
        this.m_y = y - (60 + this.m_extraHeight) / 2;
        if (this.m_x < 40) {
            this.m_x = 40;
        }
        if (this.m_y < 40) {
            this.m_y = 40;
        }
        this.setConnectorsPosition();
        if (this.m_group != null) {
            this.m_group.objectMoved();
        }
    }

    public int getCenterX() {
        return this.m_x + 30;
    }

    public int getCenterY() {
        return this.m_y + (60 + this.m_extraHeight) / 2;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getXEnd() {
        return this.m_x + 60;
    }

    public int getYEnd() {
        return this.m_y + (60 + this.m_extraHeight);
    }

    public abstract String getErrorMessage();

    @Override
    public void draw(Graphics g) {
        ImageIcon displayIcon;
        Graphics2D g2 = (Graphics2D)g;
        this.initFonts(g);
        String dataName = this.getDataName();
        String typeName = this.getTypeName();
        if (this.m_hightlighted) {
            g2.setColor(this.getFrameColor().brighter());
            g.fillRoundRect(this.m_x - 5, this.m_y - 5, 70, 60 + this.m_extraHeight + 10, 8, 8);
        }
        LinearGradientPaint gradient = this.getBackgroundGradient();
        g2.setPaint(gradient);
        g.fillRoundRect(this.m_x, this.m_y, 60, 60 + this.m_extraHeight, 8, 8);
        g.setColor(this.getFrameColor());
        Stroke previousStroke = g2.getStroke();
        BasicStroke stroke = this.m_selected || this.m_hightlighted ? STROKE_SELECTED : STROKE_NOT_SELECTED;
        g2.setStroke(stroke);
        g.drawRoundRect(this.m_x, this.m_y, 60, 60 + this.m_extraHeight, 8, 8);
        g2.setStroke(previousStroke);
        FontMetrics metricsBold = g.getFontMetrics(m_fontBold);
        int stringWidth = metricsBold.stringWidth(typeName);
        int xText = this.m_x + (60 - stringWidth) / 2;
        int yText = this.m_y - m_hgtBold;
        ImageIcon icon = this.getIcon();
        if (icon != null) {
            g.drawImage(icon.getImage(), this.m_x + 5, this.m_y + 5, null);
        }
        ImageIcon menuIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.MENU);
        int wIcon = menuIcon.getIconWidth();
        int hIcon = menuIcon.getIconHeight();
        int xIcon = this.m_x + 60 - 5 - menuIcon.getIconWidth();
        int yIcon = this.m_y + 5;
        g.drawImage(menuIcon.getImage(), xIcon, yIcon, null);
        this.m_menuAction.setBounds(xIcon - 2, yIcon - 2, wIcon + 4, hIcon + 4);
        this.m_menuAction.draw(g);
        NodeAction possibleAction = this.possibleAction();
        this.m_graphNodeAction.setAction(possibleAction != NodeAction.NO_ACTION);
        ImageIcon statusIcon = this.getStatusIcon();
        if (statusIcon != null) {
            wIcon = statusIcon.getIconWidth();
            hIcon = statusIcon.getIconHeight();
            xIcon = this.m_x + 5;
            yIcon = this.m_y + (60 + this.m_extraHeight) - 5 - statusIcon.getIconHeight();
            if (possibleAction == NodeAction.STEP_ACTION || possibleAction == NodeAction.ERROR_ACTION) {
                this.m_graphNodeAction.setBounds(xIcon - 2, yIcon - 2, wIcon + 4, hIcon + 4);
                this.m_graphNodeAction.setAction(true);
                this.m_graphNodeAction.draw(g);
            }
            g.drawImage(statusIcon.getImage(), xIcon, yIcon, null);
            if (possibleAction == NodeAction.STEP_ACTION || possibleAction == NodeAction.ERROR_ACTION) {
                int LINE_LENGTH = 3;
                g.setColor(this.getFrameColor().darker());
                double coef = (double)(System.currentTimeMillis() - this.m_startTime) / 1000.0;
                coef %= 3.0;
                coef = coef >= 1.0 ? 0.0 : (coef -= (double)((int)coef));
                double theta = Math.toRadians(180.0 * coef);
                g2.rotate(theta, xIcon + wIcon / 2, yIcon + hIcon / 2);
                g.drawLine(xIcon - 3, yIcon - 3, xIcon, yIcon - 3);
                g.drawLine(xIcon - 3, yIcon - 3, xIcon - 3, yIcon);
                g.drawLine(xIcon + wIcon + 3, yIcon + hIcon + 3, xIcon + wIcon + 3, yIcon + hIcon);
                g.drawLine(xIcon + wIcon + 3, yIcon + hIcon + 3, xIcon + wIcon, yIcon + hIcon + 3);
                g2.rotate(-theta, xIcon + wIcon / 2, yIcon + hIcon / 2);
            }
        }
        if ((displayIcon = this.getDisplayIcon()) != null) {
            wIcon = displayIcon.getIconWidth();
            hIcon = displayIcon.getIconHeight();
            xIcon = this.m_x + 60 - 5 - displayIcon.getIconWidth();
            yIcon = this.m_y + (60 + this.m_extraHeight) - 5 - displayIcon.getIconHeight();
            if (possibleAction == NodeAction.RESULT_ACTION) {
                this.m_graphNodeAction.setBounds(xIcon - 2, yIcon - 2, wIcon + 4, hIcon + 4);
                this.m_graphNodeAction.setAction(true);
                this.m_graphNodeAction.draw(g);
            }
            g.drawImage(displayIcon.getImage(), xIcon, yIcon, null);
        }
        g.setFont(m_fontBold);
        g.setColor(Color.black);
        g.drawString(typeName, xText, yText);
        if (dataName != null) {
            if (dataName.length() > 17) {
                dataName = dataName.substring(0, 17) + ".";
            }
            stringWidth = metricsBold.stringWidth(dataName);
            xText = this.m_x + (60 - stringWidth) / 2;
            g.drawString(dataName, xText, yText -= m_hgtBold);
        }
        if (this.m_inConnectors != null) {
            for (GraphConnector connector : this.m_inConnectors) {
                connector.draw(g);
            }
        }
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                connector.draw(g);
            }
        }
    }

    public abstract Color getFrameColor();

    public abstract ImageIcon getIcon();

    public abstract ImageIcon getStatusIcon();

    public abstract ImageIcon getDisplayIcon();

    public abstract NodeAction possibleAction();

    public abstract void doAction(int var1, int var2);

    public abstract boolean canBeProcessed();

    public abstract void process(ProcessCallbackInterface var1);

    public abstract void askDisplay(int var1);

    public abstract ArrayList<WindowBox> getDisplayWindowBox(int var1);

    public abstract ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess();

    public abstract boolean settings();

    @Override
    public String getPreviousDataName() {
        if (this.m_inConnectors != null) {
            StringBuilder sb = new StringBuilder();
            for (GraphConnector connector : this.m_inConnectors) {
                String dataName = connector.getDataName();
                if (dataName == null) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(dataName);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    public LinearGradientPaint getBackgroundGradient() {
        if (this.m_gradient == null || this.m_gradientStartY != this.m_y) {
            Color frameColor = this.getFrameColor();
            Point2D.Float start = new Point2D.Float(this.m_x, this.m_y);
            Point2D.Float end = new Point2D.Float(this.m_x, this.m_y + (60 + this.m_extraHeight));
            float[] dist = new float[]{0.0f, 0.5f, 0.501f, 1.0f};
            Color[] colors = new Color[]{Color.white, frameColor.brighter(), frameColor, frameColor.brighter()};
            this.m_gradient = new LinearGradientPaint(start, end, dist, colors);
            this.m_gradientStartY = this.m_y;
        }
        return this.m_gradient;
    }

    protected void initFonts(Graphics g) {
        if (m_font != null) {
            return;
        }
        m_font = new Font(" TimesRoman ", 0, 11);
        m_fontBold = m_font.deriveFont(1);
        FontMetrics metricsBold = g.getFontMetrics(m_fontBold);
        FontMetrics metricsPlain = g.getFontMetrics(m_font);
        m_hgtBold = metricsBold.getHeight();
        m_ascentBold = metricsBold.getAscent();
        m_hgtPlain = metricsPlain.getHeight();
    }

    @Override
    public AbstractGraphObject inside(int x, int y) {
        AbstractGraphObject object;
        AbstractGraphObject object2;
        if (this.m_inConnectors != null) {
            for (GraphConnector connector : this.m_inConnectors) {
                object2 = connector.inside(x, y);
                if (object2 == null) continue;
                return object2;
            }
        }
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                object2 = connector.inside(x, y);
                if (object2 == null) continue;
                return object2;
            }
        }
        if ((object = this.m_graphNodeAction.inside(x, y)) != null) {
            return object;
        }
        object = this.m_menuAction.inside(x, y);
        if (object != null) {
            return object;
        }
        if (x >= this.m_x && y >= this.m_y && x <= this.m_x + 60 && y <= this.m_y + (60 + this.m_extraHeight)) {
            return this;
        }
        return null;
    }

    @Override
    public void move(int dx, int dy) {
        this.m_x += dx;
        this.m_y += dy;
        this.setConnectorsPosition();
        if (this.m_group != null) {
            this.m_group.objectMoved();
        }
    }

    @Override
    public int correctMoveX(int dx) {
        if (this.m_x + dx < 0) {
            return -this.m_x;
        }
        return dx;
    }

    @Override
    public int correctMoveY(int dy) {
        if (this.m_y + dy < 0) {
            return -this.m_y;
        }
        return dy;
    }

    public boolean hideAction() {
        return this.m_graphNodeAction.setHighlighted(false) | this.m_menuAction.setHighlighted(false);
    }

    protected void setConnectorsPosition() {
        int i;
        if (this.m_inConnectors != null) {
            int nb = this.m_inConnectors.size();
            this.m_extraHeight = nb > 3 ? (nb - 3) * 14 : 0;
            i = 0;
            for (GraphConnector connector : this.m_inConnectors) {
                int y = this.m_y + (int)Math.round((double)(60 + this.m_extraHeight) / (double)(nb + 1) * (double)(i + 1));
                connector.setRightPosition(this.m_x, y);
                ++i;
            }
        }
        if (this.m_outConnector != null) {
            int nbOutConnectors = this.m_outConnector.size();
            i = 1;
            for (GraphConnector connector : this.m_outConnector) {
                connector.setPosition(this.m_x + 60, this.m_y + i * (60 + this.m_extraHeight) / (nbOutConnectors + 1));
                ++i;
            }
        }
    }

    @Override
    public void delete() {
        if (this.m_inConnectors != null) {
            for (GraphConnector connector : this.m_inConnectors) {
                connector.delete();
            }
        }
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                connector.delete();
            }
            this.m_outConnector.clear();
        }
        if (this.m_group != null) {
            this.m_group.removeObject(this);
            this.m_group = null;
        }
    }

    @Override
    public void deleteAction() {
        this.delete();
        this.m_graphPanel.removeGraphNode(this);
        this.m_graphPanel.repaint();
    }

    @Override
    public JPopupMenu createPopup(GraphPanel panel) {
        int nbDisplay;
        int nbConnections = this.m_inConnectors == null ? 0 : this.m_inConnectors.size();
        JPopupMenu popup = new JPopupMenu();
        JMenu displayMenu = new JMenu("Display");
        LinkedList<AbstractAction> displayActions = new LinkedList<AbstractAction>();
        int n = nbDisplay = this.m_outConnector == null ? 1 : this.m_outConnector.size();
        if (nbDisplay <= 1) {
            displayActions.add(new DisplayBelowAction(this, 0, null));
            displayActions.add(new DisplayInNewWindowAction(this, 0, null));
        } else {
            int i;
            for (i = 0; i < nbDisplay; ++i) {
                displayActions.add(new DisplayBelowAction(this, i, this.getOutTooltip(i)));
            }
            displayActions.add(null);
            for (i = 0; i < nbDisplay; ++i) {
                displayActions.add(new DisplayInNewWindowAction(this, i, this.getOutTooltip(i)));
            }
        }
        boolean enabled = false;
        for (AbstractAction action : displayActions) {
            if (action == null) {
                displayMenu.addSeparator();
                continue;
            }
            enabled |= action.isEnabled();
            displayMenu.add(action);
        }
        displayMenu.setEnabled(enabled);
        popup.add(new SettingsAction(this, nbConnections));
        popup.add(displayMenu);
        popup.add(new ErrorAction(this));
        popup.addSeparator();
        popup.add(new DeleteAction());
        return popup;
    }

    public LinkedList<GraphNode> getOutLinkedGraphNodes() {
        if (!this.calculationDone()) {
            return null;
        }
        if (this.m_outConnector == null) {
            return null;
        }
        LinkedList<GraphNode> outLinkedGraphNodes = new LinkedList<GraphNode>();
        for (GraphConnector connector : this.m_outConnector) {
            connector.getOutLinkedGraphNodes(outLinkedGraphNodes);
        }
        return outLinkedGraphNodes;
    }

    public abstract void saveGraph(StringBuilder var1);

    public abstract String getOutTooltip(int var1);

    public class ErrorAction
    extends AbstractAction {
        private GraphNode m_graphNode;

        public ErrorAction(GraphNode graphNode) {
            super("Display Error");
            this.m_graphNode = null;
            this.m_graphNode = graphNode;
            this.setEnabled(graphNode.getErrorMessage() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Error", this.m_graphNode.getErrorMessage());
            errorDialog.setButtonVisible(1, false);
            errorDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
            errorDialog.setVisible(true);
        }
    }

    public class ProcessAction
    extends AbstractAction {
        private GraphNode m_graphNode;

        public ProcessAction(GraphNode graphNode) {
            super("Process");
            this.m_graphNode = null;
            this.m_graphNode = graphNode;
            this.setEnabled(graphNode.canBeProcessed());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProcessEngine.getProcessEngine().runANode(this.m_graphNode, GraphNode.this.m_graphPanel);
        }
    }

    public class SettingsAction
    extends AbstractAction {
        private GraphNode m_graphNode;

        public SettingsAction(GraphNode graphNode, int connectionIndex) {
            super("Settings");
            this.m_graphNode = null;
            this.m_graphNode = graphNode;
            this.setEnabled(graphNode.canSetSettings());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_graphNode.settings();
            GraphNode.this.m_graphPanel.repaint();
        }
    }

    public class DisplayBelowAction
    extends AbstractAction {
        private GraphNode m_graphNode;
        private int m_connectionIndex;

        public DisplayBelowAction(GraphNode graphNode, int connectionIndex, String name) {
            super(name == null ? "Below" : name + " Below");
            this.m_graphNode = null;
            this.m_graphNode = graphNode;
            this.m_connectionIndex = connectionIndex;
            this.setEnabled(graphNode.calculationDone());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode.this.m_graphPanel.displayBelow(this.m_graphNode, true, this.m_graphNode.getFullName(this.m_connectionIndex), null, this.m_connectionIndex);
        }
    }

    public class DisplayInNewWindowAction
    extends AbstractAction {
        private GraphNode m_graphNode;
        private int m_connectionIndex;

        public DisplayInNewWindowAction(GraphNode graphNode, int connectionIndex, String name) {
            super(name == null ? "In New Window" : name + " In New Window");
            this.m_graphNode = null;
            this.m_graphNode = graphNode;
            this.m_connectionIndex = connectionIndex;
            this.setEnabled(graphNode.calculationDone());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_graphNode.askDisplay(this.m_connectionIndex);
            GraphNode.this.m_graphPanel.repaint();
        }
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode.this.deleteAction();
        }
    }

    public static enum NodeAction {
        NO_ACTION,
        STEP_ACTION,
        ERROR_ACTION,
        RESULT_ACTION;

    }
}

