/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.rserver.dialog.ImageViewerTopComponent;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.LockedDataGraphicsModel;
import fr.proline.studio.rsmexplorer.gui.calc.parameters.CheckParameterInterface;
import fr.proline.studio.rsmexplorer.gui.calc.parameters.FunctionParametersDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.openide.windows.WindowManager;

public abstract class AbstractGraphic
implements CheckParameterInterface {
    protected LockedDataGraphicsModel m_graphicsModelInterface;
    protected Image m_generatedImage;
    protected ParameterList[] m_parameters = null;
    private boolean m_calculating = false;
    private boolean m_settingsBeingDone = false;
    private boolean m_inError = false;
    private String m_errorMessage = null;
    private ArrayList<SplittedPanelContainer.PanelLayout> m_autoDisplayLayoutDuringProcess = null;
    protected GraphPanel m_panel;
    private GRAPHIC_TYPE m_type;

    public AbstractGraphic(GraphPanel panel, GRAPHIC_TYPE graphicType) {
        this.m_panel = panel;
        this.m_type = graphicType;
    }

    public int getTypeId() {
        return this.m_type.getId();
    }

    public void cloneInfo(AbstractGraphic src) {
        this.m_autoDisplayLayoutDuringProcess = src.m_autoDisplayLayoutDuringProcess;
    }

    public void inLinkDeleted() {
        this.m_parameters = null;
        this.m_graphicsModelInterface = null;
        this.m_generatedImage = null;
    }

    public abstract String getName();

    public LockedDataGraphicsModel getGraphicsModelInterface() {
        return this.m_graphicsModelInterface;
    }

    public abstract void process(GraphConnector[] var1, GraphicGraphNode var2, ProcessCallbackInterface var3);

    public abstract void generateDefaultParameters(GraphConnector[] var1);

    public abstract void userParametersChanged();

    public abstract AbstractGraphic cloneGraphic(GraphPanel var1);

    public void setAutoDisplayLayoutDuringProcess(ArrayList<SplittedPanelContainer.PanelLayout> layout) {
        this.m_autoDisplayLayoutDuringProcess = layout;
    }

    public ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess() {
        return this.m_autoDisplayLayoutDuringProcess;
    }

    public void display(String dataName) {
        String functionName = this.getName();
        if (this.m_generatedImage != null) {
            ImageViewerTopComponent win = new ImageViewerTopComponent(dataName + " " + functionName, this.m_generatedImage);
            win.open();
            win.requestActive();
        } else {
            WindowBox windowBox = WindowBoxFactory.getGraphicsWindowBox(dataName, (ExtendedTableModelInterface)this.m_graphicsModelInterface, true);
            DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(windowBox);
            win.open();
            win.requestActive();
        }
    }

    public WindowBox getDisplayWindowBox(String dataName) {
        String functionName = this.getName();
        if (this.m_generatedImage != null) {
            return WindowBoxFactory.getImageWindowBox(dataName + " " + functionName, this.m_generatedImage);
        }
        return WindowBoxFactory.getGraphicsWindowBox(dataName, (ExtendedTableModelInterface)this.m_graphicsModelInterface, true);
    }

    public abstract boolean calculationDone();

    public abstract boolean settingsDone();

    public boolean isCalculating() {
        return this.m_calculating;
    }

    public boolean inError() {
        return this.m_inError;
    }

    public boolean isSettingsBeingDone() {
        return this.m_settingsBeingDone;
    }

    protected void setCalculating(boolean v) {
        if (v ^ this.m_calculating) {
            this.m_calculating = v;
            this.m_panel.repaint();
        }
    }

    protected void setInError(CalcError error) {
        if (error == null) {
            this.setInError(false, null);
        } else {
            this.setInError(true, error.getFullErrorMessage());
        }
    }

    protected void setInError(boolean v, String errorMessage) {
        if (v ^ this.m_inError) {
            this.m_inError = v;
            this.m_panel.repaint();
        }
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean settings(GraphConnector[] graphObjects, GraphNode node) {
        boolean thereIsNoParameterAtStart;
        boolean bl = thereIsNoParameterAtStart = this.m_parameters == null;
        if (thereIsNoParameterAtStart) {
            this.generateDefaultParameters(graphObjects);
        }
        if (this.m_parameters == null) {
            return false;
        }
        this.m_settingsBeingDone = true;
        try {
            FunctionParametersDialog dialog = new FunctionParametersDialog(this.getName(), WindowManager.getDefault().getMainWindow(), this.m_parameters, this, graphObjects);
            dialog.setImageInfo(this.m_panel, node.getX() - 60, node.getY() - 40, node.getXEnd() - node.getX() + 120, node.getYEnd() - node.getY() + 80);
            dialog.centerToWindow(WindowManager.getDefault().getMainWindow());
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                this.userParametersChanged();
                boolean bl2 = true;
                return bl2;
            }
            if (thereIsNoParameterAtStart) {
                this.m_parameters = null;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.m_settingsBeingDone = false;
        }
    }

    public ImageIcon getIcon() {
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.PENCIL_RULER);
    }

    public static enum GRAPHIC_TYPE {
        CalibrationPlotGraphic(0),
        ParallelCoordinatesGraphic(1),
        ScatterGraphic(2),
        HistogramGraphic(3),
        VennDiagramGraphic(4),
        BoxPlotGraphic(5),
        DensityPlotGraphic(6),
        VarianceDistPlotGraphic(7);

        private int m_id;

        private GRAPHIC_TYPE(int id) {
            this.m_id = id;
        }

        public int getId() {
            return this.m_id;
        }
    }
}

