/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.uds.Aggregation;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.util.NbBundle;

public class AddAggregatePanel
extends JPanel {
    private static Aggregation.ChildNature[] m_aggregateTypes = new Aggregation.ChildNature[]{Aggregation.ChildNature.BIOLOGICAL_GROUP, Aggregation.ChildNature.BIOLOGICAL_SAMPLE, Aggregation.ChildNature.SAMPLE_ANALYSIS, Aggregation.ChildNature.OTHER};
    private JCheckBox multipleAggregateCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextfield;
    private JSpinner nbAggregateSpinner;
    private JPanel parameterPanel;
    private JComboBox typeCombobox;
    private JLabel typeLabel;
    private MouseAdapter spinnerMouseAdapter = null;

    public AddAggregatePanel() {
        this.initComponents();
        this.initAutoEnableForSpinner();
        this.initDefaults();
    }

    private void initComponents() {
        this.parameterPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextfield = new JTextField();
        this.typeLabel = new JLabel();
        this.typeCombobox = new JComboBox<Aggregation.ChildNature>(m_aggregateTypes);
        this.typeCombobox.setRenderer(new DataSetComboboxRenderer());
        this.multipleAggregateCheckBox = new JCheckBox();
        this.nbAggregateSpinner = new JSpinner();
        this.parameterPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AddAggregatePanel.class, (String)"AddAggregatePanel.parameterPanel.border.title")));
        this.nameLabel.setText(NbBundle.getMessage(AddAggregatePanel.class, (String)"AddAggregatePanel.nameLabel.text"));
        this.nameTextfield.setText(NbBundle.getMessage(AddAggregatePanel.class, (String)"AddAggregatePanel.nameTextfield.text"));
        this.typeLabel.setText(NbBundle.getMessage(AddAggregatePanel.class, (String)"AddAggregatePanel.typeLabel.text"));
        this.multipleAggregateCheckBox.setText(NbBundle.getMessage(AddAggregatePanel.class, (String)"AddAggregatePanel.multipleAggregateCheckBox.text"));
        this.multipleAggregateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddAggregatePanel.this.multipleAggregateCheckBoxActionPerformed(evt);
            }
        });
        this.nbAggregateSpinner.setModel(new SpinnerNumberModel(2, 1, 100, 1));
        GroupLayout parameterPanelLayout = new GroupLayout(this.parameterPanel);
        this.parameterPanel.setLayout(parameterPanelLayout);
        parameterPanelLayout.setHorizontalGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(parameterPanelLayout.createSequentialGroup().addContainerGap().addGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(parameterPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(parameterPanelLayout.createSequentialGroup().addGap(0, 124, Short.MAX_VALUE).addComponent(this.multipleAggregateCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nbAggregateSpinner, -2, 52, -2)).addGroup(parameterPanelLayout.createSequentialGroup().addComponent(this.typeLabel).addGap(8, 8, 8).addComponent(this.typeCombobox, 0, -1, Short.MAX_VALUE)))).addGroup(parameterPanelLayout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameTextfield))).addContainerGap()));
        parameterPanelLayout.setVerticalGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(parameterPanelLayout.createSequentialGroup().addContainerGap().addGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextfield, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeCombobox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(parameterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.multipleAggregateCheckBox).addComponent(this.nbAggregateSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.parameterPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.parameterPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void multipleAggregateCheckBoxActionPerformed(ActionEvent evt) {
        boolean isSelected = this.multipleAggregateCheckBox.isSelected();
        this.nbAggregateSpinner.setEnabled(isSelected);
    }

    protected String getAggregateName() {
        return this.nameTextfield.getText();
    }

    protected JTextField getNameTextfield() {
        return this.nameTextfield;
    }

    protected int getNbAggregates() {
        if (this.multipleAggregateCheckBox.isSelected()) {
            return (Integer)this.nbAggregateSpinner.getValue();
        }
        return 1;
    }

    protected Aggregation.ChildNature getAggregateType() {
        return (Aggregation.ChildNature)this.typeCombobox.getSelectedItem();
    }

    protected final void initDefaults() {
        this.nameTextfield.setText("");
        this.typeCombobox.setSelectedItem(Aggregation.ChildNature.BIOLOGICAL_SAMPLE);
        this.multipleAggregateCheckBox.setSelected(false);
        this.nbAggregateSpinner.setValue(new Integer(2));
        this.nbAggregateSpinner.setEnabled(false);
    }

    public void reinitialize() {
        this.nameTextfield.setText("");
    }

    private void initAutoEnableForSpinner() {
        this.spinnerMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!AddAggregatePanel.this.multipleAggregateCheckBox.isSelected()) {
                    AddAggregatePanel.this.nbAggregateSpinner.setEnabled(true);
                    AddAggregatePanel.this.multipleAggregateCheckBox.setSelected(true);
                }
            }
        };
        this.initAutoEnableForSpinnerImpl(this.nbAggregateSpinner);
    }

    private void initAutoEnableForSpinnerImpl(Container c) {
        int nbSubComponent = c.getComponentCount();
        for (int i = 0; i < nbSubComponent; ++i) {
            Component componentCur = c.getComponent(i);
            componentCur.addMouseListener(this.spinnerMouseAdapter);
            if (!(componentCur instanceof Container)) continue;
            this.initAutoEnableForSpinnerImpl((Container)componentCur);
        }
    }

    public class DataSetComboboxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Aggregation.ChildNature selectedType = (Aggregation.ChildNature)value;
            switch (selectedType) {
                case BIOLOGICAL_GROUP: {
                    l.setText("Biological Group");
                    break;
                }
                case BIOLOGICAL_SAMPLE: {
                    l.setText("Biological Sample");
                    break;
                }
                case SAMPLE_ANALYSIS: {
                    l.setText("Sample Analysis");
                    break;
                }
                case OTHER: {
                    l.setText("Other");
                }
            }
            return l;
        }
    }
}

