/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.dpm.data.ChangeTypicalRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbPreferences;

public class ChangeTypicalProteinPanel
extends JPanel {
    public static final String[] REGEX_TARGET_OPTIONS = new String[]{"Protein Accession", "Protein Description"};
    private static final Integer NBR_MAX_RULES = 3;
    private JTextField[] m_regexTextFields = new JTextField[NBR_MAX_RULES.intValue()];
    private JComboBox[] m_regexTargetComboboxs = new JComboBox[NBR_MAX_RULES.intValue()];
    private JCheckBox[] m_allowFullRegexCheckBoxs = new JCheckBox[NBR_MAX_RULES.intValue()];

    public ChangeTypicalProteinPanel() {
        this.createPanel();
    }

    private void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        for (int i = 0; i < NBR_MAX_RULES; ++i) {
            String title = "Rule";
            this.add((Component)this.createRulePanel(title, i), c);
            ++c.gridy;
        }
        JLabel regexHelpLabel = new JLabel("( * = any string ; ? = any character )");
        regexHelpLabel.setForeground(Color.gray);
        this.add((Component)regexHelpLabel, c);
    }

    protected void savePreference(Preferences preferences) {
        for (int i = 0; i < NBR_MAX_RULES; ++i) {
            preferences.put("TypicalProteinRegex_" + i, this.m_regexTextFields[i].getText().trim());
            preferences.putBoolean("TypicalProteinRegexOnAccession_" + i, this.m_regexTargetComboboxs[i].getSelectedIndex() == 0);
            preferences.putBoolean("TypicalProteinFullRegex_" + i, this.m_allowFullRegexCheckBoxs[i].isSelected());
        }
    }

    protected void restoreInitialParameters() {
        Preferences preferences = NbPreferences.root();
        for (int i = 0; i < NBR_MAX_RULES; ++i) {
            String regex = preferences.get("TypicalProteinRegex_" + i, "*");
            this.m_regexTextFields[i].setText(regex);
            boolean regexOnAccession = preferences.getBoolean("TypicalProteinRegexOnAccession_" + i, Boolean.TRUE);
            if (regexOnAccession) {
                this.m_regexTargetComboboxs[i].setSelectedIndex(0);
            } else {
                this.m_regexTargetComboboxs[i].setSelectedIndex(1);
            }
            boolean fullRegex = preferences.getBoolean("TypicalProteinFullRegex_" + i, Boolean.FALSE);
            this.m_allowFullRegexCheckBoxs[i].setSelected(fullRegex);
        }
    }

    private JPanel createRulePanel(String prefixTitle, Integer ruleIndex) {
        JPanel rulePanel = new JPanel(new GridBagLayout());
        rulePanel.setBorder(BorderFactory.createTitledBorder(prefixTitle + " " + ruleIndex));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        rulePanel.add((Component)new JLabel("Typical Protein Match :"), c);
        ++c.gridx;
        this.m_regexTextFields[ruleIndex.intValue()] = new JTextField(16);
        rulePanel.add((Component)this.m_regexTextFields[ruleIndex], c);
        ++c.gridx;
        rulePanel.add((Component)new JLabel("on"), c);
        this.m_regexTargetComboboxs[ruleIndex.intValue()] = new JComboBox<String>(REGEX_TARGET_OPTIONS);
        ++c.gridx;
        rulePanel.add((Component)this.m_regexTargetComboboxs[ruleIndex], c);
        c.gridx = 0;
        ++c.gridy;
        this.m_allowFullRegexCheckBoxs[ruleIndex.intValue()] = new JCheckBox("advanced RegEx", false);
        rulePanel.add((Component)this.m_allowFullRegexCheckBoxs[ruleIndex], c);
        return rulePanel;
    }

    public void enableRules(boolean enabled) {
        for (int i = 0; i < NBR_MAX_RULES; ++i) {
            this.m_regexTextFields[i].setEnabled(enabled);
            this.m_regexTargetComboboxs[i].setEnabled(enabled);
            this.m_allowFullRegexCheckBoxs[i].setEnabled(enabled);
        }
    }

    public List<ChangeTypicalRule> getChangeTypicalRules() {
        ArrayList<ChangeTypicalRule> m_changeTypicalRules = new ArrayList<ChangeTypicalRule>(NBR_MAX_RULES);
        for (int i = 0; i < NBR_MAX_RULES; ++i) {
            if (this.m_regexTextFields[i].getText().trim().isEmpty() || this.m_regexTextFields[i].getText().trim().equals("*")) continue;
            if (this.m_allowFullRegexCheckBoxs[i].isSelected()) {
                m_changeTypicalRules.add(i, new ChangeTypicalRule(this.m_regexTextFields[i].getText().trim(), Boolean.valueOf(this.m_regexTargetComboboxs[i].getSelectedIndex() == 0)));
                continue;
            }
            m_changeTypicalRules.add(i, new ChangeTypicalRule(this.wildcardToRegex(this.m_regexTextFields[i].getText().trim()), Boolean.valueOf(this.m_regexTargetComboboxs[i].getSelectedIndex() == 0)));
        }
        return m_changeTypicalRules;
    }

    private String wildcardToRegex(String text) {
        String escapedText = "^" + this.escapeRegex(text) + "$";
        String wildcardsFilter = escapedText.replaceAll("\\*", ".*").replaceAll("\\?", ".");
        return wildcardsFilter;
    }

    private String escapeRegex(String s) {
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("[](){}.+$^|#\\".indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

