/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbPreferences;
import org.slf4j.LoggerFactory;

public class DefaultConverterDialog
extends DefaultDialog {
    private static DefaultConverterDialog m_singletonDialog = null;
    private ParameterList m_wizardParameterList;
    private Preferences m_preferences;
    private static final String DIALOG_TITLE = "Choose Converter";

    public static DefaultConverterDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new DefaultConverterDialog(parent);
        }
        return m_singletonDialog;
    }

    public DefaultConverterDialog(Window parent) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.setTitle(DIALOG_TITLE);
        this.setSize(new Dimension(460, 140));
        this.setMinimumSize(new Dimension(460, 140));
        this.setResizable(true);
        this.setButtonVisible(1, true);
        this.setButtonName(0, "OK");
        this.setStatusVisible(true);
        this.m_preferences = NbPreferences.root();
        this.setInternalComponent(this.createInternalComponent());
    }

    private JComponent createInternalComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createTitledBorder(""));
        this.m_wizardParameterList = new ParameterList("Conversion/Upload Settings");
        String[] converterExtentions = new String[]{"exe"};
        String[] converterFilterNames = new String[]{"raw2mzDB.exe"};
        FileParameter m_converterFilePath = new FileParameter(null, "Converter_(.exe)", "Converter (.exe)", JTextField.class, "", converterFilterNames, converterExtentions);
        m_converterFilePath.setAllFiles(false);
        m_converterFilePath.setSelectionMode(0);
        m_converterFilePath.setDefaultDirectory(new File(this.m_preferences.get("Conversion/Upload_Settings.Converter_(.exe)", System.getProperty("user.home"))));
        this.m_wizardParameterList.add((Object)m_converterFilePath);
        panel.add((Component)this.m_wizardParameterList.getPanel());
        return panel;
    }

    public void pack() {
    }

    protected boolean okCalled() {
        ParameterError error = this.m_wizardParameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            super.getDefaultDialogListener().cancelPerformed((DefaultDialog)this);
            return false;
        }
        this.m_wizardParameterList.saveParameters(NbPreferences.root());
        try {
            NbPreferences.root().flush();
        }
        catch (BackingStoreException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.DPM").error("Saving Parameters Failed", (Throwable)e);
        }
        if (super.getDefaultDialogListener() != null) {
            super.getDefaultDialogListener().okPerformed((DefaultDialog)this);
        }
        return true;
    }

    protected boolean cancelCalled() {
        if (super.getDefaultDialogListener() != null) {
            super.getDefaultDialogListener().cancelPerformed((DefaultDialog)this);
        }
        return true;
    }
}

