/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.HelpUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openide.util.NbPreferences;
import org.slf4j.LoggerFactory;

public class HelpDialog
extends DefaultDialog
implements MouseListener,
MouseMotionListener {
    private static HelpDialog m_singletonDialog = null;
    private JTree m_tree = null;
    private JCheckBox m_checkBox = null;
    private ParameterList m_parameterList;
    private static final String PARAMETER_LIST_NAME = "General Application Settings";
    private BooleanParameter m_parameter;
    private String[][] HELP_CONTENT = new String[][]{{"Create a Project", "id.1302m92"}, {"Create a Dataset", "id.3mzq4wv"}, {"Import a Search Result", "id.319y80a"}, {"Validate a Search Result", "id.42ddq1a"}, {"Display Search Result Data", "id.184mhaj"}, {"Display Identification Summary Data", "id.279ka65"}, {"Create a Spectral Count", "id.2mn7vak"}, {"Create a XIC", "id.3ls5o66"}};

    public static HelpDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new HelpDialog(parent);
        }
        return m_singletonDialog;
    }

    public static boolean showAtStart() {
        Preferences preferences = NbPreferences.root();
        return !preferences.getBoolean("General_Application_Settings.Hide_Getting_Started_Dialog", Boolean.FALSE);
    }

    public HelpDialog(Window parent) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.setTitle("Help");
        this.setSize(new Dimension(500, 340));
        this.setResizable(true);
        this.setButtonVisible(5, false);
        this.setButtonVisible(1, false);
        this.setButtonName(0, "Close");
        this.setStatusVisible(false);
        this.m_tree = new JTree(this.createTree());
        this.m_tree.setRowHeight(20);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setCellRenderer(new HelpCellRenderer());
        this.m_tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_tree.addMouseListener(this);
        this.m_tree.addMouseMotionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        JLabel leftImageLabel = new JLabel(IconManager.getIcon((IconManager.IconType)IconManager.IconType.BIG_HELP));
        leftImageLabel.setBackground(Color.white);
        JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.setBackground(Color.white);
        internalPanel.setOpaque(true);
        internalPanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)leftImageLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        internalPanel.add((Component)scrollPane, c);
        ++c.gridy;
        c.weighty = 0.0;
        internalPanel.add((Component)this.createParameterPanel(), c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createParameterPanel() {
        JPanel panel = new JPanel();
        this.m_parameterList = new ParameterList(PARAMETER_LIST_NAME);
        JCheckBox gettingStartedCheckBox = new JCheckBox("Hide Getting Started Dialog On Startup");
        gettingStartedCheckBox.setBackground(Color.WHITE);
        this.m_parameter = new BooleanParameter("Hide_Getting_Started_Dialog", "Hide Getting Started Dialog On Startup", (JComponent)gettingStartedCheckBox, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_parameter);
        this.m_parameterList.loadParameters(NbPreferences.root());
        panel = this.m_parameterList.getPanel();
        panel.setBackground(Color.WHITE);
        return panel;
    }

    public void pack() {
    }

    private DefaultMutableTreeNode createTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Getting Started");
        for (int i = 0; i < this.HELP_CONTENT.length; ++i) {
            top.add(new DefaultMutableTreeNode(new DocumentationInfo(this.HELP_CONTENT[i][0], this.HELP_CONTENT[i][1])));
        }
        return top;
    }

    protected boolean okCalled() {
        this.saveCheckbox();
        return true;
    }

    protected boolean cancelCalled() {
        this.saveCheckbox();
        return true;
    }

    private void saveCheckbox() {
        Preferences preferences = NbPreferences.root();
        this.m_parameterList.saveParameters(preferences);
    }

    private void checkMouseCursor(MouseEvent e) {
        if (this.isOverLink(e)) {
            this.m_tree.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.m_tree.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean isOverLink(MouseEvent e) {
        Point p = e.getPoint();
        int selRow = this.m_tree.getRowForLocation(p.x, p.y);
        if (selRow != -1) {
            TreePath path = this.m_tree.getPathForRow(selRow);
            Rectangle pathBounds = this.m_tree.getPathBounds(path);
            if (!pathBounds.contains(p)) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object useObject = node.getUserObject();
            if (useObject == null) {
                return false;
            }
            return useObject instanceof DocumentationInfo;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isOverLink(e)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        Object useObject = node.getUserObject();
        if (useObject instanceof DocumentationInfo) {
            DocumentationInfo helpInfo = (DocumentationInfo)useObject;
            String suffix = helpInfo.getSuffix();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(HelpUtils.createRedirectTempFile((String)suffix));
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error(this.getClass().getSimpleName() + " failed", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkMouseCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkMouseCursor(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkMouseCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkMouseCursor(e);
    }

    private class DocumentationInfo {
        private String m_text;
        private String m_documentationSuffix;

        public DocumentationInfo(String text, String url) {
            this.m_text = text;
            this.m_documentationSuffix = url;
        }

        public String getSuffix() {
            return this.m_documentationSuffix;
        }

        public String toString() {
            return this.m_text;
        }
    }

    private class HelpCellRenderer
    extends DefaultTreeCellRenderer {
        private Font m_font = null;
        private Font m_fontBold = null;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = (JLabel)super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, hasFocus);
            if (this.m_font == null) {
                this.m_font = l.getFont().deriveFont(14);
                this.m_fontBold = this.m_font.deriveFont(1);
            }
            l.setBackground(Color.white);
            if (leaf) {
                l.setFont(this.m_font);
                l.setForeground(Color.blue);
                this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.BOOK_QUESTION));
            } else {
                l.setFont(this.m_fontBold);
                l.setForeground(Color.black);
                if (expanded) {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.BOOK_OPEN));
                } else {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.BOOK));
                }
            }
            return this;
        }
    }
}

