/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.dam.memory.MemoryReference;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swingx.JXTable;

public class MemoryDialog
extends DefaultDialog {
    private static MemoryDialog m_singletonDialog = null;
    private MemoryTable m_usedTable = null;
    private MemoryTable m_freeTable = null;

    public static MemoryDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new MemoryDialog(parent);
        }
        return m_singletonDialog;
    }

    private MemoryDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Memory Management");
        this.setSize(new Dimension(640, 480));
        this.setMinimumSize(new Dimension(400, 360));
        this.setResizable(true);
        this.setButtonName(0, "Free Memory");
        this.initInternalPanel();
    }

    private void update() {
        ArrayList freeCacheList = TransientMemoryCacheManager.getSingleton().getFreeCacheList();
        MemoryTableModel freeModel = new MemoryTableModel(true, freeCacheList);
        this.m_freeTable.setModel(freeModel);
        ArrayList usedCacheList = TransientMemoryCacheManager.getSingleton().getUsedCacheList();
        MemoryTableModel usedModel = new MemoryTableModel(false, usedCacheList);
        this.m_usedTable.setModel(usedModel);
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.m_freeTable = new MemoryTable();
        JScrollPane freeListScrollPane = new JScrollPane((Component)((Object)this.m_freeTable));
        this.m_usedTable = new MemoryTable();
        JScrollPane usedListScrollPane = new JScrollPane((Component)((Object)this.m_usedTable));
        tabbedPane.add("Recoverable Memory", freeListScrollPane);
        tabbedPane.add("Used Memory", usedListScrollPane);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)tabbedPane, c);
        this.setInternalComponent(internalPanel);
    }

    public void setVisible(boolean b) {
        this.update();
        super.setVisible(b);
    }

    protected boolean okCalled() {
        TransientMemoryCacheManager.getSingleton().freeUnusedCache();
        DataAnalyzerWindowBoxManager.updateToFreeMemory();
        System.gc();
        return true;
    }

    private static class MemoryTableModel
    extends AbstractTableModel {
        private static final int COLUMN_CACHE = 0;
        private static final int COLUMN_WINDOW = 1;
        private static final int NB_COLS = 2;
        private static final String[] FREE_COLUMN_NAMES = new String[]{"Cache", "Was Used in Window"};
        private static final String[] USED_COLUMN_NAMES = new String[]{"Cache", "Used in Window"};
        private ArrayList<MemoryReference> m_memoryReferenceList = null;
        private String[] m_columnNames;

        public MemoryTableModel(boolean freeCacheModel, ArrayList<MemoryReference> memoryReferenceList) {
            this.m_memoryReferenceList = memoryReferenceList;
            this.m_columnNames = freeCacheModel ? FREE_COLUMN_NAMES : USED_COLUMN_NAMES;
        }

        @Override
        public String getColumnName(int column) {
            return this.m_columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_memoryReferenceList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String name = this.m_memoryReferenceList.get(rowIndex).getCacheName();
                    if (rowIndex == 0 || !name.equals(this.m_memoryReferenceList.get(rowIndex - 1).getCacheName())) {
                        return name;
                    }
                    return "";
                }
                case 1: {
                    return this.m_memoryReferenceList.get(rowIndex).getClientName();
                }
            }
            return null;
        }
    }

    private class MemoryTable
    extends JXTable {
        public MemoryTable() {
            this.setSortable(false);
        }
    }
}

