/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbPreferences;

public class UploadDatDialog
extends DefaultDialog {
    private static UploadDatDialog m_singletonDialog = null;
    private JList m_fileList;
    private JScrollPane m_fileListScrollPane;
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private String m_lastParentDirectory;

    public static UploadDatDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new UploadDatDialog(parent);
        }
        return m_singletonDialog;
    }

    public UploadDatDialog(Window parent) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.setTitle("Upload .dat file(s)");
        this.setSize(new Dimension(360, 480));
        this.setResizable(true);
        this.setDocumentationSuffix(null);
        this.setButtonVisible(1, true);
        this.setButtonName(0, "OK");
        this.setStatusVisible(true);
        this.setInternalComponent(this.createInternalComponent());
    }

    private Component createInternalComponent() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BorderLayout());
        internalPanel.add((Component)this.createFileSelectionPanel(), "Center");
        return internalPanel;
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        this.m_fileList = new JList(new DefaultListModel());
        this.m_fileListScrollPane = new JScrollPane(this.m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)this.m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        this.m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = UploadDatDialog.this.m_fileList.getSelectedIndex() != -1;
                UploadDatDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences preferences = NbPreferences.root();
                String initializationDirectory = preferences.get("dat_Settings.LAST_DAT_PATH", System.getProperty("user.home"));
                File f = new File(initializationDirectory);
                if (!f.exists() || !f.isDirectory()) {
                    initializationDirectory = System.getProperty("user.home");
                }
                JFileChooser fchooser = new JFileChooser();
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".dat", "DAT"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)m_singletonDialog));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)UploadDatDialog.this.m_fileList.getModel()).addElement(files[i]);
                    }
                    if (files.length > 0) {
                        UploadDatDialog.this.m_lastParentDirectory = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = UploadDatDialog.this.m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)UploadDatDialog.this.m_fileList.getModel()).removeElement(it.next());
                }
                UploadDatDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    protected boolean okCalled() {
        if (this.m_fileList.getModel().getSize() == 0) {
            this.setStatus(true, "No files are selected.");
            this.highlight(this.m_fileList);
            return false;
        }
        ArrayList<File> mzdbFiles = new ArrayList<File>();
        for (int i = 0; i < this.m_fileList.getModel().getSize(); ++i) {
            mzdbFiles.add((File)this.m_fileList.getModel().getElementAt(i));
        }
        Preferences preferences = NbPreferences.root();
        preferences.put("dat_Settings.LAST_DAT_PATH", this.m_lastParentDirectory);
        DefaultListModel listModel = (DefaultListModel)this.m_fileList.getModel();
        listModel.removeAllElements();
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }
}

