/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.CheckDesignTreeDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.DatasetReferenceNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantAggregateExperimentalTreePanel;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateQuantitationDialog
extends CheckDesignTreeDialog {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static AggregateQuantitationDialog m_singletonDialog = null;
    private QuantAggregateExperimentalTreePanel m_experimentalDesignPanel;
    private JPanel m_designPanel = null;
    private AbstractNode m_experimentalDesignNode = null;
    private List<DDataset> m_quantitations;
    private DDataset m_refDataset = null;

    public static AggregateQuantitationDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new AggregateQuantitationDialog(parent);
        }
        return m_singletonDialog;
    }

    private AggregateQuantitationDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Aggregate Quantitation Wizard");
        this.setDocumentationSuffix("id.2eclud0");
        this.setSize(750, 750);
        this.setResizable(true);
    }

    public void pack() {
    }

    public Map<String, Object> getExperimentalDesignParameters() throws IllegalAccessException {
        if (this.m_experimentalDesignNode == null) {
            throw new IllegalAccessException("Design parameters have not been set.");
        }
        Map<String, Object> experimentalDesignParams = QuantExperimentalDesignTree.toExperimentalDesignParameters(this.m_experimentalDesignNode, this.m_refDataset, null);
        return experimentalDesignParams;
    }

    public Map<String, Object> getQuantiParameters() {
        HashMap<String, Object> aggregationConfig = new HashMap<String, Object>();
        aggregationConfig.put("quantitation_ids", this.m_quantitations.stream().map(d -> d.getId()).toArray());
        aggregationConfig.put("quant_channels_mapping", this.m_experimentalDesignPanel.getQuantChannelsMatching());
        aggregationConfig.put("intensity_computation_method_name", "INTENSITY_SUM");
        return aggregationConfig;
    }

    public AbstractNode getExperimentalDesignNode() {
        return this.m_experimentalDesignNode;
    }

    public void setQuantitationDatasets(List<DDataset> loadedQuantitations) {
        this.m_quantitations = loadedQuantitations;
        List refDatasetIds = this.m_quantitations.stream().map(ds -> ((DMasterQuantitationChannel)ds.getMasterQuantitationChannels().get(0)).getIdentDataset()).map(ids -> ids == null ? -1L : ids.getId()).distinct().collect(Collectors.toList());
        if (refDatasetIds.size() == 1 && (Long)refDatasetIds.get(0) != -1L) {
            DDataset dataset = this.m_quantitations.get(0);
            this.m_refDataset = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getIdentDataset();
        } else {
            this.m_refDataset = null;
        }
        this.displayExperimentalDesignTree();
    }

    public void displayExperimentalDesignTree() {
        DataSetNode rootNode = this.inferExperimentalDesign();
        this.displayStep1ExperimentalDesignTree(rootNode);
    }

    public void displayStep1ExperimentalDesignTree(AbstractNode node) {
        String step1Title = "";
        String step1Help = "<b>Left Panel: Define the aggregation experimental design</b><br><br> The following experimental design was inferred from the quantitation that will be aggregated. Group, samples and channels (replicates) entities can be modified<br> &nbsp - &nbsp Change entities <b>order</b> by drag and drop<br>  &nbsp - &nbsp <b>Rename</b> entities by contextual menu (right click)<br>  &nbsp - &nbsp <b>Create</b> or <b>delete</b> entities from the contextual menu<br><br><b>Center Panel: Define quantitation channels mapping</b><br><br>Each quantitation channel of the aggregation will correspond to sample analyses of aggregated quantitations. The following modifications can be made: <br> &nbsp - &nbsp <b>Change association</b> by dragging and dropping sample analysis from the right panel to a cell or from another cell<br> &nbsp - &nbsp <b>Remove association</b> by using contextual menu or toolbar<br> &nbsp - &nbsp <b>Move</b> analyses up or down by using contextual menu or toolbar";
        this.setHelpHeader(step1Title, step1Help);
        if (this.m_quantitations != null && this.m_quantitations.size() > 0) {
            this.setButtonVisible(3, false);
            this.setButtonVisible(4, false);
            this.setButtonVisible(6, false);
            if (node != this.m_experimentalDesignNode) {
                this.m_experimentalDesignNode = node;
                this.m_designPanel = new JPanel();
                this.m_designPanel.setBorder(BorderFactory.createTitledBorder(" Experimental Design "));
                this.m_designPanel.setLayout(new BorderLayout());
                this.m_experimentalDesignPanel = new QuantAggregateExperimentalTreePanel(this.m_experimentalDesignNode, this.m_quantitations);
                this.m_designPanel.add((Component)this.m_experimentalDesignPanel, "Center");
                TreeUtils.expandTree(this.m_experimentalDesignPanel.getTree(), true);
            }
            this.replaceInternalComponent(this.m_designPanel);
            this.revalidate();
            this.repaint();
        }
    }

    protected boolean okCalled() {
        if (!this.checkDesignStructure(this.m_experimentalDesignPanel.getTree(), this.m_experimentalDesignNode, new HashSet<String>())) {
            return false;
        }
        if (!this.checkBiologicalGroupName(this.m_experimentalDesignPanel.getTree(), this.m_experimentalDesignNode)) {
            return false;
        }
        QuantAggregateExperimentalTreePanel.DropZone errorZone = this.m_experimentalDesignPanel.getChannelPanel().checkDuplicateDropZone();
        if (errorZone != null) {
            this.setStatus(true, "Channel is duplicated : " + errorZone.getChannel().getName());
            this.highlight(this.m_experimentalDesignPanel.getChannelPanel(), errorZone.getBounds());
            return false;
        }
        return true;
    }

    protected boolean backCalled() {
        return false;
    }

    private String shortenSampleName(String groupName, String sampleName) {
        if (sampleName.startsWith(groupName)) {
            return sampleName.substring(groupName.length());
        }
        return sampleName;
    }

    private DataSetNode inferExperimentalDesign() {
        Long refResultSummaryId;
        int childIndex = 0;
        DataSetNode rootNode = new DataSetNode((AbstractData)DataSetData.createTemporaryQuantitation((String)"XIC Aggregation"));
        DatasetReferenceNode refDatasetNode = new DatasetReferenceNode((AbstractData)DataSetData.createTemporaryAggregate((String)(this.m_refDataset == null ? "auto" : this.m_refDataset.getName())));
        if (!(this.m_refDataset == null || (refResultSummaryId = ((DMasterQuantitationChannel)this.m_quantitations.get(0).getMasterQuantitationChannels().get(0)).getIdentResultSummaryId()) != null && refResultSummaryId.equals(this.m_refDataset.getResultSummaryId()))) {
            refDatasetNode.setInvalidReference(true);
        }
        rootNode.insert(refDatasetNode, childIndex++);
        int qcIndex = 1;
        ArrayList<String> sortedGroupList = new ArrayList<String>();
        HashMap groupSamplesMap = new HashMap();
        Map groups = this.m_quantitations.stream().map(ds -> ds.getGroupSetup().getBiologicalGroups()).flatMap(Collection::stream).collect(Collectors.groupingBy(bg -> bg.getName(), Collectors.toList()));
        for (DDataset Quant : this.m_quantitations) {
            List groupList = Quant.getGroupSetup().getBiologicalGroups();
            ArrayList sortedSampleList = new ArrayList();
            for (BiologicalGroup group : groupList) {
                XICBiologicalGroupNode biologicalGroupNode;
                String groupName = group.getName();
                int gIndex = sortedGroupList.indexOf(groupName);
                if (gIndex == -1) {
                    sortedGroupList.add(groupName);
                    groupSamplesMap.put(groupName, new ArrayList());
                    biologicalGroupNode = new XICBiologicalGroupNode((AbstractData)DataSetData.createTemporaryAggregate((String)groupName));
                    rootNode.insert(biologicalGroupNode, childIndex++);
                } else {
                    biologicalGroupNode = (XICBiologicalGroupNode)rootNode.getChildAt(gIndex + 1);
                }
                List sampleList = group.getBiologicalSamples();
                for (BiologicalSample sample : sampleList) {
                    String sampleName = sample.getName();
                    List sampleNameList = (List)groupSamplesMap.get(groupName);
                    int sIndex = sampleNameList.indexOf(sampleName);
                    if (sIndex != -1) continue;
                    sampleNameList.add(sampleName);
                    String shortSampleName = this.shortenSampleName(groupName, sampleName);
                    XICBiologicalSampleNode biologicalSampleNode = new XICBiologicalSampleNode((AbstractData)DataSetData.createTemporaryAggregate((String)shortSampleName));
                    biologicalGroupNode.insert(biologicalSampleNode, sampleNameList.size() - 1);
                    Map samples = groups.get(groupName).stream().map(bg -> bg.getBiologicalSamples()).flatMap(Collection::stream).collect(Collectors.groupingBy(s -> s.getName(), Collectors.toList()));
                    int maxReplicates = 0;
                    for (BiologicalSample bs : samples.get(sampleName)) {
                        int replicates = bs.getQuantitationChannels().size();
                        maxReplicates = Math.max(replicates, maxReplicates);
                    }
                    for (int i = 0; i < maxReplicates; ++i) {
                        String name = "Channel " + Integer.toString(qcIndex++);
                        DataSetData dsData = DataSetData.createTemporaryIdentification((String)name);
                        XICBiologicalSampleAnalysisNode sampleAnalysisNode = new XICBiologicalSampleAnalysisNode((AbstractData)dsData);
                        sampleAnalysisNode.setQuantChannelName(name);
                        biologicalSampleNode.insert(sampleAnalysisNode, biologicalSampleNode.getChildCount());
                    }
                }
            }
        }
        int cIndex = 1;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            AbstractNode groupNode = (AbstractNode)rootNode.getChildAt(i);
            if (!XICBiologicalGroupNode.class.isInstance(groupNode)) continue;
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                AbstractNode sampleNode = (AbstractNode)groupNode.getChildAt(j);
                for (int k = 0; k < sampleNode.getChildCount(); ++k) {
                    XICBiologicalSampleAnalysisNode cNode = (XICBiologicalSampleAnalysisNode)sampleNode.getChildAt(k);
                    cNode.setQuantChannelName("Channel " + cIndex++);
                }
            }
        }
        return rootNode;
    }
}

