/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.rsmexplorer.gui.DropZoneInterface;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTransferHandler;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AssociationWrapper;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.SelectRawFilesPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.XICDropZoneInfo;
import fr.proline.studio.utils.HelpUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class XICDropZone
extends JPanel
implements DropZoneInterface {
    private final HashMap<String, File> m_droppedFiles;
    private SelectRawFilesPanel.FlatDesignTableModel m_model;
    private final String[] suffix = new String[]{".raw", ".mzdb", ".wiff"};
    private XICDropZoneInfo m_info;
    private final TreeFileChooserTransferHandler m_transferHandler;
    private final HashMap<String, AssociationWrapper> m_associations;

    public XICDropZone(TreeFileChooserTransferHandler transferHandler) {
        this.m_transferHandler = transferHandler;
        this.m_droppedFiles = new HashMap();
        this.m_associations = new HashMap();
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setToolTipText("Drag your .mzdb files & folders in the drop zone");
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("<html><center><font size='6' color='green'>Drop Zone</font><br><font size='4' color='black'>Drop your .mzdb files & folders here</font></center></html>", IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LARGE), 0), "Center");
        this.m_transferHandler.addComponent(this);
        this.setTransferHandler(this.m_transferHandler);
    }

    public void setTable(JTable table) {
        this.m_model = (SelectRawFilesPanel.FlatDesignTableModel)((Object)table.getModel());
    }

    public void setDropZoneInfo(XICDropZoneInfo info) {
        this.m_info = info;
    }

    public void updateTable() {
        if (this.m_model == null) {
            return;
        }
        this.m_model.updatePotentialsListForMissings();
        ArrayList<String> associatedFileList = new ArrayList<String>();
        HashMap<Integer, HashSet<String>> potentialFileNamesForMissings = this.m_model.getPotentialFilenamesForMissings();
        for (Integer nodeIndex : potentialFileNamesForMissings.keySet()) {
            HashSet<String> potentialFileNames = potentialFileNamesForMissings.get(nodeIndex);
            for (String potentialFileName : potentialFileNames) {
                Optional<String> foundedFile = this.m_droppedFiles.keySet().stream().filter(fileName -> fileName.toLowerCase().startsWith(potentialFileName)).findFirst();
                if (!foundedFile.isPresent()) continue;
                String associedtDropFile = foundedFile.get();
                associatedFileList.add(associedtDropFile);
                ArrayList<File> fileList = new ArrayList<File>();
                fileList.add(this.m_droppedFiles.get(associedtDropFile));
                this.m_model.setFiles(fileList, nodeIndex);
            }
        }
        this.updateDropZoneInfo(associatedFileList);
    }

    private void updateAssociations(List<String> associatedFileList) {
        Iterator<String> droppedFilenameIt = this.m_droppedFiles.keySet().iterator();
        while (droppedFilenameIt.hasNext()) {
            String droppedFilename;
            AssociationWrapper.AssociationType associationType = associatedFileList.contains(droppedFilename = droppedFilenameIt.next()) ? AssociationWrapper.AssociationType.ASSOCIATED : AssociationWrapper.AssociationType.NOT_ASSOCIATED;
            AssociationWrapper assocWraper = this.m_associations.getOrDefault(droppedFilename, new AssociationWrapper(droppedFilename, associationType));
            if (assocWraper.getAssociationType() == AssociationWrapper.AssociationType.NOT_ASSOCIATED) {
                assocWraper.setAssociationType(associationType);
            }
            this.m_associations.put(droppedFilename, assocWraper);
        }
    }

    public HashMap<String, AssociationWrapper> getAssociations() {
        return this.m_associations;
    }

    @Override
    public void removeAllSamples() {
        if (this.m_droppedFiles != null) {
            this.m_droppedFiles.clear();
        }
    }

    @Override
    public HashMap<String, File> getAllSamples() {
        if (this.m_droppedFiles != null) {
            return this.m_droppedFiles;
        }
        return null;
    }

    @Override
    public void addSample(Object sample) {
        if (sample instanceof File && !this.m_droppedFiles.containsKey(HelpUtils.getFileName((String)((File)sample).toString().toLowerCase(), (String[])this.suffix))) {
            this.m_droppedFiles.put(HelpUtils.getFileName((String)((File)sample).toString().toLowerCase(), (String[])this.suffix), (File)sample);
        }
    }

    @Override
    public void removeSample(Object key) {
        if (this.m_droppedFiles != null) {
            this.m_droppedFiles.remove(key);
        }
    }

    public XICDropZoneInfo getDropZoneInfo() {
        return this.m_info;
    }

    public void updateDropZoneInfo(List<String> associatedFileList) {
        if (this.m_info != null) {
            this.updateAssociations(associatedFileList);
            this.m_info.updateInfo(this.getAssociations());
        }
    }

    @Override
    public void addSamples(Object o) {
        if (o instanceof ArrayList) {
            ArrayList sampleList = (ArrayList)o;
            for (int i = 0; i < sampleList.size(); ++i) {
                this.addSample(sampleList.get(i));
            }
            if (this.m_model != null) {
                this.updateTable();
            }
        }
    }

    @Override
    public void clearDropZone() {
        this.m_droppedFiles.clear();
        this.m_associations.clear();
        this.m_info.clearInfo();
    }
}

