/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation;

import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import java.util.HashMap;
import java.util.Map;

public class DQuantitationChannelMapping {
    private Integer parentQCNumber;
    private Map<DDataset, QuantitationChannel> mappedQuantChannels;

    public DQuantitationChannelMapping(Integer parentQCNumber) {
        this.parentQCNumber = parentQCNumber;
        this.mappedQuantChannels = new HashMap<DDataset, QuantitationChannel>();
    }

    public Integer getParentQCNumber() {
        return this.parentQCNumber;
    }

    public void setParentQCNumber(Integer parentQCNumber) {
        this.parentQCNumber = parentQCNumber;
    }

    public Map<DDataset, QuantitationChannel> getMappedQuantChannels() {
        return this.mappedQuantChannels;
    }

    public QuantitationChannel getQuantChannel(DDataset Quanti) {
        return this.mappedQuantChannels.get(Quanti);
    }

    public void put(DDataset ds, QuantitationChannel childQC) {
        this.mappedQuantChannels.put(ds, childQC);
    }

    public void put(DDataset ds, int qcNumber) {
        QuantitationChannel childQC = ((DMasterQuantitationChannel)ds.getMasterQuantitationChannels().get(0)).getQuantitationChannels().stream().filter(qc -> qc.getNumber() == qcNumber).findFirst().orElse(null);
        if (childQC != null) {
            this.mappedQuantChannels.put(ds, childQC);
        }
    }

    public void remove(DDataset quanti) {
        this.mappedQuantChannels.remove(quanti);
    }

    public DQuantitationChannelMapping clone() {
        DQuantitationChannelMapping copy = new DQuantitationChannelMapping(this.parentQCNumber);
        for (DDataset quanti : this.mappedQuantChannels.keySet()) {
            copy.mappedQuantChannels.put(quanti, this.mappedQuantChannels.get(quanti));
        }
        return copy;
    }

    public String toString() {
        String result = this.parentQCNumber + " ";
        for (DDataset quanti : this.mappedQuantChannels.keySet()) {
            QuantitationChannel channel = this.mappedQuantChannels.get(quanti);
            result = result + "{" + quanti.getName() + ",(id=" + channel.getId() + ",name=" + channel.getName() + ")}";
        }
        return result;
    }
}

