/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.data.ptm.ComparableList;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.LongFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PercentageRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.ExportFontModelUtilities;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.CollectionRenderer;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMClusterTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    private final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ptm");
    public static final int COLTYPE_PTM_CLUSTER_ID = 0;
    public static final int COLTYPE_PROTEIN_ID = 1;
    public static final int COLTYPE_PROTEIN_NAME = 2;
    public static final int COLTYPE_PEPTIDE_NAME = 3;
    public static final int COLTYPE_PEPTIDE_PTM = 4;
    public static final int COLTYPE_PTM_PROBA = 5;
    public static final int COLTYPE_PEPTIDE_SCORE = 6;
    public static final int COLTYPE_PEPTIDE_COUNT = 7;
    public static final int COLTYPE_PTMSITE_COUNT = 8;
    public static final int COLTYPE_PTMSITE_POSITIONS = 9;
    public static final int COLTYPE_PTM_CLUSTER_CONFIDENCE = 10;
    public static final int COLTYPE_PTMSITE_CONFIDENCES = 11;
    public static final int COLTYPE_DELTA_MASS_PTM = 12;
    public static final int COLTYPE_SPECTRUM_TITLE = 13;
    public static final int LAST_STATIC_COLUMN = 13;
    private static final String[] m_columnNames = new String[]{"Id", "Protein Id", "Protein", "Peptide", "PTMs", "PTMs Confid.(MDScore, %)", "Score", "Peptide count", "Site count", "Sites Loc.", "Confidence", "Sites Confid.(%)", "PTM D.Mass", "Spectrum title"};
    private static final String[] m_columnTooltips = new String[]{"PTM cluster Id", "Protein match Id", "Protein", "Peptide", "Peptide's PTMs", "PTMs localisation confidence (%)", "Score of the peptide match", "Number of peptides matching the modification site", "Number of modification sites grouped into the cluster", "Sites localisation on the protein", "Sites combined confidence", "Sites localisation confidence (%)", "PTMs delta mass", "Peptide match spectrum title"};
    public static final int COLTYPE_START_QUANT_INDEX = 14;
    public static final int COLTYPE_RAW_ABUNDANCE = 0;
    public static final int COLTYPE_ABUNDANCE = 1;
    private static final String[] m_columnNamesQC = new String[]{"Raw abundance", "Abundance"};
    private static final String[] m_columnTooltipsQC = new String[]{"Raw abundance", "Abundance"};
    private DQuantitationChannel[] m_quantChannels = null;
    private int m_quantChannelNumber = 0;
    private boolean m_isQuantitationDS = false;
    private ArrayList<PTMCluster> m_ptmClusters = null;
    private String m_modelName;
    private String m_modificationInfo = "";
    private final ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public PTMClusterTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        int nbrCol = m_columnNames.length;
        if (this.m_isQuantitationDS) {
            nbrCol += this.m_quantChannelNumber * m_columnNamesQC.length;
        }
        return nbrCol;
    }

    public String getColumnName(int col) {
        if (col <= 13) {
            return m_columnNames[col];
        }
        int nbQc = (col - 14) / m_columnNamesQC.length;
        int id = col - 14 - nbQc * m_columnNamesQC.length;
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(m_columnNamesQC[id]);
        sb.append("<br/>");
        sb.append(this.m_quantChannels[nbQc].getName());
        sb.append("</html>");
        return sb.toString();
    }

    public String getToolTipForHeader(int col) {
        if (col <= 13) {
            return m_columnTooltips[col];
        }
        int nbQc = (col - 14) / m_columnNamesQC.length;
        int id = col - 14 - nbQc * m_columnNamesQC.length;
        String rawFilePath = StringUtils.truncate((String)this.m_quantChannels[nbQc].getRawFilePath(), (int)50);
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(m_columnTooltipsQC[id]);
        sb.append("<br/>");
        sb.append(this.m_quantChannels[nbQc].getFullName());
        sb.append("<br/>");
        sb.append(rawFilePath);
        sb.append("</html>");
        return sb.toString();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(1);
        listIds.add(10);
        if (this.m_isQuantitationDS) {
            for (int i = this.m_quantChannels.length - 1; i >= 0; --i) {
                listIds.add(14 + i * m_columnNamesQC.length);
            }
        }
        return listIds;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 10: {
                return Float.class;
            }
            case 7: 
            case 8: {
                return Integer.class;
            }
            case 9: 
            case 11: {
                return ComparableList.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                return LazyData.class;
            }
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        switch (col) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                return 1;
            }
        }
        return -1;
    }

    public int getRowCount() {
        if (this.m_ptmClusters == null) {
            return 0;
        }
        return this.m_ptmClusters.size();
    }

    public Object getValueAt(int row, int col) {
        PTMCluster ptmCluster = this.m_ptmClusters.get(row);
        DProteinMatch proteinMatch = ptmCluster.getProteinMatch();
        DPeptideMatch peptideMatch = ptmCluster.getRepresentativePepMatch();
        LazyData lazyData = this.getLazyData(row, col);
        switch (col) {
            case 0: {
                return ptmCluster.getId();
            }
            case 1: {
                return proteinMatch.getId();
            }
            case 2: {
                return proteinMatch.getAccession();
            }
            case 3: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                lazyData.setData((Comparable)peptideMatch);
                return lazyData;
            }
            case 6: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                lazyData.setData((Comparable)peptideMatch.getScore());
                return lazyData;
            }
            case 4: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = peptideMatch.getPeptide().getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                lazyData.setData((Comparable)((Object)ptm));
                return lazyData;
            }
            case 5: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                Float proba = Float.valueOf(Float.NaN);
                DPtmSiteProperties properties = peptideMatch.getPtmSiteProperties();
                if (properties != null) {
                    proba = Float.valueOf(properties.getMascotDeltaScore().floatValue() * 100.0f);
                }
                lazyData.setData((Comparable)proba);
                return lazyData;
            }
            case 12: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                double deltaMass = 0.0;
                if (peptideMatch.getPeptidePTMArray() != null) {
                    for (DPeptidePTM peptidePTM : peptideMatch.getPeptidePTMArray()) {
                        DInfoPTM pepInfoPtm = (DInfoPTM)DInfoPTM.getInfoPTMMap().get(peptidePTM.getIdPtmSpecificity());
                        deltaMass += pepInfoPtm.getMonoMass();
                    }
                    lazyData.setData((Comparable)Double.valueOf(deltaMass));
                } else {
                    lazyData.setData((Comparable)Double.valueOf(Double.NaN));
                }
                return lazyData;
            }
            case 9: {
                return ptmCluster.getPositionsOnProtein();
            }
            case 11: {
                return ptmCluster.getSiteConfidences();
            }
            case 10: {
                return Float.valueOf(ptmCluster.getLocalizationConfidence().floatValue() * 100.0f);
            }
            case 7: {
                return ptmCluster.getPeptideCount();
            }
            case 8: {
                return ptmCluster.getPTMSites().size();
            }
            case 13: {
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                    return lazyData;
                }
                lazyData.setData((Comparable)((Object)peptideMatch.getMsQuery().getDSpectrum().getTitle()));
                return lazyData;
            }
        }
        if (ptmCluster.getRepresentativeMQPepMatch() == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, row, col);
            return lazyData;
        }
        DMasterQuantPeptide masterQuantPep = ptmCluster.getRepresentativeMQPepMatch();
        int dynQchIndex = col - 14;
        int nbQc = dynQchIndex / m_columnNamesQC.length;
        int id = dynQchIndex - nbQc * m_columnNamesQC.length;
        Map quantPeptideByQchIds = masterQuantPep.getQuantPeptideByQchIds();
        if (quantPeptideByQchIds == null) {
            switch (id) {
                case 0: {
                    lazyData.setData((Comparable)Integer.valueOf(0));
                    break;
                }
                case 1: {
                    lazyData.setData((Comparable)Float.valueOf(0.0f));
                }
            }
        } else {
            QuantChannelInfo qcinfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
            DQuantPeptide quantPeptide = (DQuantPeptide)quantPeptideByQchIds.get(qcinfo.getQuantChannels()[nbQc].getId());
            if (quantPeptide == null) {
                switch (id) {
                    case 0: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 1: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                    }
                }
            } else {
                switch (id) {
                    case 1: {
                        lazyData.setData((Comparable)(quantPeptide.getAbundance() == null || quantPeptide.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getAbundance()));
                        break;
                    }
                    case 0: {
                        lazyData.setData((Comparable)(quantPeptide.getRawAbundance() == null || quantPeptide.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptide.getRawAbundance()));
                    }
                }
            }
        }
        return lazyData;
    }

    public void setData(Long taskId, ArrayList<PTMCluster> proteinPTMClusterArray) {
        this.m_ptmClusters = proteinPTMClusterArray;
        this.m_taskId = taskId;
        this.m_modificationInfo = "";
        if (this.m_ptmClusters != null) {
            this.m_ptmClusters.sort((o1, o2) -> {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getId().compareTo(o2.getId());
            });
            Map<Boolean, List<PTMCluster>> clustersBySitesCount = this.m_ptmClusters.stream().collect(Collectors.partitioningBy(c -> c.getPTMSites().size() > 1));
            StringBuilder sb = new StringBuilder();
            Map<String, Long> countByPtms = clustersBySitesCount.get(Boolean.FALSE).stream().collect(Collectors.groupingBy(c -> ((PTMSite)c.getPTMSites().get(0)).getPTMSpecificity().getPtmShortName(), Collectors.counting()));
            Iterator<String> it = countByPtms.keySet().iterator();
            while (it.hasNext()) {
                String modification = it.next();
                Long nbModifications = countByPtms.get(modification);
                sb.append(modification).append(":").append(nbModifications);
                if (!it.hasNext()) continue;
                sb.append("   ");
            }
            List<PTMCluster> multiplePtmsClusters = clustersBySitesCount.get(Boolean.TRUE);
            if (multiplePtmsClusters != null && !multiplePtmsClusters.isEmpty()) {
                sb.append("   Multiple Sites:").append(multiplePtmsClusters.size());
            }
            this.m_modificationInfo = sb.toString();
            QuantChannelInfo qcInfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
            boolean bl = this.m_isQuantitationDS = qcInfo != null;
            if (qcInfo != null) {
                this.m_quantChannelNumber = qcInfo.getQuantChannels().length;
                this.m_quantChannels = qcInfo.getQuantChannels();
            } else {
                this.m_quantChannelNumber = 0;
                this.m_quantChannels = null;
            }
        }
        this.fireTableStructureChanged();
    }

    public String getModificationsInfo() {
        return this.m_modificationInfo;
    }

    public void dataUpdated() {
        QuantChannelInfo qcInfo = (QuantChannelInfo)this.getSingleValue(QuantChannelInfo.class);
        boolean isQuandDS = qcInfo != null;
        boolean structChanged = false;
        if (isQuandDS && this.m_isQuantitationDS) {
            if (this.m_quantChannelNumber != qcInfo.getQuantChannels().length) {
                this.m_quantChannelNumber = qcInfo.getQuantChannels().length;
                this.m_quantChannels = qcInfo.getQuantChannels();
                structChanged = true;
            }
        } else if (isQuandDS) {
            this.m_isQuantitationDS = isQuandDS;
            this.m_quantChannelNumber = qcInfo.getQuantChannels().length;
            this.m_quantChannels = qcInfo.getQuantChannels();
            structChanged = true;
        }
        if (structChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public PTMCluster getProteinPTMCluster(int i) {
        return this.m_ptmClusters.get(i);
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return DPeptideMatch.class;
            }
            case 4: 
            case 13: {
                return String.class;
            }
            case 12: {
                return Double.class;
            }
            case 5: 
            case 6: {
                return Float.class;
            }
        }
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            return ((DPeptideMatch)((LazyData)this.getValueAt(rowIndex, columnIndex)).getData()).getPeptide().getSequence();
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 2;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(0, (Filter)new LongFilter(this.getColumnName(0), null, 0));
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), null, 2));
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), peptideConverter, 3));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), null, 4));
        filtersMap.put(12, (Filter)new DoubleFilter(this.getColumnName(12), null, 12));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(10, (Filter)new DoubleFilter(this.getColumnName(10), null, 10));
        filtersMap.put(7, (Filter)new IntegerFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(13, (Filter)new StringDiffFilter(this.getColumnName(13), null, 13));
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        if (col == 3) {
            PTMCluster proteinPTMCluster = this.m_ptmClusters.get(row);
            DPeptideMatch peptideMatch = proteinPTMCluster.getRepresentativePepMatch();
            return ExportFontModelUtilities.getExportFonts(peptideMatch);
        }
        return null;
    }

    public String getExportColumnName(int col) {
        if (col <= 14) {
            return this.getColumnName(col);
        }
        if (this.m_isQuantitationDS) {
            int nbQc = (col - 14) / m_columnNamesQC.length;
            int id = col - 14 - nbQc * m_columnNamesQC.length;
            StringBuilder sb = new StringBuilder();
            sb.append(m_columnNamesQC[id]);
            sb.append(" ");
            sb.append(this.m_quantChannels[nbQc].getName());
            return sb.toString();
        }
        return "";
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 3: {
                renderer = new PeptideRenderer();
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 5: 
            case 10: {
                renderer = new PercentageRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 12: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4);
                break;
            }
            case 6: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 11: {
                renderer = new CollectionRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 2);
                break;
            }
            case 9: {
                renderer = new CollectionRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            default: {
                if (!this.m_isQuantitationDS) break;
                int nbQc = (col - 14) / m_columnNamesQC.length;
                int id = col - 14 - nbQc * m_columnNamesQC.length;
                switch (id) {
                    case 0: 
                    case 1: {
                        renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                    }
                }
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(PTMSite.class, true));
        list.add(new ExtraDataType(DProteinMatch.class, true));
        list.add(new ExtraDataType(DPeptideMatch.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(PTMCluster.class)) {
            return this.m_ptmClusters.get(row);
        }
        if (c.equals(DProteinMatch.class)) {
            return this.m_ptmClusters.get(row).getProteinMatch();
        }
        if (c.equals(DPeptideMatch.class)) {
            return this.m_ptmClusters.get(row).getRepresentativePepMatch();
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

