/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.MsQueryRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.ExportFontModelUtilities;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableColumn;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PeptideTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_PREVIOUS_AA = 1;
    public static final int COLTYPE_PEPTIDE_NAME = 2;
    public static final int COLTYPE_PEPTIDE_NEXT_AA = 3;
    public static final int COLTYPE_PEPTIDE_LENGTH = 4;
    public static final int COLTYPE_PEPTIDE_PTM = 5;
    public static final int COLTYPE_PEPTIDE_PSM_SCORE = 6;
    public static final int COLTYPE_PEPTIDE_START = 7;
    public static final int COLTYPE_PEPTIDE_STOP = 8;
    public static final int COLTYPE_PEPTIDE_CALCULATED_MASS = 9;
    public static final int COLTYPE_PEPTIDE_EXPERIMENTAL_MOZ = 10;
    public static final int COLTYPE_PEPTIDE_PPM = 11;
    public static final int COLTYPE_PEPTIDE_CHARGE = 12;
    public static final int COLTYPE_PEPTIDE_MISSED_CLIVAGE = 13;
    public static final int COLTYPE_PEPTIDE_RANK = 14;
    public static final int COLTYPE_PEPTIDE_RETENTION_TIME = 15;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_COUNT = 16;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_NAMES = 17;
    public static final int COLTYPE_PEPTIDE_ION_PARENT_INTENSITY = 18;
    public static final int COLTYPE_PEPTIDE_MSQUERY = 19;
    public static final int COLTYPE_SPECTRUM_TITLE = 20;
    public static final int COLTYPE_PEPTIDE_SCORE = 21;
    private static final TableColumn[] COLUMNS = new TableColumn.Builder().add(0, "Id", "Peptide Instance Id", Long.class).add(1, "Prev. AA", "Previous Amino Acid", String.class).add(2, "Peptide", "Peptide", DPeptideMatch.class).add(3, "Next AA", "Next Amino Acid", String.class).add(4, "Length", "Length", Integer.class).add(5, "PTMs", "Post Translational Modifications", String.class).add(6, "PSM Score", "Best PSM Score", Float.class).add(7, "Start", "Start position", Integer.class).add(8, "Stop", "Stop position", Integer.class).add(9, "Calc. Mass", "Calculated Mass", Double.class).add(10, "Exp. MoZ", "Experimental Mass to Charge Ratio", Double.class).add(11, "Ppm", "parts-per-million", Float.class).add(12, "Charge", "Charge", Integer.class).add(13, "Missed Cl.", "Missed Cleavages", Integer.class).add(14, "Rank", "Pretty Rank", Integer.class).add(15, "RT", "Retention Time (min)", Float.class).add(16, "Protein Set Count", "Protein Sets Count", Integer.class).add(17, "Protein Sets", "List of matching Protein Sets", String.class).add(18, "Ion Parent Int.", "Ion Parent Intensity", Float.class).add(19, "MsQuery", "MsQuery", DMsQuery.class).add(20, "Spectrum Title", "Spectrum Title", String.class).add(21, "Score", "Peptide Score", Float.class).build();
    private DPeptideInstance[] m_peptideInstances = null;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public DPeptideInstance getPeptide(int row) {
        return this.m_peptideInstances[row];
    }

    public int findRow(long peptideMatchId) {
        if (this.m_peptideInstances == null) {
            return -1;
        }
        int nb = this.m_peptideInstances.length;
        for (int i = 0; i < nb; ++i) {
            DPeptideInstance peptideInstance = this.m_peptideInstances[i];
            if (peptideInstance.getBestPeptideMatch().getId() != peptideMatchId) continue;
            return i;
        }
        return -1;
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public String getColumnName(int col) {
        return COLUMNS[col].getName();
    }

    public String getToolTipForHeader(int col) {
        return COLUMNS[col].getTooltip();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        return COLUMNS[col].getType();
    }

    public int getRowCount() {
        if (this.m_peptideInstances == null) {
            return 0;
        }
        return this.m_peptideInstances.length;
    }

    public Object getValueAt(int row, int col) {
        DPeptideInstance peptideInstance = this.m_peptideInstances[row];
        DPeptideMatch peptideMatch = peptideInstance.getBestPeptideMatch();
        SequenceMatch sequenceMatch = peptideMatch.getSequenceMatch();
        switch (col) {
            case 0: {
                return peptideInstance.getId();
            }
            case 1: {
                if (sequenceMatch == null) {
                    return "";
                }
                Character residueBefore = sequenceMatch.getResidueBefore();
                if (residueBefore != null) {
                    return String.valueOf(Character.toUpperCase(residueBefore.charValue()));
                }
                return "";
            }
            case 2: {
                return peptideMatch;
            }
            case 3: {
                if (sequenceMatch == null) {
                    return "";
                }
                Character residueAfter = sequenceMatch.getResidueAfter();
                if (residueAfter != null) {
                    return String.valueOf(Character.toUpperCase(residueAfter.charValue()));
                }
                return "";
            }
            case 4: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getPeptide().getSequence().length();
            }
            case 6: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getScore();
            }
            case 14: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getCDPrettyRank() == null ? null : peptideMatch.getCDPrettyRank();
            }
            case 16: {
                if (peptideMatch == null) {
                    return null;
                }
                Peptide p = peptideMatch.getPeptide();
                if (p == null) {
                    return null;
                }
                HashSet proteinSetList = new HashSet(p.getTransientData().getProteinSetArray());
                if (proteinSetList == null) {
                    return null;
                }
                return proteinSetList.size();
            }
            case 17: {
                if (peptideMatch == null) {
                    return "";
                }
                Peptide p = peptideMatch.getPeptide();
                if (p == null || p.getTransientData().getProteinSetArray() == null) {
                    return "";
                }
                HashSet proteinSetList = new HashSet(p.getTransientData().getProteinSetArray());
                if (proteinSetList.isEmpty()) {
                    return "";
                }
                StringBuilder display = new StringBuilder();
                int nbProteinGroups = proteinSetList.size();
                display.append(nbProteinGroups);
                display.append(" (");
                int startSize = display.length();
                proteinSetList.forEach(ps -> {
                    if (display.length() > startSize) {
                        display.append(',');
                    }
                    display.append(ps.getTypicalProteinMatch().getAccession());
                });
                display.append(')');
                return display.toString();
            }
            case 12: {
                if (peptideMatch == null) {
                    return "";
                }
                return peptideMatch.getCharge();
            }
            case 10: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getExperimentalMoz();
            }
            case 11: {
                if (peptideMatch == null) {
                    return null;
                }
                float ppm = PeptideClassesUtils.getPPMFor((DPeptideMatch)peptideMatch, (Peptide)peptideMatch.getPeptide()).floatValue();
                return Float.valueOf(ppm);
            }
            case 7: {
                if (sequenceMatch == null) {
                    return null;
                }
                int start = sequenceMatch.getId().getStart();
                return start;
            }
            case 8: {
                if (sequenceMatch == null) {
                    return null;
                }
                int stop = sequenceMatch.getId().getStop();
                return stop;
            }
            case 9: {
                Peptide p;
                if (peptideMatch != null && (p = peptideMatch.getPeptide()) != null) {
                    return p.getCalculatedMass();
                }
                return null;
            }
            case 13: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getMissedCleavage();
            }
            case 15: {
                if (peptideMatch == null) {
                    return null;
                }
                return peptideMatch.getRetentionTime();
            }
            case 19: {
                if (peptideMatch == null) {
                    return null;
                }
                DMsQuery msQuery = peptideMatch.getMsQuery();
                return msQuery;
            }
            case 20: {
                if (peptideMatch == null) {
                    return null;
                }
                DMsQuery msQuery = peptideMatch.getMsQuery();
                if (msQuery == null) {
                    return null;
                }
                DSpectrum s = msQuery.getDSpectrum();
                if (s == null) {
                    return null;
                }
                return s.getTitle();
            }
            case 18: {
                DMsQuery msQuery;
                if (peptideMatch != null && (msQuery = peptideMatch.getMsQuery()) != null) {
                    Float precursorIntensity = msQuery.getPrecursorIntensity();
                    return precursorIntensity;
                }
                return null;
            }
            case 5: {
                if (peptideMatch == null) {
                    return "";
                }
                Peptide p = peptideMatch.getPeptide();
                if (p == null) {
                    return "";
                }
                boolean ptmStringLoaded = p.getTransientData().isPeptideReadablePtmStringLoaded();
                if (!ptmStringLoaded) {
                    return "";
                }
                String ptm = "";
                PeptideReadablePtmString ptmString = p.getTransientData().getPeptideReadablePtmString();
                if (ptmString != null) {
                    ptm = ptmString.getReadablePtmString();
                }
                return ptm;
            }
            case 21: {
                Map properties = peptideInstance.getProperties();
                if (properties == null || !properties.containsKey("score")) {
                    return null;
                }
                Double score = (Double)((Map)properties.get("score")).get("score");
                return Float.valueOf(score.floatValue());
            }
        }
        return null;
    }

    public void setData(DPeptideInstance[] peptideInstances) {
        this.m_peptideInstances = peptideInstances;
        this.fireTableDataChanged();
    }

    public DPeptideInstance[] getPeptideInstances() {
        return this.m_peptideInstances;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), null, 1));
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DPeptideMatch)o).getPeptide().getSequence();
            }
        };
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnName(2), peptideConverter, 2));
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new IntegerFilter(this.getColumnName(4), null, 4));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(14, (Filter)new IntegerFilter(this.getColumnName(14), null, 14));
        filtersMap.put(16, (Filter)new IntegerFilter(this.getColumnName(16), null, 16));
        filtersMap.put(17, (Filter)new StringDiffFilter(this.getColumnName(17), null, 17));
        filtersMap.put(7, (Filter)new IntegerFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new DoubleFilter(this.getColumnName(9), null, 9));
        filtersMap.put(10, (Filter)new DoubleFilter(this.getColumnName(10), null, 10));
        filtersMap.put(11, (Filter)new DoubleFilter(this.getColumnName(11), null, 11));
        filtersMap.put(12, (Filter)new IntegerFilter(this.getColumnName(12), null, 12));
        filtersMap.put(13, (Filter)new IntegerFilter(this.getColumnName(13), null, 13));
        filtersMap.put(15, (Filter)new DoubleFilter(this.getColumnName(15), null, 15));
        ConvertValueInterface msQueryConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((DMsQuery)o).getInitialId();
            }
        };
        filtersMap.put(19, (Filter)new IntegerFilter(this.getColumnName(19), msQueryConverter, 19));
        filtersMap.put(20, (Filter)new StringDiffFilter(this.getColumnName(20), null, 20));
        filtersMap.put(18, (Filter)new DoubleFilter(this.getColumnName(18), null, 18));
        filtersMap.put(5, (Filter)new StringDiffFilter(this.getColumnName(5), null, 5));
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public boolean isLoaded() {
        return true;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return String.class;
        }
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return ((DPeptideMatch)this.getValueAt(rowIndex, columnIndex)).getPeptide().getSequence();
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2, 0};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 2;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        if (col == 2) {
            return ExportFontModelUtilities.getExportFonts(this.m_peptideInstances[row]);
        }
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 1: 
            case 3: 
            case 5: 
            case 17: {
                renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                break;
            }
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 6: 
            case 21: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 11: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 15: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                break;
            }
            case 9: 
            case 10: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 19: {
                renderer = new MsQueryRenderer();
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DPeptideInstance.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DPeptideInstance.class)) {
            return this.m_peptideInstances[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

