/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.model;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.utils.URLCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class ProteinsOfPeptideMatchTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PROTEIN_ID = 0;
    public static final int COLTYPE_PROTEIN_NAME = 1;
    public static final int COLTYPE_PROTEIN_SCORE = 2;
    public static final int COLTYPE_PROTEIN_PEPTIDES_COUNT = 3;
    public static final int COLTYPE_PROTEIN_MASS = 4;
    private static final String[] m_columnNames = new String[]{"Id", "Protein", "Score", "Peptides", "Mass"};
    private DProteinMatch[] m_proteinMatchArray = null;
    private String m_modelName;
    private ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public ProteinsOfPeptideMatchTableModel(LazyTable table) {
    }

    public DProteinMatch getProteinMatch(int row) {
        return this.m_proteinMatchArray[row];
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getToolTipForHeader(int col) {
        return this.getColumnName(col);
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Float.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_proteinMatchArray == null) {
            return 0;
        }
        return this.m_proteinMatchArray.length;
    }

    public Object getValueAt(int row, int col) {
        DProteinMatch proteinMatch = this.m_proteinMatchArray[row];
        switch (col) {
            case 0: {
                return proteinMatch.getId();
            }
            case 1: {
                return proteinMatch.getAccession();
            }
            case 2: {
                return proteinMatch.getScore();
            }
            case 3: {
                return proteinMatch.getPeptideCount();
            }
            case 4: {
                DBioSequence bioSequence = proteinMatch.getDBioSequence();
                if (bioSequence != null) {
                    return new Float(bioSequence.getMass());
                }
                return Float.valueOf(Float.NaN);
            }
        }
        return null;
    }

    public void setData(DProteinMatch[] proteinMatchArray) {
        this.m_proteinMatchArray = proteinMatchArray;
        this.updateMinMax();
        this.fireTableDataChanged();
    }

    private void updateMinMax() {
        if (this.m_proteinMatchArray == null) {
            return;
        }
        if (this.m_scoreRenderer == null) {
            return;
        }
        float maxScore = 0.0f;
        for (DProteinMatch proteinMatch : this.m_proteinMatchArray) {
            float score = proteinMatch.getScore().floatValue();
            if (!(score > maxScore)) continue;
            maxScore = score;
        }
        this.m_scoreRenderer.setMaxValue(maxScore);
    }

    public int findRow(long proteinMatchId) {
        int nb = this.m_proteinMatchArray.length;
        for (int i = 0; i < nb; ++i) {
            if (proteinMatchId != this.m_proteinMatchArray[i].getId()) continue;
            return i;
        }
        return -1;
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnName(1), null, 1));
        filtersMap.put(2, (Filter)new DoubleFilter(this.getColumnName(2), null, 2));
        filtersMap.put(3, (Filter)new IntegerFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{1, 0};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 1;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        switch (col) {
            case 1: {
                renderer = new URLCellRenderer("URL_Template_Protein_Accession", "http://www.uniprot.org/uniprot/", 1);
                break;
            }
            case 2: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 4: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 3: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DProteinMatch.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DProteinMatch.class)) {
            return this.m_proteinMatchArray[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }
}

