/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm;

import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMSitePeptidesGraphicDataMgr;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMSitePeptidesGraphicViewPanel;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.PTMMarkCtrl;
import fr.proline.studio.rsmexplorer.gui.ptm.mark.ProteinSequence;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideAreaCtrl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMSitePeptidesGraphicCtrlPanel
extends JPanel
implements DataBoxPanelInterface,
SplittedPanelContainer.UserActions {
    private static Logger logger = LoggerFactory.getLogger(PTMSitePeptidesGraphicCtrlPanel.class);
    protected PTMSitePeptidesGraphicDataMgr m_dataMgr = new PTMSitePeptidesGraphicDataMgr();
    protected PTMSitePeptidesGraphicViewPanel m_paintArea;
    protected PTMMarkCtrl m_ctrlMark = new PTMMarkCtrl();
    protected ProteinSequence m_ctrlSequence = new ProteinSequence();
    protected PeptideAreaCtrl m_ctrlPeptideArea = new PeptideAreaCtrl();
    protected AbstractDataBox m_dataBox;
    protected PTMSite m_currentPTMSite = null;

    public PTMSitePeptidesGraphicCtrlPanel() {
        this.m_paintArea = new PTMSitePeptidesGraphicViewPanel(this, this.m_ctrlMark, this.m_ctrlSequence, this.m_ctrlPeptideArea);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_paintArea.setSize(-29, 2);
        JToolBar toolbar = this.initToolbar();
        this.add((Component)toolbar, "West");
        this.add((Component)this.m_paintArea, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(PTMSite peptidesPTMSite, DPeptideInstance pepInst) {
        if (peptidesPTMSite == null) {
            return;
        }
        if (peptidesPTMSite.equals(this.m_currentPTMSite)) {
            return;
        }
        this.m_dataMgr.setData(peptidesPTMSite);
        if (peptidesPTMSite == null) {
            this.m_paintArea.clean();
        } else {
            this.m_currentPTMSite = peptidesPTMSite;
            this.m_ctrlSequence.setData(this.m_dataMgr.getProteinSequence());
            this.m_ctrlSequence.setPTMSequencePosition(this.m_dataMgr.getPTMSiteSeqPos());
            this.m_ctrlMark.setData(this.m_dataMgr.getAllPtmMarks());
            this.m_ctrlPeptideArea.setData(this.m_dataMgr.getPTMSitePeptideInstances());
            this.m_ctrlPeptideArea.setSelectedIndex(0);
            this.m_paintArea.setIsDataLoaded(true);
            this.m_paintArea.setRowCount(this.m_dataMgr.getRowCount());
            this.m_paintArea.setSequenceLength(this.m_dataMgr.getProteinSequence().length());
            int ajustedLocation = this.m_dataMgr.getBeginBestFit();
            this.m_paintArea.setScrollLocation(ajustedLocation);
            this.valueChanged();
        }
        this.repaint();
    }

    protected void valueChanged() {
        this.m_dataBox.addDataChanged(PTMSite.class);
        this.m_dataBox.propagateDataChanged();
        this.repaint();
    }

    public void setSelectedRow(int i) {
        this.m_ctrlPeptideArea.setSelectedIndex(i);
        this.m_paintArea.setSelectedPeptideIndex(i);
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void setLoading(int id) {
    }

    @Override
    public void setLoading(int id, boolean calculating) {
    }

    @Override
    public void setLoaded(int id) {
    }
}

