/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.mark;

import fr.proline.studio.rsmexplorer.gui.ptm.PTMMark;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewPtmAbstract;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMMarkView
extends ViewPtmAbstract {
    private static Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private PTMMark m_mark;
    private String m_symbol;
    private Color m_color;

    public PTMMarkView(PTMMark mark) {
        this.m_mark = mark;
        this.m_color = ViewSetting.getColor(mark);
        this.m_symbol = Character.toString(mark.getPtmSymbol());
    }

    @Override
    public void setBeginPoint(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public int getLocationProtein() {
        return this.m_mark.getProteinLocation();
    }

    public int getDisplayedLocationProtein() {
        return this.m_mark.getProteinLocationToDisplay();
    }

    public String getPTMShortName() {
        return this.m_mark.getPtmShortName();
    }

    @Override
    public void paint(Graphics2D g, ViewContext viewContext) {
        FontMetrics fm = g.getFontMetrics(ViewSetting.FONT_PTM);
        Color oldColor = g.getColor();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.x0 = this.m_x + this.getLocationProtein() * ViewSetting.WIDTH_AA;
        this.y0 = this.m_y + ViewSetting.HEIGHT_AA;
        int xWidthAA = this.x0 + ViewSetting.WIDTH_AA;
        int yHeightAA = this.y0 + ViewSetting.HEIGHT_AA;
        int yBottom = (int)((double)this.y0 + (double)ViewSetting.HEIGHT_AA * 1.5);
        int xCenter = this.x0 + ViewSetting.WIDTH_AA / 2;
        g.setColor(this.m_color);
        if (this.m_mark.isPTMNorCterm()) {
            int[] xPtm = new int[]{this.x0, xWidthAA, this.x0 + ViewSetting.WIDTH_AA / 2};
            int[] yPtm = new int[]{yHeightAA, yHeightAA, (int)((double)this.y0 + (double)ViewSetting.HEIGHT_AA * 1.5)};
            g.fillPolygon(xPtm, yPtm, yPtm.length);
        } else {
            g.setStroke(ViewSetting.STROKE);
            g.drawLine(this.x0, this.y0, xWidthAA, this.y0);
            g.drawLine(xWidthAA, this.y0, xWidthAA, yHeightAA);
            g.drawLine(xWidthAA, yHeightAA, this.x0, yHeightAA);
            g.drawLine(this.x0, yHeightAA, this.x0, this.y0);
            g.drawLine(xCenter, yHeightAA, xCenter, yBottom);
            g.drawLine(this.x0, yBottom, xWidthAA, yBottom);
            g.setFont(ViewSetting.FONT_PTM);
            int stringWidth = fm.stringWidth(this.m_symbol);
            g.drawString(this.m_symbol, xCenter - stringWidth / 2, yHeightAA - (ViewSetting.HEIGHT_AA - stringWidth) / 2);
        }
        if (!this.m_mark.isPTMNorCterm() || this.m_mark.isPTMNorCterm() && viewContext.isNCtermIndexShown()) {
            g.setColor(Color.BLACK);
            g.setFont(ViewSetting.FONT_NUMBER);
            fm = g.getFontMetrics(ViewSetting.FONT_NUMBER);
            int descent = fm.getDescent();
            int stringWidth = fm.stringWidth(String.valueOf(this.getLocationProtein()));
            if (stringWidth > ViewSetting.WIDTH_AA - ViewSetting.BORDER_GAP + 3) {
                Font smallerFont = ViewSetting.FONT_NUMBER_DIAGONAL;
                g.setFont(smallerFont);
                fm = g.getFontMetrics(smallerFont);
                stringWidth = fm.stringWidth(String.valueOf(this.getLocationProtein()));
            }
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(String.valueOf(this.getDisplayedLocationProtein()), xCenter - stringWidth / 2, this.y0 - descent / 2);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g.setColor(oldColor);
    }

    public String toString() {
        return "ViewPtmMark{m_type=" + this.m_symbol + ", _locationProtein=" + this.getLocationProtein() + ", m_displayedLocationProtein=" + this.getDisplayedLocationProtein() + '}';
    }
}

