/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.pep;

import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import fr.proline.studio.rsmexplorer.gui.ptm.pep.PeptideView;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PeptideAreaModel {
    ArrayList<PeptideView> m_viewPeptideList = new ArrayList();
    int m_selectedIndex = 0;

    public ArrayList<PeptideView> getViewPeptideList() {
        return this.m_viewPeptideList;
    }

    public void setPTM(List<PTMSitePeptideInstance> pPeptide) {
        this.m_viewPeptideList = new ArrayList();
        for (PTMSitePeptideInstance pep : pPeptide) {
            PeptideView p = new PeptideView(pep);
            this.m_viewPeptideList.add(p);
        }
    }

    public void setPTMPeptides(List<PTMPeptideInstance> pPeptide) {
        this.m_viewPeptideList = new ArrayList();
        boolean onlyProtNtermWO_M = true;
        List allSites = pPeptide.stream().flatMap(pi -> pi.getPTMSites().stream()).collect(Collectors.toList());
        for (PTMSite site : allSites) {
            onlyProtNtermWO_M = onlyProtNtermWO_M && site.isProteinNTermWithOutM();
        }
        for (PTMPeptideInstance pep : pPeptide) {
            PeptideView p = new PeptideView(pep, onlyProtNtermWO_M);
            this.m_viewPeptideList.add(p);
        }
    }

    protected void setSelectedIndex(int index) {
        if (index == -1) {
            return;
        }
        this.m_selectedIndex = index;
        for (int i = 0; i < this.m_viewPeptideList.size(); ++i) {
            PeptideView pv = this.m_viewPeptideList.get(i);
            if (i != index) {
                pv.setSelected(false);
                continue;
            }
            pv.setSelected(true);
        }
    }

    protected void setRelativeSelected(int relative) {
        int index = this.m_selectedIndex + relative;
        if (index == -1 || index == this.getViewPeptideList().size()) {
            return;
        }
        this.m_selectedIndex = index;
        this.setSelectedIndex(index);
    }

    protected int getSelectedIndex() {
        return this.m_selectedIndex;
    }
}

