/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.ptm.pep;

import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewContext;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewPtmAbstract;
import fr.proline.studio.rsmexplorer.gui.ptm.ViewSetting;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeptideView
extends ViewPtmAbstract {
    private static Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    protected int m_length;
    private boolean isPtmSiteView;
    private PTMSitePeptideInstance m_ptmSitePeptideInst;
    private PTMPeptideInstance m_ptmPeptideInst;
    protected boolean m_isSelected;
    protected int m_beginIndex;

    public PeptideView(PTMSitePeptideInstance pep) {
        this.isPtmSiteView = true;
        this.x0 = 0;
        this.y0 = 0;
        this.m_ptmSitePeptideInst = pep;
        this.m_ptmPeptideInst = pep.getParentPTMPeptideInstance();
        String sequence = this.m_ptmPeptideInst.getSequence();
        this.m_length = sequence != null ? this.m_ptmPeptideInst.getSequence().length() : 0;
        this.m_beginIndex = this.m_ptmPeptideInst.getStartPosition();
        if (this.m_beginIndex == 1 && pep.getSite().isProteinNTermWithOutM()) {
            this.m_beginIndex = 0;
        }
        this.m_isSelected = false;
    }

    public PeptideView(PTMPeptideInstance pep) {
        this.isPtmSiteView = false;
        this.x0 = 0;
        this.y0 = 0;
        this.m_isSelected = false;
        this.m_ptmPeptideInst = pep;
        this.m_ptmSitePeptideInst = null;
        this.m_length = 0;
        this.m_beginIndex = 0;
        if (pep != null) {
            if (pep.getSequence() != null) {
                this.m_length = pep.getSequence().length();
            }
            this.m_beginIndex = pep.getStartPosition();
            boolean isProteinNTerm = false;
            for (PTMSite site : pep.getPTMSites()) {
                if (!site.isProteinNTermWithOutM()) continue;
                isProteinNTerm = true;
                break;
            }
            if (this.m_beginIndex == 1 && isProteinNTerm) {
                this.m_beginIndex = 0;
            }
        }
        this.m_isSelected = false;
    }

    public PeptideView(PTMPeptideInstance pep, boolean displayProtWithOutNtermM) {
        this.isPtmSiteView = false;
        this.x0 = 0;
        this.y0 = 0;
        this.m_isSelected = false;
        this.m_ptmPeptideInst = pep;
        this.m_ptmSitePeptideInst = null;
        this.m_length = 0;
        this.m_beginIndex = 0;
        if (pep != null) {
            if (pep.getSequence() != null) {
                this.m_length = pep.getSequence().length();
            }
            this.m_beginIndex = pep.getStartPosition();
            if (this.m_beginIndex == 1 && displayProtWithOutNtermM) {
                this.m_beginIndex = 0;
            }
        }
        this.m_isSelected = false;
    }

    private Map<Integer, DPeptidePTM> getPosPtmMap() {
        return this.m_ptmPeptideInst.getPeptideInstance().getPeptide().getTransientData().getDPeptidePtmMap();
    }

    protected float getScore() {
        if (this.isPtmSiteView) {
            return this.m_ptmSitePeptideInst.getRepresentativePepMatch().getScore().floatValue();
        }
        return this.m_ptmPeptideInst.getRepresentativePepMatch().getScore().floatValue();
    }

    @Override
    public void paint(Graphics2D g, ViewContext viewContext) {
        int aaWidth = ViewSetting.WIDTH_AA;
        this.x0 = this.m_x + aaWidth + this.m_beginIndex * aaWidth;
        this.y0 = this.m_y + 1;
        int width = this.m_length * aaWidth;
        int height = ViewSetting.HEIGHT_AA - 1;
        Color c = PeptideView.getColorWithProbability(ViewSetting.PEPTIDE_COLOR, Float.valueOf((float)Math.min((double)Math.max(this.getScore(), 15.0f) / 100.0, 1.0)));
        g.setColor(c);
        g.fillRoundRect(this.x0, this.y0, width, height, aaWidth, ViewSetting.HEIGHT_AA);
        Map<Integer, DPeptidePTM> map = this.getPosPtmMap();
        for (Map.Entry<Integer, DPeptidePTM> modifyA : map.entrySet()) {
            this.paintPtm(g, modifyA.getValue(), modifyA.getKey(), this.y0);
        }
        if (this.m_isSelected) {
            g.setColor(ViewSetting.SELECTED_PEPTIDE_COLOR);
            g.setStroke(ViewSetting.STROKE_PEP);
            g.drawRoundRect(this.x0, this.y0, width, height, aaWidth, ViewSetting.HEIGHT_AA);
        }
    }

    @Override
    public void setBeginPoint(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    private void paintPtm(Graphics2D g, DPeptidePTM ptm, int location, int y01) {
        int aaWidth = ViewSetting.WIDTH_AA;
        Color colorOld = g.getColor();
        Color c = PeptideView.getColorWithProbability(ViewSetting.getColor(ptm.getIdPtmSpecificity()), this.getProbability(ptm));
        g.setColor(c);
        int x1 = (location - 1) * aaWidth;
        if (location == 0) {
            g.fillRoundRect(this.x0 + x1, y01, aaWidth, ViewSetting.HEIGHT_AA, aaWidth / 2, ViewSetting.HEIGHT_AA);
        } else if (location == 1) {
            g.fillRoundRect(this.x0 + x1, y01, aaWidth, ViewSetting.HEIGHT_AA, aaWidth / 2, ViewSetting.HEIGHT_AA);
            g.fillRect(this.x0 + x1 + aaWidth / 2, y01, aaWidth - aaWidth / 2, ViewSetting.HEIGHT_AA);
        } else if (location == this.m_length) {
            g.fillRect(this.x0 + x1, y01, aaWidth - aaWidth / 2, ViewSetting.HEIGHT_AA);
            g.fillRoundRect(this.x0 + x1, y01, aaWidth, ViewSetting.HEIGHT_AA, aaWidth / 2, ViewSetting.HEIGHT_AA);
        } else {
            g.fillRect(this.x0 + x1, y01, aaWidth, ViewSetting.HEIGHT_AA);
        }
        g.setColor(colorOld);
    }

    public static Color getColorWithProbability(Color c, Float probability) {
        if (probability != null) {
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbvals);
            Color colorWithProbability = Color.getHSBColor(hsbvals[0], hsbvals[1] * probability.floatValue(), hsbvals[2]);
            return colorWithProbability;
        }
        return CyclicColorPalette.GRAY_TEXT_LIGHT;
    }

    public Float getProbability(DPeptidePTM ptm) {
        DPeptideMatch pepMatch = this.isPtmSiteView ? this.m_ptmSitePeptideInst.getRepresentativePepMatch() : this.m_ptmPeptideInst.getRepresentativePepMatch();
        DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
        if (properties != null) {
            String readablePtm = ((DInfoPTM)DInfoPTM.getInfoPTMMap().get(ptm.getIdPtmSpecificity())).toReadablePtmString((int)ptm.getSeqPosition());
            Float probability = (Float)properties.getMascotProbabilityBySite().get(readablePtm);
            if (probability == null) {
                readablePtm = ((DInfoPTM)DInfoPTM.getInfoPTMMap().get(ptm.getIdPtmSpecificity())).toOtherReadablePtmString((int)ptm.getSeqPosition());
                probability = (Float)properties.getMascotProbabilityBySite().get(readablePtm);
                if (probability == null) {
                    probability = Float.valueOf(1.0f);
                }
            }
            return probability;
        }
        return null;
    }

    private String getReadablePtmString(DPeptidePTM ptm) {
        DPeptideMatch pepMatch = this.isPtmSiteView ? this.m_ptmSitePeptideInst.getRepresentativePepMatch() : this.m_ptmPeptideInst.getRepresentativePepMatch();
        DPtmSiteProperties properties = pepMatch.getPtmSiteProperties();
        if (properties != null) {
            String readablePtm = ((DInfoPTM)DInfoPTM.getInfoPTMMap().get(ptm.getIdPtmSpecificity())).toReadablePtmString((int)ptm.getSeqPosition());
            return readablePtm;
        }
        return null;
    }

    protected String getToolTipText(int x) {
        String s = null;
        if (this.isSelected(x)) {
            s = "Score: " + this.getScore();
            int xRangA = x - this.x0;
            int position = xRangA / ViewSetting.WIDTH_AA + 1;
            Map<Integer, DPeptidePTM> map = this.getPosPtmMap();
            DPeptidePTM ptm = map.get(position);
            if (ptm != null) {
                float prob = this.getProbability(ptm).floatValue() * 100.0f;
                String readable = this.getReadablePtmString(ptm);
                s = readable + ", " + String.format("%1$.2f", Float.valueOf(prob)) + "%";
            }
        }
        return s;
    }

    public boolean isSelected(int compareX) {
        int xRangA = this.x0;
        int xRangZ = this.x0 + this.m_length * ViewSetting.HEIGHT_AA;
        return compareX > xRangA && compareX < xRangZ;
    }

    void setSelected(boolean b) {
        this.m_isSelected = b;
    }
}

