/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.renderer;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.studio.rsmexplorer.gui.renderer.RendererMouseCallback;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class XicStatusRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private final RendererMouseCallback m_callback;
    private final int m_column;

    public XicStatusRenderer(RendererMouseCallback callback, int column) {
        this.m_callback = callback;
        this.m_column = column;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_callback == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.isShiftDown() || e.isControlDown()) {
            return;
        }
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            return;
        }
        this.m_callback.mouseAction(e);
    }

    private void checkCursor(MouseEvent e) {
        if (this.m_callback == null) {
            return;
        }
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int col = table.columnAtPoint(pt);
        int row = table.rowAtPoint(pt);
        int modelCol = table.convertColumnIndexToModel(col);
        if (modelCol != this.m_column || row == -1) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        JTableHeader th = table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        int columnStart = 0;
        for (int i = 0; i < col; ++i) {
            TableColumn column = tcm.getColumn(i);
            columnStart += column.getWidth();
        }
        if (columnStart + 20 < e.getX()) {
            table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        table.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static String getPepIonStatusText(DMasterQuantPeptideIon.PepIonStatus status) {
        switch (status) {
            case UNKNOWN: {
                return "Unknown";
            }
            case INVALIDATED: {
                return "Invalidated";
            }
            case VALIDATED: {
                return "Validated";
            }
            case USED_VALIDATED: {
                return "Validated/Used";
            }
            case UNUSED_VALIDATED: {
                return "Validated/Not Used";
            }
        }
        return "Other";
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object status = value;
        if (status instanceof SelectLevel) {
            SelectLevelEnum globalStatusValue = ((SelectLevel)status).m_globalStatus;
            SelectLevelEnum statusValue = ((SelectLevel)status).m_status;
            boolean locallyModified = statusValue.getIntValue() != globalStatusValue.getIntValue();
            switch (statusValue) {
                case DESELECTED_MANUAL: 
                case DESELECTED_AUTO: {
                    if (globalStatusValue.isDeselected()) {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
                        break;
                    }
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED_LOCALLY));
                    break;
                }
                case SELECTED_AUTO: 
                case SELECTED_MANUAL: {
                    if (globalStatusValue.isSelected()) {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
                        break;
                    }
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED_LOCALLY));
                    break;
                }
                default: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                }
            }
            this.setToolTipText(statusValue.getDescription());
        } else if (status instanceof DMasterQuantPeptideIon.PepIonStatus) {
            switch ((DMasterQuantPeptideIon.PepIonStatus)status) {
                case INVALIDATED: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INVALIDATED));
                    break;
                }
                case VALIDATED: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED));
                    break;
                }
                case USED_VALIDATED: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED_AND_USED));
                    break;
                }
                case UNUSED_VALIDATED: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.VALIDATED_AND_NOTUSED));
                    break;
                }
                default: {
                    this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CROSS_SMALL16));
                }
            }
            this.setToolTipText(XicStatusRenderer.getPepIonStatusText((DMasterQuantPeptideIon.PepIonStatus)status));
        }
        if (isSelected) {
            this.setBackground(UIManager.getDefaults().getColor("Table.selectionBackground"));
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(UIManager.getDefaults().getColor("Table.background"));
            this.setForeground(Color.BLACK);
        }
        return this;
    }

    public static enum SelectLevelEnum {
        DESELECTED_MANUAL(0, "Invalidated manually"),
        DESELECTED_AUTO(1, "Invalidated automatically"),
        SELECTED_AUTO(2, "Validated automatically"),
        SELECTED_MANUAL(3, "Validated Manual"),
        UNKNOWN(-1, "Invalid (not quantified)"),
        RESET_AUTO(-2, "Reset auto");

        private int _intValue;
        private String _description;
        private static HashMap map;

        private SelectLevelEnum(int value, String description) {
            this._intValue = value;
            this._description = description;
        }

        public boolean isSelected() {
            return this.equals((Object)SELECTED_AUTO) || this.equals((Object)SELECTED_MANUAL);
        }

        public boolean isDeselected() {
            return this.equals((Object)DESELECTED_AUTO) || this.equals((Object)DESELECTED_MANUAL);
        }

        public int getIntValue() {
            return this._intValue;
        }

        public String getDescription() {
            return this._description;
        }

        public static SelectLevelEnum valueOf(int status) {
            return (SelectLevelEnum)((Object)map.get(status));
        }

        static {
            map = new HashMap();
            for (SelectLevelEnum status : SelectLevelEnum.values()) {
                map.put(status._intValue, status);
            }
        }
    }

    public static class SelectLevel
    implements Comparable<SelectLevel> {
        public SelectLevelEnum m_status;
        public SelectLevelEnum m_globalStatus;

        public SelectLevel(SelectLevelEnum status, SelectLevelEnum globalStatus) {
            this.m_status = status;
            this.m_globalStatus = globalStatus;
        }

        public String getDescription() {
            return this.m_status.getDescription();
        }

        public SelectLevelEnum getStatus() {
            return this.m_status;
        }

        @Override
        public int compareTo(SelectLevel o) {
            int deltaStatus = this.m_globalStatus.getIntValue() - o.m_globalStatus.getIntValue();
            if (deltaStatus != 0) {
                return deltaStatus;
            }
            return this.m_status.getIntValue() - o.m_status.getIntValue();
        }
    }
}

