/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.logparser.gui.LogControlPanel;
import fr.proline.logparser.gui.LogReaderWorker;
import fr.proline.logparser.gui.TaskConsolePane;
import fr.proline.logparser.gui.TaskView;
import fr.proline.logparser.model.LogLineReader;
import fr.proline.logparser.model.Utility;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.gui.dialog.SystemInfoDialog;
import fr.proline.studio.rsmexplorer.gui.tasklog.ServerLogTaskListView;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLogControlPanel
extends LogControlPanel {
    protected static final Logger m_logger = LoggerFactory.getLogger(ServerLogControlPanel.class);
    private JInternalFrame m_taskFlowFrame;
    private JTextPane m_taskFlowTextPane;
    private ArrayList<File> m_fileList;
    Utility.DATE_FORMAT m_dateFormat = Utility.DATE_FORMAT.SHORT;
    InfoToggleButton m_infoToggleButton;
    private int BIG_FILE_SIZE = 0x400000;
    LogLineReader m_logReader;
    LogReaderWorker m_readWorker;
    JProgressBar m_progressBar;
    static String KEY_LOG_DATE_FORMAT = "Server_log_parse_date_format";
    static int MAX_LINE_TO_SHOW = 5000;

    public ServerLogControlPanel(ArrayList<File> localFileList, JInternalFrame taskFlowFrame, JProgressBar progressBar) {
        this.initParameters();
        this.m_fileList = localFileList;
        this.m_taskQueueView = new ServerLogTaskListView(this);
        this.m_taskView = new TaskView();
        this.m_taskConsole = new TaskConsolePane();
        this.setBackground(Color.white);
        this.m_progressBar = progressBar;
        this.m_taskFlowFrame = taskFlowFrame;
        this.m_taskFlowTextPane = new JTextPane();
        this.m_taskFlowFrame.getContentPane().add(new JScrollPane(this.m_taskFlowTextPane));
        this.initComponent();
        this.setSize(1400, 800);
        this.parseFile();
    }

    private void initComponent() {
        JPanel upPane = new JPanel(new BorderLayout());
        upPane.add((Component)((JScrollPane)this.m_taskQueueView), "Center");
        JScrollPane taskPane = new JScrollPane((Component)this.m_taskView);
        JSplitPane contentBottomPanel = new JSplitPane(1, taskPane, (Component)this.m_taskConsole);
        contentBottomPanel.setDividerLocation(700);
        JSplitPane mainPanel = new JSplitPane(0);
        mainPanel.setTopComponent(upPane);
        mainPanel.setBottomComponent(contentBottomPanel);
        mainPanel.setDividerLocation(280);
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
        this.add(this.initToolbar(), "West");
        this.m_taskFlowFrame.setLocation(700, 300);
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)((ServerLogTaskListView)this.m_taskQueueView).getCompoundTableModel()){

            protected void filteringDone() {
            }
        };
        toolbar.add((Component)filterButton);
        JButton showTaskFlowBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LIST));
        showTaskFlowBt.setToolTipText("Show task flow");
        showTaskFlowBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLogControlPanel.this.m_taskFlowFrame.setVisible(true);
            }
        });
        toolbar.add(showTaskFlowBt);
        ServerLogTaskListView taskListPane = (ServerLogTaskListView)this.m_taskQueueView;
        ExportButton exportButton = new ExportButton((ProgressInterface)taskListPane.getCompoundTableModel(), "Tasks", (JXTable)taskListPane.getTable());
        toolbar.add((Component)exportButton);
        JButton infoButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INFORMATION));
        infoButton.setToolTipText("Get Log File information");
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemInfoDialog m_infoDialog = SystemInfoDialog.getDialog(WindowManager.getDefault().getMainWindow());
                m_infoDialog.updateInfo(ServerLogControlPanel.this.getInfo());
                m_infoDialog.setTitle("Log File Information ");
                m_infoDialog.setVisible(true);
            }
        });
        toolbar.add(infoButton);
        return toolbar;
    }

    public void saveParameters() {
        Preferences preferences = NbPreferences.root();
        preferences.put(KEY_LOG_DATE_FORMAT, this.m_dateFormat.name());
    }

    public void initParameters() {
        Preferences preferences = NbPreferences.root();
        String format = preferences.get(KEY_LOG_DATE_FORMAT, "SHORT");
        this.m_dateFormat = format.equals(Utility.DATE_FORMAT.SHORT.name()) ? Utility.DATE_FORMAT.SHORT : Utility.DATE_FORMAT.NORMAL;
    }

    private void parseFile() {
        try {
            String fileName = this.m_fileList.get(0).getName();
            m_logger.info("File to analyse: " + fileName + ".");
            this.m_logReader = new LogLineReader(fileName, this.m_dateFormat, this.isBigFile(), false);
            this.m_readWorker = new LogReaderWorker((LogControlPanel)this, this.m_taskFlowTextPane, this.m_fileList, this.m_dateFormat, this.m_logReader);
            this.m_taskFlowFrame.setVisible(true);
            this.m_readWorker.execute();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), ex + "\n" + ex.getStackTrace()[0], "Exception", 0);
            StackTraceElement[] trace = ex.getStackTrace();
            String result = "";
            for (StackTraceElement el : trace) {
                result = result + el.toString() + "\n";
            }
            m_logger.error(ex + "\n" + result);
        }
    }

    public boolean isBigFile() {
        long size = 0L;
        for (File file : this.m_fileList) {
            size += file.length();
        }
        return size > (long)this.BIG_FILE_SIZE;
    }

    public int getMaxLine2Show() {
        return MAX_LINE_TO_SHOW;
    }

    public void redo() {
        this.m_dateFormat = this.m_dateFormat.equals((Object)Utility.DATE_FORMAT.NORMAL) ? Utility.DATE_FORMAT.SHORT : Utility.DATE_FORMAT.NORMAL;
        this.saveParameters();
        this.parseFile();
    }

    public void setProgressBarVisible(boolean visible) {
        this.m_progressBar.setVisible(visible);
        this.m_taskFlowFrame.setVisible(visible);
    }

    public void setProgress(int percent) {
        this.m_progressBar.setValue(percent);
    }

    public String getInfo() {
        String result = "";
        for (File f : this.m_fileList) {
            result = result + f.getName() + "\n";
        }
        result = result + ((ServerLogTaskListView)this.m_taskQueueView).getInfo();
        return result;
    }
}

