/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.logparser.gui.TaskListInterface;
import fr.proline.logparser.model.LogTask;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.rsmexplorer.gui.tasklog.ServerLogControlPanel;
import fr.proline.studio.rsmexplorer.gui.tasklog.ServerLogTaskTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLogTaskListView
extends JScrollPane
implements TaskListInterface {
    protected static final Logger m_logger = LoggerFactory.getLogger(ServerLogTaskListView.class);
    private ServerLogControlPanel m_ctrl;
    private ArrayList<LogTask> m_taskList;
    private ServerLogTaskTable m_table;
    private ServerLogTaskTableModel m_tableModel;
    private CompoundTableModel m_CompoundTableModel;

    ServerLogTaskListView(ServerLogControlPanel control) {
        this.m_ctrl = control;
        this.setBorder(BorderFactory.createTitledBorder("List of Task"));
        this.setPreferredSize(new Dimension(1400, 250));
        this.m_taskList = new ArrayList();
        this.m_tableModel = new ServerLogTaskTableModel();
        this.m_CompoundTableModel = new CompoundTableModel((GlobalTableModelInterface)this.m_tableModel, true);
        this.m_table = new ServerLogTaskTable();
        this.m_table.setModel((TableModel)this.m_CompoundTableModel);
        this.m_table.init();
        this.setViewportView((Component)((Object)this.m_table));
        this.m_table.setFillsViewportHeight(true);
    }

    public CompoundTableModel getCompoundTableModel() {
        return this.m_CompoundTableModel;
    }

    public ServerLogTaskTable getTable() {
        return this.m_table;
    }

    public void setData(ArrayList<LogTask> tasks, String fileName) {
        if (tasks != null) {
            m_logger.debug("setData {} tasks for {}", (Object)tasks.size(), (Object)fileName);
        } else {
            m_logger.debug("setData null {} tasks for {}", tasks, (Object)fileName);
        }
        ((TitledBorder)this.getBorder()).setTitle("List of Tasks     " + fileName);
        if (tasks == null || tasks.isEmpty()) {
            this.m_taskList = new ArrayList();
        } else {
            this.m_taskList = tasks;
            this.m_tableModel.setData(this.m_taskList);
            this.m_table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.initColumnsize();
    }

    private void initColumnsize() {
        String[] example = new String[]{"198", "853bda4a-10d9-11e8-9a85-d9411af38406", "[pool-2-thread-25]", "proline/dps/msi/ImportValidateGenerateSM", " result_files :  mascot_data/20200113/F136424.dat ", "FINISHED_W", "104", "09:01:27.985 - 09 oct. 2019 ", "09:01:27.985 - 09 oct. 2019 ", "111:59:59.999", "+10                     "};
        for (int i = 0; i < this.m_table.getColumnCount(); ++i) {
            TableColumn column = this.m_table.getColumnModel().getColumn(i);
            int modelIndex = this.m_table.convertColumnIndexToModel(i);
            TableCellRenderer renderer = this.m_table.getDefaultRenderer(column.getClass());
            Component comp = renderer.getTableCellRendererComponent((JTable)((Object)this.m_table), example[modelIndex], false, false, 0, i);
            int cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(cellWidth);
        }
    }

    public String getInfo() {
        int count = this.m_tableModel.getRowCount();
        return count <= 1 ? count + " task." : count + " tasks.";
    }

    class ServerLogTaskTable
    extends DecoratedMarkerTable
    implements ExportModelInterface {
        public void init() {
            this.setColumnsVisibility();
        }

        private void setColumnsVisibility() {
            TableColumnExt columnExt = ServerLogTaskListView.this.m_table.getColumnExt(ServerLogTaskListView.this.m_table.convertColumnIndexToView(1));
            if (columnExt != null) {
                columnExt.setVisible(false);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int sortedIndex = lsm.getMinSelectionIndex();
                int selectedIndex = ServerLogTaskListView.this.m_table.convertRowIndexToModel(sortedIndex);
                LogTask task = (LogTask)ServerLogTaskListView.this.m_taskList.get(selectedIndex);
                String taskOrder = task == null ? "" : "" + task.getTaskOrder();
                ServerLogTaskListView.this.m_ctrl.valueChanged(task);
            } else {
                ServerLogTaskListView.this.m_ctrl.valueChanged(null);
            }
        }

        public String getExportColumnName(int col) {
            return ServerLogTaskListView.this.m_tableModel.getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ServerLogTaskListView.this.m_tableModel.getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ServerLogTaskListView.this.m_tableModel.getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }
    }
}

