/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.profi.util.StringUtils;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.CancelTask;
import fr.proline.studio.dpm.task.jms.PurgeConsumer;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.filter.ValueFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.dialog.GetSystemInfoButtonAction;
import fr.proline.studio.rsmexplorer.gui.renderer.PercentageRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.tasklog.AbstractTasksPanel;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.openide.windows.WindowManager;

public class TasksPanel
extends AbstractTasksPanel {
    private LogTable m_logTable;
    private boolean m_firstDisplay = true;

    public TasksPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(this.createToolbarPanel(), c);
    }

    @Override
    protected AbstractJMSCallback getServiceNotificationCallback(final JMSNotificationMessage[] sysInfoResult) {
        AbstractJMSCallback notifierCallback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                TaskInfo tiToUpdate;
                if (sysInfoResult[0].getEventType().equals((Object)JMSNotificationMessage.MessageStatus.STARTED) && (tiToUpdate = TaskInfoManager.getTaskInfoManager().getTaskInfoWithJMSId(sysInfoResult[0].getServerUniqueMsgId())) != null) {
                    tiToUpdate.setRunning(true);
                }
            }
        };
        return notifierCallback;
    }

    @Override
    protected AbstractJMSCallback getPurgeConsumerCallback(JMSNotificationMessage[] purgerResult) {
        return null;
    }

    @Override
    protected void startOtherDataCollecting() {
    }

    @Override
    protected void stopOtherDataCollecting() {
    }

    private JPanel createToolbarPanel() {
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        toolbarPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        toolbarPanel.add((Component)toolbar, "West");
        return toolbarPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JScrollPane scrollPane = new JScrollPane();
        this.m_logTable = new LogTable();
        this.m_logTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new LogTableModel(), true));
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.m_logTable.getModel());
        this.m_logTable.setRowSorter(sorter);
        sorter.setComparator(3, new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                int cmp = o2.getImportance() - o1.getImportance();
                if (cmp != 0) {
                    return cmp;
                }
                return o2.getId() - o1.getId();
            }
        });
        TableColumnModel columnModel = this.m_logTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new TaskInfoStepRenderer());
        columnModel.getColumn(3).setCellRenderer(new TaskInfoImportanceRenderer());
        DefaultErrorRenderer defaultErrorRenderer = new DefaultErrorRenderer((TableCellRenderer)new DefaultTableRenderer(), this.m_logTable);
        columnModel.getColumn(1).setCellRenderer(defaultErrorRenderer);
        columnModel.getColumn(2).setCellRenderer(defaultErrorRenderer);
        columnModel.getColumn(4).setCellRenderer(defaultErrorRenderer);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(1).setMaxWidth(40);
        columnModel.getColumn(2).setMaxWidth(180);
        scrollPane.setViewportView((Component)((Object)this.m_logTable));
        this.m_logTable.setFillsViewportHeight(true);
        this.m_logTable.setViewport(scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)scrollPane, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_logTable.getModel())){

            protected void filteringDone() {
            }
        };
        EraserButton taskEraserButton = new EraserButton();
        GetSystemInfoButtonAction systemInfoButton = new GetSystemInfoButtonAction();
        toolbar.add((Component)filterButton);
        toolbar.add(taskEraserButton);
        toolbar.add(systemInfoButton);
        return toolbar;
    }

    public void updateData() {
        boolean aSelection;
        if (!this.m_firstDisplay && !TaskInfoManager.getTaskInfoManager().isUpdateNeeded()) {
            return;
        }
        this.m_firstDisplay = false;
        this.m_logTable.setUpdating(true);
        LogTableModel tableModel = (LogTableModel)((CompoundTableModel)this.m_logTable.getModel()).getBaseModel();
        int selectedTaskInfoId = -1;
        int selectedIndex = this.m_logTable.getSelectionModel().getMinSelectionIndex();
        boolean bl = aSelection = selectedIndex != -1;
        if (aSelection) {
            selectedIndex = this.m_logTable.convertRowIndexToModel(selectedIndex);
            selectedTaskInfoId = tableModel.getTaskInfo(selectedIndex).getId();
        }
        tableModel.updateData();
        int n = selectedIndex = selectedTaskInfoId == -1 ? -1 : tableModel.findIndexOfTaskInfoById(selectedTaskInfoId);
        if (selectedIndex != -1) {
            selectedIndex = this.m_logTable.convertRowIndexToView(selectedIndex);
            this.m_logTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            this.m_logTable.setUpdating(false);
            this.getDataBox().addDataChanged(TaskInfo.class);
            this.getDataBox().propagateDataChanged();
        } else if (aSelection) {
            this.m_logTable.setUpdating(false);
            this.m_logTable.getSelectionModel().clearSelection();
            this.getDataBox().addDataChanged(TaskInfo.class);
            this.getDataBox().propagateDataChanged();
        } else {
            this.m_logTable.setUpdating(false);
        }
    }

    public TaskInfo getSelectedTaskInfo() {
        int selectedRow = this.m_logTable.getSelectedRow();
        return this.m_logTable.getTaskInfo(selectedRow);
    }

    private class StopTaskAction
    extends AbstractTableAction {
        public StopTaskAction() {
            super("Cancel task...");
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            int nbSelectedRset = selectedRows.length;
            if (nbSelectedRset != 1) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Only one task can be aborted at the same time", "Cancel Task Error", 0);
                return;
            }
            TaskInfo currentTaskInfo = TasksPanel.this.getSelectedTaskInfo();
            if (StringUtils.isEmpty((String)currentTaskInfo.getJmsMessageID())) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Only server side tasks can be aborted", "Cancel Task Error", 0);
                return;
            }
            if (currentTaskInfo.getPublicState() == TaskInfo.PUBLIC_STATE_RUNNING.intValue()) {
                CancelTask task = new CancelTask(currentTaskInfo.getJmsMessageID());
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            } else if (currentTaskInfo.getPublicState() == TaskInfo.PUBLIC_STATE_WAITING.intValue()) {
                PurgeConsumer.getPurgeConsumer().clearMessage(currentTaskInfo.getJmsMessageID());
            } else {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Only pending or running task can be aborted", "Cancel Task Error", 0);
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            boolean enable = true;
            if (selectedRows.length != 1) {
                enable = false;
            } else {
                TaskInfo currentTaskInfo = TasksPanel.this.getSelectedTaskInfo();
                int currentPublicState = currentTaskInfo.getPublicState();
                if (currentPublicState != TaskInfo.PUBLIC_STATE_WAITING && currentPublicState != TaskInfo.PUBLIC_STATE_RUNNING) {
                    enable = false;
                }
            }
            this.setEnabled(enable);
        }
    }

    public class EraserButton
    extends JButton
    implements ActionListener {
        public EraserButton() {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
            this.setToolTipText("Erase All Finished Tasks");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskInfoManager.getTaskInfoManager().clear();
            TasksPanel.this.m_firstDisplay = true;
            TasksPanel.this.updateData();
        }
    }

    public class DefaultErrorRenderer
    implements TableCellRenderer,
    Serializable {
        private final TableCellRenderer m_renderer;
        private final LogTable m_table;

        public DefaultErrorRenderer(TableCellRenderer renderer, LogTable table) {
            this.m_renderer = renderer;
            this.m_table = table;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.m_renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalAlignment(2);
                TaskInfo taskInfo = this.m_table.getTaskInfo(row);
                if (taskInfo.hasTaskError()) {
                    l.setForeground(Color.red);
                } else if (isSelected) {
                    l.setForeground(Color.white);
                } else {
                    l.setForeground(Color.black);
                }
            }
            return c;
        }
    }

    public class TaskInfoImportanceRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            TaskInfo task = (TaskInfo)value;
            this.setText(task.getImportanceAsString());
            return this;
        }
    }

    public class TaskInfoStepRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            TaskInfo task = (TaskInfo)value;
            this.setIcon(AbstractTasksPanel.PUBLIC_STATE_ICONS[task.getPublicState()]);
            return this;
        }
    }

    private static class LogTableModel
    extends DecoratedTableModel
    implements GlobalTableModelInterface {
        public static final int COLTYPE_STEP = 0;
        public static final int COLTYPE_TASKINFO_ID = 1;
        public static final int COLTYPE_TASKINFO_CATEGORY = 2;
        public static final int COLTYPE_TASKINFO_CRITICALITY = 3;
        public static final int COLTYPE_DESCRIPTION = 4;
        public static final int COLTYPE_PERCENTAGE = 5;
        private static final String[] columnNames = new String[]{"", "id", "Category", "Criticality", "Task Description", "Progress"};
        private ArrayList<TaskInfo> m_taskInfoList = null;

        private LogTableModel() {
        }

        public boolean updateData() {
            boolean updateDone;
            if (this.m_taskInfoList == null) {
                this.m_taskInfoList = new ArrayList(128);
            }
            if (updateDone = TaskInfoManager.getTaskInfoManager().copyData(this.m_taskInfoList, false)) {
                this.fireTableDataChanged();
            }
            return updateDone;
        }

        public TaskInfo getTaskInfo(int index) {
            if (this.m_taskInfoList == null || index >= this.m_taskInfoList.size() || index < 0) {
                return null;
            }
            return this.m_taskInfoList.get(index);
        }

        public int findIndexOfTaskInfoById(int taskInfoId) {
            if (taskInfoId == -1) {
                return -1;
            }
            for (int i = 0; i < this.m_taskInfoList.size(); ++i) {
                if (this.m_taskInfoList.get(i).getId() != taskInfoId) continue;
                return i;
            }
            return -1;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 3: {
                    return TaskInfo.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: 
                case 4: {
                    return String.class;
                }
                case 5: {
                    return Float.class;
                }
            }
            return null;
        }

        public int getRowCount() {
            if (this.m_taskInfoList == null) {
                return 0;
            }
            return this.m_taskInfoList.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            TaskInfo taskInfo = this.m_taskInfoList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return taskInfo;
                }
                case 1: {
                    return taskInfo.getId();
                }
                case 2: {
                    return taskInfo.getIdList();
                }
                case 3: {
                    return taskInfo;
                }
                case 4: {
                    return taskInfo.getTaskDescription();
                }
                case 5: {
                    if (taskInfo.isRunning()) {
                        float percentage = taskInfo.getPercentage();
                        if ((double)percentage < 0.001 || (double)percentage > 99.999) {
                            return Float.valueOf(Float.NaN);
                        }
                        return Float.valueOf(percentage);
                    }
                    return Float.valueOf(Float.NaN);
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return null;
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
            ConvertValueInterface stepConverter = new ConvertValueInterface(){

                public Object convertValue(Object o) {
                    if (o == null) {
                        return null;
                    }
                    return ((TaskInfo)o).getPublicState();
                }
            };
            filtersMap.put(0, (Filter)new ValueFilter("State", (Object[])TaskInfo.PUBLIC_STATE_VALUES, AbstractTasksPanel.PUBLIC_STATE_ICONS, ValueFilter.ValueFilterType.EQUAL, stepConverter, 0));
            filtersMap.put(1, (Filter)new IntegerFilter(this.getColumnName(1), null, 1));
            ConvertValueInterface criticalityConverter = new ConvertValueInterface(){

                public Object convertValue(Object o) {
                    if (o == null) {
                        return null;
                    }
                    return ((TaskInfo)o).getImportance();
                }
            };
            filtersMap.put(3, (Filter)new ValueFilter(this.getColumnName(3), (Object[])TaskInfo.IMPORTANCE_VALUES, null, ValueFilter.ValueFilterType.GREATER_EQUAL, criticalityConverter, 3));
            filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), null, 4));
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }

        public Long getTaskId() {
            return -1L;
        }

        public LazyData getLazyData(int row, int col) {
            return null;
        }

        public void givePriorityTo(Long taskId, int row, int col) {
        }

        public void sortingChanged(int col) {
        }

        public int getSubTaskId(int col) {
            return -1;
        }

        public String getDataColumnIdentifier(int columnIndex) {
            return null;
        }

        public Class getDataColumnClass(int columnIndex) {
            return null;
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            return null;
        }

        public int[] getKeysColumn() {
            return null;
        }

        public int getInfoColumn() {
            return -1;
        }

        public void setName(String name) {
        }

        public String getName() {
            return null;
        }

        public Map<String, Object> getExternalData() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public PlotInformation getPlotInformation() {
            return null;
        }

        public PlotType getBestPlotType() {
            return null;
        }

        public int[] getBestColIndex(PlotType plotType) {
            return null;
        }

        public String getExportRowCell(int row, int col) {
            return null;
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return null;
        }

        public String getExportColumnName(int col) {
            return this.getColumnName(col);
        }

        public TableCellRenderer getRenderer(int row, int col) {
            if (col == 5) {
                return new ScoreRenderer();
            }
            return null;
        }

        public GlobalTableModelInterface getFrozzenModel() {
            return this;
        }

        public ArrayList<ExtraDataType> getExtraDataTypes() {
            ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
            list.add(new ExtraDataType(TaskInfo.class, true));
            this.registerSingleValuesAsExtraTypes(list);
            return list;
        }

        public Object getValue(Class c) {
            return this.getSingleValue(c);
        }

        public Object getRowValue(Class c, int row) {
            if (c.equals(TaskInfo.class)) {
                return this.m_taskInfoList.get(row);
            }
            return null;
        }

        public Object getColValue(Class c, int col) {
            return null;
        }
    }

    private class LogTable
    extends DecoratedMarkerTable {
        private boolean m_isUpdating = false;

        public LogTable() {
            this.setSelectionMode(0);
            this.setAutoResizeMode(3);
            this.setDefaultRenderer(Float.class, new PercentageRenderer(this.getDefaultRenderer(String.class)));
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!this.m_isUpdating) {
                TasksPanel.this.getDataBox().addDataChanged(TaskInfo.class);
                TasksPanel.this.getDataBox().propagateDataChanged();
            }
        }

        public void setUpdating(boolean updating) {
            this.m_isUpdating = updating;
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu(false);
            popupMenu.addAction((AbstractTableAction)new StopTaskAction());
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        private TaskInfo getTaskInfo(int row) {
            if (row == -1) {
                return null;
            }
            row = this.convertRowIndexToModel(row);
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            row = compoundTableModel.convertCompoundRowToBaseModelRow(row);
            LogTableModel tableModel = (LogTableModel)compoundTableModel.getBaseModel();
            return tableModel.getTaskInfo(row);
        }
    }
}

