/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MapTime;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimeTableModel;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTimePanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private AbstractDataBox m_dataBox;
    private JScrollPane m_timeScrollPane;
    private MapAlignmentTable m_timeTable;
    private MarkerContainerPanel m_markerContainerPanel;

    public MapTimePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel expDesignPanel = this.createMapAlignmentPanel();
        this.add(expDesignPanel, "Center");
    }

    private JPanel createMapAlignmentPanel() {
        JPanel mapAlignmentPanel = new JPanel();
        mapAlignmentPanel.setBounds(0, 0, 500, 400);
        mapAlignmentPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        mapAlignmentPanel.add((Component)toolbar, "West");
        mapAlignmentPanel.add((Component)internalPanel, "Center");
        return mapAlignmentPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_timeScrollPane = new JScrollPane();
        this.m_timeTable = new MapAlignmentTable();
        this.m_timeTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new MapTimeTableModel(this.m_timeTable), true));
        this.m_timeTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_timeScrollPane, (MarkerComponentInterface)this.m_timeTable);
        this.m_timeScrollPane.setViewportView((Component)((Object)this.m_timeTable));
        this.m_timeTable.setFillsViewportHeight(true);
        this.m_timeTable.setViewport(this.m_timeScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void setData(Long taskId, MapAlignment mapAlignment, List<MapTime> mapTimes, Color color, String title, boolean finished, String fromMapName) {
        this.setData(taskId, mapAlignment, mapTimes, color, title, finished, fromMapName, "");
    }

    public void setData(Long taskId, MapAlignment mapAlignment, List<MapTime> mapTimes, Color color, String title, boolean finished, String fromMapName, String toMapName) {
        ((MapTimeTableModel)((CompoundTableModel)this.m_timeTable.getModel()).getBaseModel()).setData(taskId, mapAlignment, mapTimes, color, title, fromMapName, toMapName);
        if (mapTimes != null && mapTimes.size() > 0) {
            this.m_timeTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(mapTimes.size());
        }
        if (finished) {
            this.m_timeTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.updateData();
    }

    private void updateData() {
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_timeTable;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_timeTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_timeTable;
    }

    private class MapAlignmentTable
    extends LazyTable {
        private boolean selectionWillBeRestored;

        public MapAlignmentTable() {
            super(MapTimePanel.this.m_timeScrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (MapTimePanel.this.m_dataBox != null) {
                MapTimePanel.this.m_dataBox.addDataChanged(MapAlignment.class);
                MapTimePanel.this.m_dataBox.propagateDataChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((MapTimeTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return MapTimePanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return MapTimePanel.this.m_dataBox.isLoaded();
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

