/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MapTime;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.TimeRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class MapTimeTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_TIME = 0;
    public static final int COLTYPE_DELTA_TIME = 1;
    private String[] m_columnNames;
    private static final String[] m_toolTipColumns = new String[]{"Time (min)", "Delta time (s)"};
    private MapAlignment m_mapAlignment;
    private List<MapTime> m_mapTimes = null;
    private Color m_color = null;
    private String m_title = null;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private String m_modelName;

    public MapTimeTableModel(LazyTable table) {
        super(table);
        this.m_columnNames = new String[]{"Time in Reference Map (min)", "Delta time (s)"};
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public int getRowCount() {
        return this.m_mapTimes == null ? 0 : this.m_mapTimes.size();
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int col) {
        return this.m_columnNames[col];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        MapTime mapTime = this.m_mapTimes.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                lazyData.setData((Comparable)mapTime.getTime());
                return lazyData;
            }
            case 1: {
                LazyData lazyData = this.getLazyData(rowIndex, columnIndex);
                lazyData.setData((Comparable)mapTime.getDeltaTime());
                return lazyData;
            }
        }
        return null;
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TimeRenderer renderer = null;
        switch (col) {
            case 0: {
                renderer = new TimeRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 1: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return Double.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        MapTime mapTime = this.m_mapTimes.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mapTime.getTime() / 60.0;
            }
            case 1: {
                return mapTime.getDeltaTime();
            }
        }
        return null;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 0;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotColor(this.m_color);
        plotInformation.setPlotTitle(this.m_title);
        plotInformation.setDrawPoints(false);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(0, (Filter)new DoubleFilter(this.getColumnName(0), null, 0));
        filtersMap.put(1, (Filter)new DoubleFilter(this.getColumnName(1), null, 1));
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public PlotType getBestPlotType() {
        return PlotType.LINEAR_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case LINEAR_PLOT: {
                int[] cols = new int[]{0, 1};
                return cols;
            }
        }
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return null;
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.m_columnNames[col];
    }

    public void setData(Long taskId, MapAlignment mapAlignment, List<MapTime> mapTimes, Color color, String title) {
        this.setData(taskId, mapAlignment, mapTimes, color, title, "(Reference map)", "");
    }

    public void setData(Long taskId, MapAlignment mapAlignment, List<MapTime> mapTimes, Color color, String title, String fromMapName) {
        this.setData(taskId, mapAlignment, mapTimes, color, title, fromMapName, "");
    }

    public void setData(Long taskId, MapAlignment mapAlignment, List<MapTime> mapTimes, Color color, String title, String fromMapName, String toMapName) {
        this.m_mapAlignment = mapAlignment;
        this.m_mapTimes = mapTimes;
        this.m_color = color;
        this.m_title = title;
        this.m_taskId = taskId;
        this.m_columnNames[0] = "Time in Map " + fromMapName + " (min)";
        this.m_columnNames[1] = "Delta time in Map " + toMapName + " (s)";
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(MapTime.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(MapTime.class)) {
            return this.m_mapTimes.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

