/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.Peak;
import fr.proline.core.orm.lcms.Peakel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.DataFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PeakTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEAK_MOZ = 0;
    public static final int COLTYPE_PEAK_RETENTION_TIME = 1;
    public static final int COLTYPE_PEAK_INTENSITY = 2;
    private static final String[] m_columnNames = new String[]{"m/z", "RT", "Intensity"};
    private static final String[] m_toolTipColumns = new String[]{"Mass to Charge Ratio", "Retention Time in minutes", "Intensity"};
    private Feature m_feature = null;
    private Peakel m_peakel;
    private List<Peak> m_peaks = null;
    private Color m_color = null;
    private boolean m_dashed = false;
    private String m_title = null;
    private Integer m_isotopeIndex = null;
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public PeakTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public int getRowCount() {
        if (this.m_peaks == null) {
            return 0;
        }
        return this.m_peaks.size();
    }

    public Object getValueAt(int row, int col) {
        Peak peak = this.m_peaks.get(row);
        switch (col) {
            case 0: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)peak.getMoz());
                return lazyData;
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)peak.getElutionTime());
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                lazyData.setData((Comparable)peak.getIntensity());
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, Feature feature, Peakel peakel, Integer isotopeIndex, List<Peak> peaks, Color color, boolean dashed, String title) {
        this.m_peaks = peaks;
        this.m_feature = feature;
        this.m_peakel = peakel;
        this.m_isotopeIndex = isotopeIndex;
        this.m_color = color;
        this.m_dashed = dashed;
        this.m_title = title;
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public Peak getPeak(int i) {
        return this.m_peaks.get(i);
    }

    public int findRow(float elutionTime) {
        int nb = this.m_peaks.size();
        for (int i = 0; i < nb; ++i) {
            if (elutionTime != this.m_peaks.get(i).getElutionTime().floatValue()) continue;
            return i;
        }
        return -1;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(0, (Filter)new DoubleFilter(this.getColumnName(0), null, 0));
        filtersMap.put(1, (Filter)new DoubleFilter(this.getColumnName(1), null, 1));
        filtersMap.put(2, (Filter)new DoubleFilter(this.getColumnName(2), null, 2));
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 1: 
            case 2: {
                return Float.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Peak peak = this.m_peaks.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return peak.getMoz();
            }
            case 1: {
                return Float.valueOf(peak.getElutionTime().floatValue() / 60.0f);
            }
            case 2: {
                return peak.getIntensity();
            }
        }
        return null;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{1};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public PlotType getBestPlotType() {
        return PlotType.LINEAR_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{2, 2};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{1, 2};
                return cols;
            }
            case LINEAR_PLOT: {
                int[] cols = new int[]{1, 2};
                return cols;
            }
        }
        return null;
    }

    public int getInfoColumn() {
        return 1;
    }

    public Map<String, Object> getExternalData() {
        HashMap<String, Object> externalData = new HashMap<String, Object>();
        ArrayList<Double> scanValues = new ArrayList<Double>();
        ArrayList<String> scanText = new ArrayList<String>();
        ArrayList<Color> scanColor = new ArrayList<Color>();
        if (this.m_feature != null) {
            if (this.m_feature.getFirstScan() != null) {
                scanValues.add(new Double(this.m_feature.getFirstScan().getTime() / 60.0f));
                scanText.add(" Time: ");
                scanColor.add(this.m_color);
            }
            if (this.m_feature.getLastScan() != null) {
                scanValues.add(new Double(this.m_feature.getLastScan().getTime() / 60.0f));
                scanText.add(" Time: ");
                scanColor.add(this.m_color);
            }
        } else if (this.m_peakel != null) {
            if (this.m_peakel.getFirstScan() != null) {
                scanValues.add(new Double(this.m_peakel.getFirstScan().getTime() / 60.0f));
                scanText.add(" Time: ");
                scanColor.add(this.m_color);
            }
            if (this.m_peakel.getLastScan() != null) {
                scanValues.add(new Double(this.m_peakel.getLastScan().getTime() / 60.0f));
                scanText.add(" Time: ");
                scanColor.add(this.m_color);
            }
        }
        externalData.put("VERTICAL_MARKER_VALUE", scanValues);
        externalData.put("VERTICAL_MARKER_TEXT", scanText);
        externalData.put("VERTICAL_MARKER_COLOR", scanColor);
        return externalData;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotColor(this.m_color);
        plotInformation.setDashed(this.m_dashed);
        plotInformation.setPlotTitle(this.m_title);
        plotInformation.setDrawPoints(false);
        plotInformation.setDrawGap(true);
        HashMap<String, String> plotInfo = new HashMap<String, String>();
        if (this.m_peakel != null) {
            plotInfo.put("Apex Int.", DataFormat.formatWithGroupingSep((Number)Float.valueOf(this.m_peakel.getApexIntensity()), (int)0));
            plotInfo.put("Isotope index", Integer.toString(this.m_isotopeIndex));
        }
        plotInformation.setPlotInfo(plotInfo);
        return plotInformation;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        Object renderer = null;
        switch (col) {
            case 0: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
                break;
            }
            case 1: 
            case 2: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)));
            }
        }
        this.m_rendererMap.put(col, (TableCellRenderer)renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(Peak.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(Peak.class)) {
            return this.m_peaks.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

