/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabaseRsetProperties;
import fr.proline.studio.dam.tasks.DatabaseRsummaryProperties;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.utils.IconManager;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.openide.nodes.Sheet;

public class DataSetNode
extends AbstractNode {
    private boolean m_isReference = false;
    private boolean m_isRefined = false;
    boolean m_isBioSequenceRetrived = false;

    public DataSetNode(AbstractNode.NodeTypes type, AbstractData data) {
        super(type, data);
    }

    public DataSetNode(AbstractData data) {
        super(AbstractNode.NodeTypes.DATA_SET, data);
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        DDataset dataset = ((DataSetData)this.getData()).getDataset();
        DDatasetType datasetType = ((DataSetData)this.getData()).getDatasetType();
        if (datasetType.isTrash()) {
            return this.getIcon(IconManager.IconType.TRASH);
        }
        if (datasetType.isFolder()) {
            if (expanded) {
                return this.getIcon(IconManager.IconType.FOLDER_EXPANDED);
            }
            return this.getIcon(IconManager.IconType.FOLDER);
        }
        if (datasetType.isIdentification()) {
            if (datasetType.isAggregation()) {
                if (dataset != null) {
                    boolean rsmDefined = dataset.getResultSummaryId() != null;
                    DDatasetType.AggregationInformation mergeInfo = ((DataSetData)this.getData()).getDataset().getAggregationInformation();
                    switch (mergeInfo) {
                        case IDENTIFICATION_SUMMARY_AGG: {
                            return this.getIcon(IconManager.IconType.DATASET_RSM_MERGED_AGG);
                        }
                        case IDENTIFICATION_SUMMARY_UNION: {
                            return this.getIcon(IconManager.IconType.DATASET_RSM_MERGED_UNION);
                        }
                        case SEARCH_RESULT_AGG: {
                            if (rsmDefined) {
                                return this.getIcon(IconManager.IconType.DATASET_RSM_RSET_MERGED_AGG);
                            }
                            return this.getIcon(IconManager.IconType.DATASET_RSET_MERGED_AGG);
                        }
                        case SEARCH_RESULT_UNION: {
                            if (rsmDefined) {
                                return this.getIcon(IconManager.IconType.DATASET_RSM_RSET_MERGED_UNION);
                            }
                            return this.getIcon(IconManager.IconType.DATASET_RSET_MERGED_UNION);
                        }
                        case UNKNOWN: {
                            return this.getIcon(IconManager.IconType.DATASET);
                        }
                    }
                }
                return this.getIcon(IconManager.IconType.DATASET);
            }
            if (dataset != null) {
                if (dataset.getResultSummaryId() == null) {
                    if (this.isChanging()) {
                        return this.getIcon(IconManager.IconType.DATASET_RSM);
                    }
                    return this.getIcon(IconManager.IconType.DATASET_RSET);
                }
                return this.getIcon(IconManager.IconType.DATASET_RSM);
            }
            return this.getIcon(IconManager.IconType.DATASET_RSET);
        }
        if (datasetType.isQuantitation()) {
            if (dataset == null || datasetType.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.NONE) {
                return this.getIcon(IconManager.IconType.QUANT_XIC);
            }
            if (dataset.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION) {
                if (datasetType.isAggregation()) {
                    return this.getIcon(IconManager.IconType.QUANT_AGGREGATION_XIC);
                }
                return this.getIcon(IconManager.IconType.QUANT_XIC);
            }
            if (dataset.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING) {
                return this.getIcon(IconManager.IconType.QUANT_SC);
            }
            return this.getIcon(IconManager.IconType.QUANT);
        }
        return this.getIcon(IconManager.IconType.QUANT);
    }

    @Override
    public ImageIcon getIcon(IconManager.IconType iconType) {
        if (this.m_isReference) {
            return IconManager.getGrayedIcon((IconManager.IconType)iconType);
        }
        return super.getIcon(iconType);
    }

    public boolean isMerged() {
        DDataset dataset;
        DDatasetType datasetType = ((DataSetData)this.getData()).getDatasetType();
        return datasetType.isIdentification() && datasetType.isAggregation() ? (dataset = ((DataSetData)this.getData()).getDataset()) != null && (dataset.getResultSummaryId() != null || dataset.getResultSetId() != null) : datasetType.isQuantitation();
    }

    public boolean isBioRetrived() {
        return this.m_isBioSequenceRetrived;
    }

    public void setBioRetrived(boolean b) {
        this.m_isBioSequenceRetrived = b;
    }

    public DDataset getDataset() {
        return ((DataSetData)this.getData()).getDataset();
    }

    public void setDataset(DDataset dataset) {
        ((DataSetData)this.getData()).setDataset(dataset);
    }

    public boolean isTrash() {
        DDataset dataset = ((DataSetData)this.getData()).getDataset();
        if (dataset == null) {
            return false;
        }
        DDatasetType datasetType = ((DataSetData)this.getData()).getDatasetType();
        return datasetType.isTrash();
    }

    public boolean isFolder() {
        DDataset dataset = ((DataSetData)this.getData()).getDataset();
        if (dataset == null) {
            return false;
        }
        DDatasetType datasetType = ((DataSetData)this.getData()).getDatasetType();
        return datasetType.isFolder();
    }

    public boolean hasResultSummary() {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        return dataSet != null && dataSet.getResultSummaryId() != null;
    }

    public Long getResultSummaryId() {
        return ((DataSetData)this.getData()).getDataset().getResultSummaryId();
    }

    public ResultSummary getResultSummary() {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        return dataSet.getResultSummary();
    }

    public boolean hasResultSet() {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        return dataSet != null && (dataSet.getResultSetId() != null || dataSet.isQuantitation());
    }

    public Long getResultSetId() {
        return ((DataSetData)this.getData()).getDataset().getResultSetId();
    }

    public ResultSet getResultSet() {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        if (dataSet.getResultSet() == null) {
            DataSetData.fetchRsetAndRsmForOneDataset((DDataset)dataSet);
        }
        return dataSet.getResultSet();
    }

    @Override
    public boolean isInTrash() {
        if (this.isTrash()) {
            return true;
        }
        return ((AbstractNode)this.getParent()).isInTrash();
    }

    @Override
    public String toString() {
        if (this.isTrash()) {
            return "Trash";
        }
        return super.toString();
    }

    @Override
    public boolean canBeDeleted() {
        if (this.isChanging()) {
            return false;
        }
        if (this.isInTrash()) {
            return false;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            AbstractNode child = (AbstractNode)e.nextElement();
            if (child.canBeDeleted()) continue;
            return false;
        }
        return true;
    }

    public void rename(final String newName, final AbstractTree tree) {
        DDataset dataset = this.getDataset();
        String name = dataset.getName();
        if (newName != null && newName.compareTo(name) != 0 && !newName.trim().isEmpty()) {
            final DataSetNode datasetNode = this;
            this.setIsChanging(true);
            dataset.setName(newName + "...");
            if (tree != null) {
                ((DefaultTreeModel)tree.getModel()).nodeChanged(this);
            }
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    datasetNode.setIsChanging(false);
                    datasetNode.getDataset().setName(newName);
                    if (tree != null) {
                        ((DefaultTreeModel)tree.getModel()).nodeChanged(datasetNode);
                    }
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initRenameDataset(dataset, name, newName);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    public void loadDataForProperties(final Runnable callback) {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        AbstractDatabaseCallback dbCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                callback.run();
            }
        };
        if (dataSet.isQuantitation()) {
            DatabaseDataSetTask task1 = new DatabaseDataSetTask(dbCallback);
            task1.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
            task1.initLoadQuantitation(dataSet.getProject(), dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task1);
        } else {
            AbstractDatabaseCallback task1Callback = dataSet.getResultSetId() != null ? null : dbCallback;
            DatabaseDataSetTask task1 = new DatabaseDataSetTask(task1Callback);
            task1.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
            task1.initLoadRsetAndRsm(dataSet);
            if (dataSet.getResultSetId() != null) {
                AbstractDatabaseCallback task2Callback = dataSet.getResultSummaryId() != null ? null : dbCallback;
                DatabaseRsetProperties task2 = new DatabaseRsetProperties(task2Callback, dataSet.getProject().getId(), dataSet);
                task2.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
                task1.setConsecutiveTask((AbstractDatabaseTask)task2);
                if (dataSet.getResultSummaryId() != null) {
                    DatabaseRsummaryProperties task3 = new DatabaseRsummaryProperties(dbCallback, dataSet.getProject().getId(), dataSet);
                    task3.setPriority(AbstractDatabaseTask.Priority.HIGH_3);
                    task2.setConsecutiveTask((AbstractDatabaseTask)task3);
                }
            }
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task1);
        }
    }

    @Override
    public AbstractNode copyNode() {
        if (this.isTrash()) {
            return null;
        }
        DataSetNode copy = new DataSetNode(this.getData());
        this.copyChildren(copy);
        return copy;
    }

    public boolean isQuantitation() {
        DDatasetType datasetType = ((DataSetData)this.getData()).getDatasetType();
        return datasetType.isQuantitation();
    }

    public boolean isQuantSC() {
        if (this.isQuantitation()) {
            DDataset d = ((DataSetData)this.getData()).getDataset();
            return d.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING;
        }
        return false;
    }

    public boolean isQuantXIC() {
        if (this.isQuantitation()) {
            DDataset d = ((DataSetData)this.getData()).getDataset();
            return d.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION;
        }
        return false;
    }

    public DDataset getParentMergedDataset() {
        if (this.getParent() instanceof DataSetNode) {
            DataSetNode parentNode = (DataSetNode)this.getParent();
            if (parentNode.getDataset().getAggregationInformation() != null) {
                return parentNode.getDataset();
            }
            return null;
        }
        return null;
    }

    @Override
    public Sheet createSheet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIsReference() {
        this.m_isReference = true;
    }
}

