/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.ProjectIdentificationData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProjectTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.utils.IconManager;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

public class IdProjectIdentificationNode
extends AbstractNode {
    public IdProjectIdentificationNode(AbstractData data) {
        super(AbstractNode.NodeTypes.PROJECT_IDENTIFICATION, data);
    }

    public Project getProject() {
        return ((ProjectIdentificationData)this.getData()).getProject();
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return this.getIcon(IconManager.IconType.IDENTIFICATION);
    }

    @Override
    public String toString() {
        return "Identifications";
    }

    public void changeNameAndDescription(final String newName, final String newDescription) {
        final Project project = this.getProject();
        final String name = project.getName();
        String description = project.getDescription();
        if (newName != null && newName.compareTo(name) != 0 || newDescription != null && newDescription.compareTo(description) != 0) {
            this.setIsChanging(true);
            project.setName(newName + "...");
            ((DefaultTreeModel)IdentificationTree.getCurrentTree().getModel()).nodeChanged(this);
            final IdProjectIdentificationNode projectNode = this;
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        IdProjectIdentificationNode.this.setIsChanging(false);
                        project.setName(newName);
                        project.setDescription(newDescription);
                        ((DefaultTreeModel)IdentificationTree.getCurrentTree().getModel()).nodeChanged(projectNode);
                    } else {
                        IdProjectIdentificationNode.this.setIsChanging(false);
                        project.setName(name);
                        ((DefaultTreeModel)IdentificationTree.getCurrentTree().getModel()).nodeChanged(projectNode);
                    }
                }
            };
            DatabaseProjectTask task = new DatabaseProjectTask(callback);
            task.initChangeSettingsOfProject(project, newName, newDescription, null);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    public void loadDataForProperties(Runnable callback) {
        callback.run();
    }

    @Override
    public Sheet createSheet() {
        Project p = this.getProject();
        Sheet sheet = Sheet.createDefault();
        try {
            Sheet.Set propGroup = Sheet.createPropertiesSet();
            PropertySupport.Reflection prop = new PropertySupport.Reflection((Object)p, Long.class, "getId", null);
            prop.setName("id");
            propGroup.put((Node.Property)prop);
            prop = new PropertySupport.Reflection((Object)p, String.class, "getName", null);
            prop.setName("name");
            propGroup.put((Node.Property)prop);
            prop = new PropertySupport.Reflection((Object)p, String.class, "getDescription", null);
            prop.setName("description");
            propGroup.put((Node.Property)prop);
            sheet.put(propGroup);
        }
        catch (NoSuchMethodException e) {
            m_logger.error(this.getClass().getSimpleName() + " properties error ", (Throwable)e);
        }
        return sheet;
    }

    @Override
    public AbstractNode copyNode() {
        IdProjectIdentificationNode copy = new IdProjectIdentificationNode(this.getData());
        this.copyChildren(copy);
        return copy;
    }
}

