/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.ProjectIdentificationData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.AddIdentificationFolderAction;
import fr.proline.studio.rsmexplorer.actions.identification.AggregateAction;
import fr.proline.studio.rsmexplorer.actions.identification.ChangeTypicalProteinJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.ClearDatasetAction;
import fr.proline.studio.rsmexplorer.actions.identification.CopySearchResult;
import fr.proline.studio.rsmexplorer.actions.identification.DeleteAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayAllRsetAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsetAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmAction;
import fr.proline.studio.rsmexplorer.actions.identification.EmptyTrashAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportAction;
import fr.proline.studio.rsmexplorer.actions.identification.FilterRSMProteinSetsJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.GenerateSpectrumMatchesJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.IdentifyPtmSitesJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.ImportMaxQuantResultJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.ImportSearchResultAsDatasetJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.ImportSearchResultAsRsetJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.MergeJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.PasteSearchResult;
import fr.proline.studio.rsmexplorer.actions.identification.PropertiesAction;
import fr.proline.studio.rsmexplorer.actions.identification.QuantifyAction;
import fr.proline.studio.rsmexplorer.actions.identification.RenameRsetAction;
import fr.proline.studio.rsmexplorer.actions.identification.RetrieveBioSeqJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.UpdatePeaklistSoftwareAction;
import fr.proline.studio.rsmexplorer.actions.identification.ValidateJMSAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.ChildFactory;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.HourGlassNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdAllImportedNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdTransferHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.NbPreferences;

public class IdentificationTree
extends AbstractTree
implements TreeWillExpandListener {
    private boolean m_isMainTree;
    private static boolean emptyFound = false;
    private static HashMap<ProjectIdentificationData, IdentificationTree> m_treeMap = new HashMap();
    private static IdentificationTree m_currentTree = null;
    private boolean m_loadingDone = false;
    private JPopupMenu m_mainPopup;
    private ArrayList<AbstractRSMAction> m_mainActions;
    private JPopupMenu m_trashPopup;
    private ArrayList<AbstractRSMAction> m_trashActions;
    private JPopupMenu m_allImportedPopup;
    private ArrayList<AbstractRSMAction> m_allImportedActions;

    public static IdentificationTree getTree(ProjectIdentificationData projectData) {
        IdentificationTree tree = m_treeMap.get(projectData);
        if (tree == null) {
            tree = new IdentificationTree(projectData);
            m_treeMap.put(projectData, tree);
        }
        m_currentTree = tree;
        return tree;
    }

    public static IdentificationTree getCurrentTree() {
        return m_currentTree;
    }

    public static boolean renameNode(DDataset dataset, String naming, DataSetNode datasetNode, AbstractTree tree) {
        String newName;
        if (dataset == null || dataset.getResultSet() == null || dataset.getResultSet().getMsiSearch() == null) {
            return false;
        }
        String string = newName = dataset.getResultSet().getMsiSearch().getResultFileName() == null ? "" : dataset.getResultSet().getMsiSearch().getResultFileName();
        if (newName.contains(".")) {
            newName = newName.substring(0, newName.indexOf("."));
        }
        if (naming.equalsIgnoreCase("SEARCH_RESULT_NAME")) {
            newName = dataset.getResultSet().getName();
        } else if (naming.equalsIgnoreCase("MASCOT_DAEMON_RULE")) {
            int rightBrackets;
            String nominee = dataset.getResultSet().getName();
            int leftBrackets = StringUtils.countMatches((CharSequence)nominee, (CharSequence)"(");
            newName = leftBrackets == (rightBrackets = StringUtils.countMatches((CharSequence)nominee, (CharSequence)")")) && leftBrackets == 1 && nominee.lastIndexOf(")") > nominee.lastIndexOf("(") ? nominee.substring(nominee.lastIndexOf("(") + 1, nominee.lastIndexOf(")")) : nominee;
        } else if (naming.equalsIgnoreCase("PEAKLIST_PATH")) {
            String string2 = newName = dataset.getResultSet().getMsiSearch().getPeaklist().getPath() == null ? "" : dataset.getResultSet().getMsiSearch().getPeaklist().getPath();
            if (newName.contains(File.separator)) {
                newName = newName.substring(newName.lastIndexOf(File.separator) + 1);
            }
        }
        if (!newName.equalsIgnoreCase("")) {
            datasetNode.rename(newName, m_currentTree);
            dataset.setName(newName);
            m_currentTree.rename(datasetNode, newName);
            return false;
        }
        return true;
    }

    public static boolean renameTreeNodes(AbstractNode root, IdentificationTree tree) {
        emptyFound = false;
        Preferences preferences = NbPreferences.root();
        final String naming = preferences.get("DefaultSearchResultNameSource", "MSI_SEARCH_FILE_NAME");
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DataSetData datasetData;
            AbstractNode currentElement = (AbstractNode)e.nextElement();
            if (currentElement.getType() != AbstractNode.NodeTypes.DATA_SET || (datasetData = (DataSetData)currentElement.getData()).hasChildren()) continue;
            final DDataset dataset = datasetData.getDataset();
            final DataSetNode node = (DataSetNode)currentElement;
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (IdentificationTree.renameNode(dataset, naming, node, m_currentTree)) {
                        emptyFound = true;
                    }
                }
            };
            if (dataset.getResultSet() == null) {
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initLoadRsetAndRsm(dataset);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                continue;
            }
            if (!IdentificationTree.renameNode(dataset, naming, node, m_currentTree)) continue;
            emptyFound = true;
        }
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.reload(root);
        return emptyFound;
    }

    private IdentificationTree(ProjectIdentificationData projectData) {
        this.setEditable(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        IdTransferHandler handler = new IdTransferHandler();
        this.setTransferHandler(handler);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.m_isMainTree = true;
        AbstractNode top = ChildFactory.createNode((AbstractData)projectData);
        this.initTree(top);
        this.startLoading(top, true);
    }

    public IdentificationTree(AbstractNode top) {
        this.m_isMainTree = false;
        this.initTree(top);
        this.startLoading(top, true);
    }

    @Override
    protected final void initTree(AbstractNode top) {
        super.initTree(top);
        this.addTreeWillExpandListener(this);
    }

    public static void clearAll() {
        m_treeMap.clear();
    }

    public static HashMap<ProjectIdentificationData, IdentificationTree> getTreeMap() {
        return m_treeMap;
    }

    public void removeRootChildren() {
        this.m_loadingDone = false;
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        root.removeAllChildren();
        this.m_model.nodeStructureChanged(root);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            return false;
        }
        if (this.isEditable()) {
            if (path.getPathCount() == 1) {
                return false;
            }
            AbstractNode node = (AbstractNode)path.getLastPathComponent();
            AbstractNode.NodeTypes nodeType = node.getType();
            if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dataSetNode = (DataSetNode)node;
                return !dataSetNode.isInTrash() && !dataSetNode.isChanging();
            }
            if (nodeType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                return true;
            }
        }
        return false;
    }

    public IdentificationTree copyResultSetRootSubTree(ResultSet rset, long projectId) {
        long rsetId = rset.getId();
        DataSetNode rsetNode = this.findResultSetNode((AbstractNode)this.m_model.getRoot(), rsetId, projectId);
        if (rsetNode == null) {
            return null;
        }
        return new IdentificationTree(rsetNode);
    }

    public IdentificationTree copyDataSetRootSubTree(DDataset dset, long projectId) {
        long dsetId = dset.getId();
        DataSetNode dsetNode = this.findDataSetNode((AbstractNode)this.m_model.getRoot(), dsetId, projectId);
        if (dsetNode == null) {
            return null;
        }
        return new IdentificationTree(dsetNode);
    }

    public AbstractNode copyRootNodeForSelection() {
        AbstractNode node = (AbstractNode)this.m_model.getRoot();
        return node.copyNode();
    }

    private DataSetNode findDataSetNode(AbstractNode node, long dsetId, long projectId) {
        int nbChildren = node.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            IdProjectIdentificationNode projectNode;
            DataSetNode dataSetNode;
            AbstractNode childNode = (AbstractNode)node.getChildAt(i);
            AbstractNode.NodeTypes childType = childNode.getType();
            if (childType == AbstractNode.NodeTypes.DATA_SET) {
                dataSetNode = (DataSetNode)childNode;
                Long datasetId = dataSetNode.getDataset().getId();
                if (datasetId != null && datasetId == dsetId) {
                    return dataSetNode;
                }
            } else if (childType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION && (projectNode = (IdProjectIdentificationNode)childNode).getProject().getId() != projectId) continue;
            if (childNode.isLeaf() || (dataSetNode = this.findDataSetNode(childNode, dsetId, projectId)) == null) continue;
            return dataSetNode;
        }
        return null;
    }

    private DataSetNode findResultSetNode(AbstractNode node, long rsetId, long projectId) {
        int nbChildren = node.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            IdProjectIdentificationNode projectNode;
            DataSetNode dataSetNode;
            AbstractNode childNode = (AbstractNode)node.getChildAt(i);
            AbstractNode.NodeTypes childType = childNode.getType();
            if (childType == AbstractNode.NodeTypes.DATA_SET) {
                dataSetNode = (DataSetNode)childNode;
                Long resultSetId = dataSetNode.getResultSetId();
                if (resultSetId != null && (long)resultSetId.intValue() == rsetId) {
                    return dataSetNode;
                }
            } else if (childType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION && (projectNode = (IdProjectIdentificationNode)childNode).getProject().getId() != projectId) continue;
            if (childNode.isLeaf() || (dataSetNode = this.findResultSetNode(childNode, rsetId, projectId)) == null) continue;
            return dataSetNode;
        }
        return null;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        AbstractNode childNode;
        TreePath path = event.getPath();
        AbstractNode nodeExpanded = (AbstractNode)path.getLastPathComponent();
        if (nodeExpanded.getChildCount() > 0 && (childNode = (AbstractNode)nodeExpanded.getChildAt(0)).getType() == AbstractNode.NodeTypes.HOUR_GLASS) {
            this.startLoading(nodeExpanded, true);
        }
    }

    public void startLoading() {
        if (this.m_loadingDone) {
            return;
        }
        this.m_loadingDone = true;
        AbstractNode root = (AbstractNode)this.m_model.getRoot();
        this.m_model.insertNodeInto(new HourGlassNode(null), root, 0);
        this.expandRow(0);
    }

    public void loadInBackground(AbstractNode nodeToLoad, final AbstractDatabaseCallback parentCallback) {
        if (nodeToLoad.getChildCount() == 0) {
            parentCallback.run(true, 0L, null, true);
            return;
        }
        AbstractNode childNode = (AbstractNode)nodeToLoad.getChildAt(0);
        if (childNode.getType() != AbstractNode.NodeTypes.HOUR_GLASS) {
            parentCallback.run(true, 0L, null, true);
            return;
        }
        this.m_loadingMap.put(nodeToLoad.getData(), nodeToLoad);
        final ArrayList childrenList = new ArrayList();
        final AbstractData parentData = nodeToLoad.getData();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdentificationTree.this.dataLoaded(parentData, childrenList);
                        parentCallback.run(true, 0L, null, true);
                    }
                });
            }
        };
        parentData.load(callback, childrenList, true);
    }

    public void moveToTrash(AbstractNode[] selectedNodes) {
        int nbSelectedNode = selectedNodes.length;
        if (nbSelectedNode == 0) {
            return;
        }
        ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>(nbSelectedNode);
        keptNodes.add(selectedNodes[0]);
        block0: for (int i = 1; i < nbSelectedNode; ++i) {
            AbstractNode curKeptNode;
            int j;
            AbstractNode curNode = selectedNodes[i];
            int nbKeptNodes = keptNodes.size();
            for (j = 0; j < nbKeptNodes; ++j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (curNode.isNodeAncestor(curKeptNode)) continue block0;
            }
            for (j = nbKeptNodes - 1; j >= 0; --j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (!curKeptNode.isNodeAncestor(curNode)) continue;
                keptNodes.remove(j);
            }
            keptNodes.add(curNode);
        }
        IdProjectIdentificationNode projectNode = null;
        for (AbstractNode parentNodeCur = (AbstractNode)((AbstractNode)keptNodes.get(0)).getParent(); parentNodeCur != null; parentNodeCur = (AbstractNode)parentNodeCur.getParent()) {
            if (!(parentNodeCur instanceof IdProjectIdentificationNode)) continue;
            projectNode = (IdProjectIdentificationNode)parentNodeCur;
            break;
        }
        if (projectNode == null) {
            return;
        }
        DataSetNode trash = null;
        int nbChildren = projectNode.getChildCount();
        for (int i = nbChildren - 1; i >= 0; --i) {
            DataSetNode datasetNode;
            AbstractNode childNode = (AbstractNode)projectNode.getChildAt(i);
            if (!(childNode instanceof DataSetNode) || !(datasetNode = (DataSetNode)childNode).isTrash()) continue;
            trash = datasetNode;
            break;
        }
        if (trash == null) {
            return;
        }
        LinkedHashSet<AbstractNode> allParentNodeModified = new LinkedHashSet<AbstractNode>();
        int nbKeptNodes = keptNodes.size();
        for (int i = 0; i < nbKeptNodes; ++i) {
            AbstractNode nodeCur = (AbstractNode)keptNodes.get(i);
            allParentNodeModified.add((AbstractNode)nodeCur.getParent());
            this.m_model.removeNodeFromParent(nodeCur);
            this.m_model.insertNodeInto(nodeCur, trash, trash.getChildCount());
        }
        allParentNodeModified.add(trash);
        LinkedHashMap databaseObjectsToModify = new LinkedHashMap();
        for (AbstractNode parentNode : allParentNodeModified) {
            DDataset databaseParentObject = null;
            AbstractNode.NodeTypes type = parentNode.getType();
            if (type == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode datasetNode = (DataSetNode)parentNode;
                databaseParentObject = datasetNode.getDataset();
            } else if (type == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                IdProjectIdentificationNode projectNodeS = (IdProjectIdentificationNode)parentNode;
                databaseParentObject = projectNodeS.getProject();
            }
            int nb = parentNode.getChildCount();
            ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nb);
            for (int i = 0; i < nb; ++i) {
                AbstractNode childNode = (AbstractNode)parentNode.getChildAt(i);
                if (childNode instanceof DataSetNode) {
                    DDataset dataset = ((DataSetNode)childNode).getDataset();
                    datasetList.add(dataset);
                    continue;
                }
                if (!(childNode instanceof HourGlassNode)) continue;
            }
            databaseObjectsToModify.put(databaseParentObject, datasetList);
        }
        DatabaseDataSetTask.updateDatasetAndProjectsTree(databaseObjectsToModify, (boolean)true);
    }

    @Override
    public void rename(AbstractNode rsmNode, String newName) {
        if (rsmNode.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)rsmNode;
            Project project = projectNode.getProject();
            ((IdProjectIdentificationNode)rsmNode).changeNameAndDescription(newName, project.getDescription());
        } else if (rsmNode.getType() == AbstractNode.NodeTypes.DATA_SET) {
            ((DataSetNode)rsmNode).rename(newName, IdentificationTree.getCurrentTree());
        }
    }

    private void triggerPopup(MouseEvent e) {
        ArrayList<AbstractRSMAction> actions;
        JPopupMenu popup;
        int i;
        AbstractNode[] selectedNodes = this.getSelectedNodes();
        int nbNodes = selectedNodes.length;
        if (nbNodes == 0) {
            return;
        }
        boolean trashNodeSelected = false;
        boolean allImportedNodeSelected = false;
        for (i = 0; i < nbNodes; ++i) {
            AbstractNode n = selectedNodes[i];
            if (n instanceof DataSetNode) {
                DataSetNode datasetNode = (DataSetNode)n;
                if (datasetNode.isTrash()) {
                    trashNodeSelected = true;
                    continue;
                }
                if (!datasetNode.isInTrash()) continue;
                return;
            }
            if (!(n instanceof IdAllImportedNode)) continue;
            allImportedNodeSelected = true;
        }
        if (nbNodes != 1 || !allImportedNodeSelected) {
            for (i = 0; i < nbNodes; ++i) {
                if (!selectedNodes[i].isChanging()) continue;
                return;
            }
        }
        if (trashNodeSelected && nbNodes == 1) {
            if (this.m_trashPopup == null) {
                this.m_trashActions = new ArrayList(1);
                EmptyTrashAction emtpyTrashAction = new EmptyTrashAction(this);
                this.m_trashActions.add(emtpyTrashAction);
                this.m_trashPopup = new JPopupMenu();
                this.m_trashPopup.add(emtpyTrashAction.getPopupPresenter());
            }
            popup = this.m_trashPopup;
            actions = this.m_trashActions;
        } else if (allImportedNodeSelected && nbNodes == 1) {
            if (this.m_allImportedPopup == null) {
                this.m_allImportedActions = new ArrayList(6);
                DisplayAllRsetAction allRsetAction = new DisplayAllRsetAction(this);
                this.m_allImportedActions.add(allRsetAction);
                this.m_allImportedActions.add(null);
                ImportSearchResultAsRsetJMSAction importJmsAction = new ImportSearchResultAsRsetJMSAction(this);
                this.m_allImportedActions.add(importJmsAction);
                this.m_allImportedPopup = new JPopupMenu();
                for (AbstractRSMAction action : this.m_allImportedActions) {
                    if (action == null) {
                        this.m_allImportedPopup.addSeparator();
                        continue;
                    }
                    this.m_allImportedPopup.add(action.getPopupPresenter());
                }
            }
            popup = this.m_allImportedPopup;
            actions = this.m_allImportedActions;
        } else {
            if (this.m_mainPopup == null) {
                Preferences preferences = NbPreferences.root();
                Boolean showHiddenFunctionnality = false;
                this.m_mainActions = new ArrayList(25);
                DisplayRsetAction displayRsetAction = new DisplayRsetAction(this);
                this.m_mainActions.add(displayRsetAction);
                DisplayRsmAction displayRsmAction = new DisplayRsmAction(this);
                this.m_mainActions.add(displayRsmAction);
                this.m_mainActions.add(null);
                AggregateAction aggregateAction = new AggregateAction(this);
                this.m_mainActions.add(aggregateAction);
                AddIdentificationFolderAction addFolderAction = new AddIdentificationFolderAction(this);
                this.m_mainActions.add(addFolderAction);
                this.m_mainActions.add(null);
                CopySearchResult copyAction = new CopySearchResult(this);
                this.m_mainActions.add(copyAction);
                PasteSearchResult pasteAction = new PasteSearchResult(this);
                this.m_mainActions.add(pasteAction);
                this.m_mainActions.add(null);
                RenameRsetAction renameRsetAction = new RenameRsetAction(this);
                this.m_mainActions.add(renameRsetAction);
                ClearDatasetAction clearAction = new ClearDatasetAction(this);
                this.m_mainActions.add(clearAction);
                DeleteAction deleteAction = new DeleteAction(this);
                this.m_mainActions.add(deleteAction);
                this.m_mainActions.add(null);
                ImportSearchResultAsDatasetJMSAction identificationAction = new ImportSearchResultAsDatasetJMSAction(this);
                this.m_mainActions.add(identificationAction);
                ImportMaxQuantResultJMSAction importMaxQuant = new ImportMaxQuantResultJMSAction(this);
                this.m_mainActions.add(importMaxQuant);
                ValidateJMSAction validateJMSAction = new ValidateJMSAction(this);
                this.m_mainActions.add(validateJMSAction);
                MergeJMSAction mergeJmsAction = new MergeJMSAction(this);
                this.m_mainActions.add(mergeJmsAction);
                FilterRSMProteinSetsJMSAction filterProtSetAction = new FilterRSMProteinSetsJMSAction(this);
                this.m_mainActions.add(filterProtSetAction);
                ChangeTypicalProteinJMSAction changeTypicalProteinJmsAction = new ChangeTypicalProteinJMSAction(this);
                this.m_mainActions.add(changeTypicalProteinJmsAction);
                IdentifyPtmSitesJMSAction identifyPtmSitesAction = new IdentifyPtmSitesJMSAction(this);
                this.m_mainActions.add(identifyPtmSitesAction);
                this.m_mainActions.add(null);
                GenerateSpectrumMatchesJMSAction generateSpectrumMatchesAction = new GenerateSpectrumMatchesJMSAction(this);
                this.m_mainActions.add(generateSpectrumMatchesAction);
                UpdatePeaklistSoftwareAction updatePeaklistSoftAction = new UpdatePeaklistSoftwareAction(this);
                this.m_mainActions.add(updatePeaklistSoftAction);
                RetrieveBioSeqJMSAction retrieveBioSeqAction = new RetrieveBioSeqJMSAction(this);
                this.m_mainActions.add(retrieveBioSeqAction);
                this.m_mainActions.add(null);
                QuantifyAction quantifyAction = new QuantifyAction(this);
                this.m_mainActions.add(quantifyAction);
                this.m_mainActions.add(null);
                ExportAction exportAction = new ExportAction(this);
                this.m_mainActions.add(exportAction);
                this.m_mainActions.add(null);
                PropertiesAction propertiesAction = new PropertiesAction(this);
                this.m_mainActions.add(propertiesAction);
                this.m_mainPopup = new JPopupMenu();
                for (AbstractRSMAction action : this.m_mainActions) {
                    if (action == null) {
                        this.m_mainPopup.addSeparator();
                        continue;
                    }
                    this.m_mainPopup.add(action.getPopupPresenter());
                }
            }
            popup = this.m_mainPopup;
            actions = this.m_mainActions;
        }
        for (AbstractRSMAction action : actions) {
            if (action == null) continue;
            action.updateEnabled(selectedNodes);
        }
        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    public static void reinitMainPopup() {
        Iterator<ProjectIdentificationData> it = m_treeMap.keySet().iterator();
        while (it.hasNext()) {
            IdentificationTree tree = m_treeMap.get(it.next());
            tree.m_mainPopup = null;
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        AbstractNode n;
        AbstractNode[] selectedNodes;
        int nbNodes;
        if (SwingUtilities.isRightMouseButton(e)) {
            this.manageSelectionOnRightClick(e);
        } else if (e.getClickCount() == 2 && (nbNodes = (selectedNodes = this.getSelectedNodes()).length) == 1 && (n = selectedNodes[0]) instanceof IdAllImportedNode) {
            new DisplayAllRsetAction(this).actionPerformed(selectedNodes, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.m_isMainTree && SwingUtilities.isRightMouseButton(e)) {
            this.manageSelectionOnRightClick(e);
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private DataSetNode getTrashNode() {
        IdProjectIdentificationNode projectNode = null;
        TreeNode root = (TreeNode)this.m_model.getRoot();
        if (root instanceof IdProjectIdentificationNode) {
            projectNode = (IdProjectIdentificationNode)root;
        }
        if (projectNode == null) {
            return null;
        }
        DataSetNode trash = null;
        int nbChildren = projectNode.getChildCount();
        for (int i = nbChildren - 1; i >= 0; --i) {
            DataSetNode datasetNode;
            AbstractNode childNode = (AbstractNode)projectNode.getChildAt(i);
            if (!(childNode instanceof DataSetNode) || !(datasetNode = (DataSetNode)childNode).isTrash()) continue;
            trash = datasetNode;
            break;
        }
        if (trash == null) {
            return null;
        }
        return trash;
    }

    public void loadTrash() {
        DataSetNode trashNode = this.getTrashNode();
        if (trashNode != null) {
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return false;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                }
            };
            IdentificationTree.getCurrentTree().loadInBackground(trashNode, callback);
        }
    }

    public static class RSMTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (((AbstractNode)value).isDisabled()) {
                l.setForeground(Color.LIGHT_GRAY);
            } else if (sel) {
                l.setForeground(Color.WHITE);
            } else {
                l.setForeground(Color.BLACK);
            }
            ImageIcon icon = ((AbstractNode)value).getIcon(expanded);
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

