/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.core.orm.msi.Peaklist;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabasePeaklistTask;
import fr.proline.studio.dam.tasks.DatabaseRunsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNodeInitListener;
import fr.proline.studio.utils.IconManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.openide.nodes.Sheet;

public class XICRunNode
extends AbstractNode {
    private DefaultTreeModel m_treeModel = null;
    private AbstractTableModel m_tableModel;
    protected List<XICRunNodeInitListener> listenerList = new ArrayList<XICRunNodeInitListener>();

    public XICRunNode(AbstractData data, DefaultTreeModel treeModel) {
        super(AbstractNode.NodeTypes.RUN, data);
        this.m_treeModel = treeModel;
    }

    public void addXICRunNodeInitListener(XICRunNodeInitListener l) {
        this.listenerList.add(l);
    }

    public void removeTableModelListener(XICRunNodeInitListener l) {
        this.listenerList.remove(l);
    }

    private void fireXICRunNodeInitialized() {
        for (XICRunNodeInitListener l : this.listenerList) {
            l.initCompleted(this);
        }
    }

    public AbstractTableModel getTableModel() {
        return this.m_tableModel;
    }

    public void setTableModel(AbstractTableModel tableModel) {
        this.m_tableModel = tableModel;
    }

    public void init(final DDataset dataset, final AbstractTableModel tableModel) {
        this.m_tableModel = tableModel;
        this.setIsChanging(true);
        if (!dataset.isIdentification()) {
            throw new RuntimeException("Creating XIC Run Node without an identification dataset.");
        }
        final HashMap rawfileFounds = new HashMap(1);
        final Run[] runOut = new Run[1];
        final XICRunNode xicRunNode = this;
        AbstractDatabaseCallback getRawfileCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    if (!rawfileFounds.isEmpty()) {
                        RawFile rawFile = (RawFile)rawfileFounds.entrySet().iterator().next().getValue();
                        RunInfoData runInfoData = (RunInfoData)XICRunNode.this.getData();
                        runInfoData.setLinkedRawFile(rawFile);
                        runInfoData.setRun(runOut[0]);
                        runInfoData.setStatus(RunInfoData.Status.LINKED_IN_DATABASE);
                        XICRunNode.this.setIsChanging(false);
                        XICRunNode.this.m_treeModel.nodeChanged(xicRunNode);
                        XICRunNode.this.fireXICRunNodeInitialized();
                        if (tableModel != null) {
                            tableModel.fireTableDataChanged();
                        }
                    } else {
                        final Peaklist[] peaklistResult = new Peaklist[1];
                        AbstractDatabaseCallback getPeakListCallback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                RunInfoData runInfoData = (RunInfoData)XICRunNode.this.getData();
                                if (success) {
                                    if (peaklistResult[0] != null) {
                                        Peaklist peaklist = peaklistResult[0];
                                        if (peaklist.getRawFileIdentifier() != null && !peaklist.getRawFileIdentifier().equalsIgnoreCase("")) {
                                            runInfoData.setMessage("Search " + peaklist.getRawFileIdentifier());
                                            XICRunNode.this.m_treeModel.nodeChanged(xicRunNode);
                                            XICRunNode.this.searchPotentialRawFiles(peaklist.getRawFileIdentifier(), tableModel, Search.BASED_ON_IDENTIFIER);
                                        } else if (peaklist.getPath() != null && !peaklist.getPath().equalsIgnoreCase("")) {
                                            int indexMgf;
                                            String searchString = peaklist.getPath();
                                            int indexRaw = searchString.toLowerCase().indexOf(".raw");
                                            if (indexRaw != -1) {
                                                searchString = searchString.substring(0, indexRaw);
                                            }
                                            if ((indexMgf = searchString.toLowerCase().indexOf(".mgf")) != -1) {
                                                searchString = searchString.substring(0, indexMgf);
                                            }
                                            int index = searchString.lastIndexOf(47);
                                            index = Math.max(index, searchString.lastIndexOf(92));
                                            if ((index = Math.max(index, searchString.lastIndexOf(126))) != -1) {
                                                searchString = searchString.substring(index + 1);
                                            }
                                            runInfoData.setPeakListPath(searchString);
                                            searchString = searchString == null || searchString.isEmpty() ? "*" : "*" + searchString + "*";
                                            runInfoData.setMessage("Search " + searchString);
                                            runInfoData.setStatus(RunInfoData.Status.MISSING);
                                            XICRunNode.this.m_treeModel.nodeChanged(xicRunNode);
                                            XICRunNode.this.searchPotentialRawFiles(searchString, tableModel, Search.BASED_ON_PATH);
                                        } else {
                                            runInfoData.setMessage("<html><font color='#FF0000'>No Info (Partial peaklist)</font></html>");
                                            runInfoData.setStatus(RunInfoData.Status.MISSING);
                                            XICRunNode.this.fireXICRunNodeInitialized();
                                        }
                                    } else {
                                        runInfoData.setMessage("<html><font color='#FF0000'>Unavailable Peaklist</font></html>");
                                        runInfoData.setStatus(RunInfoData.Status.MISSING);
                                        XICRunNode.this.fireXICRunNodeInitialized();
                                    }
                                    XICRunNode.this.setIsChanging(false);
                                    XICRunNode.this.m_treeModel.nodeChanged(xicRunNode);
                                    if (tableModel != null) {
                                        tableModel.fireTableDataChanged();
                                    }
                                } else {
                                    runInfoData.setStatus(RunInfoData.Status.MISSING);
                                    runInfoData.setMessage("<html><font color='#FF0000'>Unavailable Peaklist</font></html>");
                                    XICRunNode.this.fireXICRunNodeInitialized();
                                    XICRunNode.this.m_treeModel.nodeChanged(xicRunNode);
                                    if (tableModel != null) {
                                        tableModel.fireTableDataChanged();
                                    }
                                }
                            }
                        };
                        DatabasePeaklistTask peaklistTask = new DatabasePeaklistTask(getPeakListCallback);
                        peaklistTask.initLoadPeaklistForRS(dataset.getResultSetId().longValue(), dataset.getProject().getId(), peaklistResult);
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)peaklistTask);
                    }
                } else {
                    XICRunNode.this.m_treeModel.removeNodeFromParent((MutableTreeNode)xicRunNode.getParent());
                    if (tableModel != null) {
                        tableModel.fireTableDataChanged();
                    }
                }
            }
        };
        DatabaseRunsTask task = new DatabaseRunsTask(getRawfileCallback);
        task.initLoadRawFile(Long.valueOf(dataset.getId()), rawfileFounds, runOut);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void searchPotentialRawFiles(String searchString, final AbstractTableModel tableModel, final Search search) {
        final HashMap m_rawFileMap = new HashMap();
        AbstractDatabaseCallback searchRawCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                XICRunNode.this.setIsChanging(false);
                RunInfoData runInfoData = (RunInfoData)XICRunNode.this.getData();
                if (m_rawFileMap.isEmpty()) {
                    runInfoData.setMessage("<html><font color='#FF0000'>Missing Raw File</font></html>");
                    runInfoData.setStatus(RunInfoData.Status.MISSING);
                } else if (m_rawFileMap.size() == 1) {
                    RawFile rawFile = (RawFile)m_rawFileMap.entrySet().iterator().next().getValue();
                    runInfoData.setSelectedRawFile(rawFile);
                    runInfoData.setRun((Run)rawFile.getRuns().get(0));
                    if (search == Search.BASED_ON_PATH) {
                        runInfoData.setStatus(RunInfoData.Status.SYSTEM_PROPOSED);
                    } else if (search == Search.BASED_ON_IDENTIFIER) {
                        runInfoData.setStatus(RunInfoData.Status.LAST_DEFINED);
                    }
                } else {
                    runInfoData.setPotentialRawFiles(m_rawFileMap);
                    runInfoData.setStatus(RunInfoData.Status.MISSING);
                    runInfoData.setMessage("<html><font color='#FF0000'>Multiple Raw Files</font></html>");
                }
                XICRunNode.this.fireXICRunNodeInitialized();
                if (tableModel != null) {
                    tableModel.fireTableDataChanged();
                }
            }
        };
        DatabaseRunsTask task = new DatabaseRunsTask(searchRawCallback);
        task.initSearchRawFile(searchString, m_rawFileMap);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    @Override
    public String toString() {
        AbstractData data = this.getData();
        if (data == null) {
            return "Loading";
        }
        return super.toString();
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return this.getIcon(IconManager.IconType.FILE);
    }

    @Override
    public Sheet createSheet() {
        return null;
    }

    @Override
    public AbstractNode copyNode() {
        return null;
    }

    public void loadDataForProperties(Runnable callback) {
    }

    public void setRawFile(final File selectedFile, final ActionListener doneCallback) {
        this.setIsChanging(true);
        this.m_treeModel.nodeChanged(this);
        String searchString = selectedFile.getName().substring(0, selectedFile.getName().lastIndexOf(46));
        final HashMap m_rawFilesMap = new HashMap();
        final XICRunNode _this = this;
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                RunInfoData runInfoData = (RunInfoData)XICRunNode.this.getData();
                if (m_rawFilesMap.size() == 1) {
                    RawFile rawFile = (RawFile)m_rawFilesMap.values().iterator().next();
                    runInfoData.setSelectedRawFile(rawFile);
                    runInfoData.setRun((Run)rawFile.getRuns().get(0));
                } else {
                    runInfoData.setRawFileOnDisk(selectedFile);
                }
                XICRunNode.this.setIsChanging(false);
                XICRunNode.this.m_treeModel.nodeChanged(_this);
                if (doneCallback != null) {
                    doneCallback.actionPerformed(null);
                }
            }
        };
        DatabaseRunsTask task = new DatabaseRunsTask(callback);
        task.initSearchRawFile(searchString, m_rawFilesMap);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    public String getPeakListPath() {
        RunInfoData data = (RunInfoData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getPeakListPath();
    }

    public static enum Search {
        BASED_ON_IDENTIFIER,
        BASED_ON_PATH;

    }
}

