/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTableCellRenderer;
import fr.proline.studio.table.LazyTableModelInterface;
import fr.proline.studio.table.renderer.GrayedRenderer;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultRowSorter;
import javax.swing.JScrollBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openide.windows.WindowManager;

public abstract class LazyTable
extends DecoratedMarkerTable
implements AdjustmentListener,
ProgressInterface {
    protected LastAction m_lastAction = LastAction.ACTION_NONE;
    private final HashMap<String, TableCellRenderer> m_rendererMap = new HashMap();
    private final StringBuilder m_sb = new StringBuilder();
    private boolean m_sortForbidden = false;

    public LazyTable(JScrollBar verticalScrollbar) {
        this.setDefaultRenderer(LazyData.class, new LazyTableCellRenderer());
        final LazyTable table = this;
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LazyTable.this.m_sortForbidden) {
                    return;
                }
                if (!LazyTable.this.isSortable()) {
                    ProgressInterface progressInterface = (ProgressInterface)table.getModel();
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)progressInterface, (String)"Data loading", (String)"Sorting is not available while data is loading. Please Wait.");
                    dialog.setLocation(e.getLocationOnScreen());
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        return;
                    }
                    int col = LazyTable.this.columnAtPoint(e.getPoint());
                    col = col == -1 ? -1 : LazyTable.this.convertColumnIndexToModel(col);
                    DefaultRowSorter sorter = (DefaultRowSorter)table.getRowSorter();
                    ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
                    list.add(new RowSorter.SortKey(col, SortOrder.ASCENDING));
                    sorter.setSortKeys(list);
                    sorter.sort();
                    return;
                }
                int col = LazyTable.this.columnAtPoint(e.getPoint());
                col = col == -1 ? -1 : LazyTable.this.convertColumnIndexToModel(col);
                LazyTable.this.m_lastAction = LastAction.ACTION_SORTING;
                ((LazyTableModelInterface)LazyTable.this.getModel()).sortingChanged(col);
                LazyTable.this.sortingChanged(col);
            }
        });
        verticalScrollbar.addAdjustmentListener(this);
        this.setSortable(false);
    }

    public void forbidSort(boolean sortForbidden) {
        this.m_sortForbidden = sortForbidden;
        this.setSortable(false);
    }

    public void sortingChanged(int col) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.m_lastAction = LastAction.ACTION_SCROLLING;
        Long taskId = ((LazyTableModelInterface)this.getModel()).getTaskId();
        if (taskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().clearIndexPriorityTo(taskId);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.m_lastAction = LastAction.ACTION_SELECTING;
    }

    public void scrollRowToVisible(int row) {
        LastAction keepAction = this.m_lastAction;
        try {
            super.scrollRowToVisible(row);
        }
        finally {
            this.m_lastAction = keepAction;
        }
    }

    public void setSelection(int row) {
        LastAction keepAction = this.m_lastAction;
        try {
            this.getSelectionModel().setSelectionInterval(row, row);
        }
        finally {
            this.m_lastAction = keepAction;
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableModel model = this.getModel();
        if (model instanceof GlobalTableModelInterface) {
            int columnInModel = this.convertColumnIndexToModel(column);
            int rowInModel = this.convertRowIndexToModel(row);
            TableCellRenderer renderer = ((GlobalTableModelInterface)model).getRenderer(rowInModel, columnInModel);
            if (renderer != null) {
                Object value = model.getValueAt(rowInModel, columnInModel);
                if (value != null && value.getClass().equals(LazyData.class)) {
                    this.m_sb.append(columnInModel);
                    if (renderer instanceof GrayedRenderer) {
                        this.m_sb.append("grayed");
                    }
                    if (((LazyData)value).getData() != null) {
                        this.m_sb.append(((LazyData)value).getData().getClass().getName());
                    }
                    String key = this.m_sb.toString();
                    this.m_sb.setLength(0);
                    TableCellRenderer registeredRenderer = this.m_rendererMap.get(key);
                    if (registeredRenderer != null) {
                        return registeredRenderer;
                    }
                    renderer = new LazyTableCellRenderer(renderer);
                    this.m_rendererMap.put(key, renderer);
                    return renderer;
                }
                return renderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        dataModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == -1) {
                    LazyTable.this.m_rendererMap.clear();
                }
            }
        });
    }

    public static enum LastAction {
        ACTION_NONE,
        ACTION_SORTING,
        ACTION_SELECTING,
        ACTION_SCROLLING;

    }
}

