/*
 * Decompiled with CFR 0.152.
 */
package com.thierry.filtering.report;

import com.thierry.filtering.report.ReportBuilder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;

public class TableReportGenerator {
    private JTable m_table;

    public TableReportGenerator(JTable table) {
        this.m_table = table;
    }

    private Component getRendererComponent(int row, int column) {
        TableCellRenderer renderer = this.m_table.getCellRenderer(row, column);
        return this.m_table.prepareRenderer(renderer, row, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateFullReport(ReportBuilder builder) {
        ListSelectionModel previousModel = this.m_table.getSelectionModel();
        try {
            int i;
            this.m_table.setSelectionModel((ListSelectionModel)previousModel.getClass().newInstance());
            builder.open();
            builder.startTable();
            int columnCount = this.m_table.getColumnCount();
            int rowCount = this.m_table.getRowCount();
            builder.startTableHeader();
            for (i = 0; i < columnCount; ++i) {
                builder.addColumnHeader(this.m_table.getColumnName(i));
            }
            builder.endTableHeader();
            for (i = 0; i < rowCount; ++i) {
                builder.startLine();
                for (int j = 0; j < columnCount; ++j) {
                    this.addHTMLFormattedCell(builder, i, j);
                }
                builder.endLine();
            }
            builder.endTable();
            builder.close();
            String string = builder.toString();
            return string;
        }
        catch (InstantiationException e) {
            String string = null;
            return string;
        }
        catch (IllegalAccessException e) {
            String string = null;
            return string;
        }
        finally {
            if (this.m_table != null) {
                this.m_table.setSelectionModel(previousModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelection(ReportBuilder builder) {
        ListSelectionModel previousModel = this.m_table.getSelectionModel();
        int[] rows = this.m_table.getSelectedRows();
        try {
            int i;
            this.m_table.setSelectionModel((ListSelectionModel)previousModel.getClass().newInstance());
            int columnCount = this.m_table.getColumnCount();
            builder.open();
            builder.startTable();
            builder.startTableHeader();
            for (i = 0; i < columnCount; ++i) {
                builder.addColumnHeader(this.m_table.getColumnName(i));
            }
            builder.endTableHeader();
            for (i = 0; i < rows.length; ++i) {
                builder.startLine();
                for (int j = 0; j < columnCount; ++j) {
                    this.addHTMLFormattedCell(builder, rows[i], j);
                }
                builder.endLine();
            }
            builder.endTable();
            builder.close();
            String string = builder.toString();
            return string;
        }
        catch (InstantiationException e) {
            String string = null;
            return string;
        }
        catch (IllegalAccessException e) {
            String string = null;
            return string;
        }
        finally {
            if (this.m_table != null) {
                this.m_table.setSelectionModel(previousModel);
            }
        }
    }

    private void addHTMLFormattedCell(ReportBuilder builder, int row, int column) {
        Component comp = this.getRendererComponent(row, column);
        Color bgColor = comp.getBackground();
        Color fgColor = comp.getForeground();
        builder.addCell(bgColor, fgColor, this.extractTextFromComponent(comp));
    }

    private String extractTextFromComponent(Component comp) {
        String text = "";
        if (comp instanceof JLabel) {
            text = ((JLabel)comp).getText();
        } else if (comp instanceof AbstractButton) {
            text = ((AbstractButton)comp).getText();
        }
        text = text.replaceFirst("<html><body>", "");
        text = text.replaceFirst("</body></html>", "");
        return text;
    }
}

