/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.proline.studio.export.CheckboxTabPanel;
import fr.proline.studio.export.DnDTabbedPane;
import fr.proline.studio.export.ExportConfig;
import fr.proline.studio.export.ExportDataExport;
import fr.proline.studio.export.ExportExcelSheet;
import fr.proline.studio.export.ExportExcelSheetField;
import fr.proline.studio.export.ExporterFactory;
import fr.proline.studio.export.TabTitleEditListener;
import fr.proline.studio.export.TableRowTransferHandler;
import fr.proline.studio.export.model.CustomExportTableModel;
import fr.proline.studio.gui.CollapsablePanel;
import fr.proline.studio.gui.CollapseListener;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.settings.FilePreferences;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomExportDialog
extends DefaultDialog
implements CollapseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    private static final String EXPORT_PROTEIN_ALL = "All";
    private static final String EXPORT_PROTEIN_VALIDATED = "Validated only";
    private static final String[] EXPORT_PROTEIN_VALUES = new String[]{"Validated only", "All"};
    private static final String JSON_EXTENSION = "json";
    private static final String TSV_EXTENSION = "tsv";
    private static final FileNameExtensionFilter FILTER_EXCEL = new FileNameExtensionFilter("Excel File (.xlsx)", "xlsx");
    private static final FileNameExtensionFilter FILTER_TSV = new FileNameExtensionFilter("Tabulation Separated Values (.tsv)", "tsv");
    private static final String DEFAULT_SERVER_CONFIG_KEY = "DEFAULT_SERVER_CONFIG";
    private static final String CURRENT_CONFIG_KEY = "CURRENT_CONFIG";
    private static final String ORIENTATION_ROW = "rows";
    private static final String ORIENTATION_COLUMNS = "columns";
    static String EXPORT_ALL_FIELD_LABEL = "Select/Unselect all fields";
    static String ORIENTATION_LABEL = "Orientation:";
    private static CustomExportDialog m_singletonDialog = null;
    private JTextField m_fileTextField;
    private JComboBox m_exporTypeCombobox;
    private static boolean m_fileExportMode;
    private final JFileChooser m_fchooser;
    private final JFileChooser m_exportFchooser;
    private DefaultDialog.ProgressTask m_task = null;
    private JTabbedPane m_tabbedPane;
    private String m_configFile = "";
    private JComboBox comboBox_ProteinSets;
    private JComboBox comboBox_DateFormat;
    private JComboBox comboBox_NumberSeparator;
    public ExportConfig m_exportConfig;
    private ExportConfig m_exportDefaultConfig;
    protected boolean m_updateInProgress = true;
    public HashMap<String, String> m_tabTitleIdHashMap;
    private JPanel m_optionPanel;
    private JComboBox comboBox_exportProfile;
    private HashMap<String, String> m_configServerKey2configMap = new HashMap();
    private String m_currentServerConfigStr = null;
    private String m_previousServerConfigStr = null;

    public static CustomExportDialog getDialog(Window parent, boolean fileExportMode) {
        m_fileExportMode = fileExportMode;
        if (m_singletonDialog == null) {
            m_singletonDialog = new CustomExportDialog(parent, fileExportMode);
        }
        return m_singletonDialog;
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    private CustomExportDialog(Window parent, boolean fileExportMode) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setButtonVisible(3, true);
        this.setButtonVisible(4, true);
        this.setButtonEnabled(4, false);
        this.setResizable(true);
        m_fileExportMode = fileExportMode;
        this.setTitle("Export");
        this.setButtonVisible(5, true);
        this.setDocumentationSuffix("id.37m2jsg");
        Preferences preferences = NbPreferences.root();
        String defaultExportPath = preferences.get("DefaultExcelExportPath", System.getProperty("user.home"));
        String path = preferences.absolutePath();
        File f = new File(path);
        path = f.getAbsolutePath();
        this.m_tabTitleIdHashMap = new HashMap();
        this.setInternalComponent(this.createCustomExportPanel(defaultExportPath));
        this.setButtonName(0, "Export");
        this.m_fchooser = new JFileChooser(new File(defaultExportPath));
        this.m_exportFchooser = new JFileChooser(new File(defaultExportPath));
        this.m_fchooser.addChoosableFileFilter(FILTER_EXCEL);
        this.m_fchooser.addChoosableFileFilter(FILTER_TSV);
        this.m_fchooser.setMultiSelectionEnabled(false);
        this.m_exportFchooser.setMultiSelectionEnabled(false);
        FileNameExtensionFilter filterJson = new FileNameExtensionFilter("Custom Export Config (.json)", JSON_EXTENSION);
        this.m_exportFchooser.setFileFilter(filterJson);
    }

    public boolean isFileExportMode() {
        return m_fileExportMode;
    }

    private boolean isTsv() {
        return this.m_exporTypeCombobox.getSelectedItem() != null && this.m_exporTypeCombobox.getSelectedItem().toString().contains(TSV_EXTENSION);
    }

    private void loadExportConfig() {
        this.m_exportConfig = new ExportConfig();
        String jsonString = "";
        String path = this.m_configFile.trim();
        Path filePath = Paths.get(this.m_configFile.trim(), new String[0]);
        FilePreferences filePreferences = new FilePreferences(new File(path), null, "");
        String fileDefaultServerConfig = filePreferences.get(DEFAULT_SERVER_CONFIG_KEY, null);
        boolean showWarning = false;
        if (fileDefaultServerConfig == null) {
            try {
                jsonString = new String(Files.readAllBytes(filePath));
            }
            catch (IOException e) {
                logger.error("Error while loading config " + e);
            }
            showWarning = true;
        } else {
            jsonString = filePreferences.get(CURRENT_CONFIG_KEY, null);
            boolean bl = showWarning = fileDefaultServerConfig.compareTo(this.m_currentServerConfigStr) != 0;
        }
        if (!filePath.toString().equals("")) {
            Gson gson = new Gson();
            String messageHashMapJsonString = jsonString;
            this.m_exportConfig = (ExportConfig)gson.fromJson(messageHashMapJsonString, this.m_exportConfig.getClass());
        }
        if (showWarning) {
            InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "The version of the Export Settings file does not correspond. It could lead to an error during the export.");
            errorDialog.setButtonVisible(1, false);
            errorDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
            errorDialog.setVisible(true);
        }
    }

    private void fillExportPossibleValues(ExportConfig param) {
        if (param != null) {
            if (param.format_values != null) {
                String[] reformatedParamValues = new String[param.format_values.length];
                for (int i = 0; i < param.format_values.length; ++i) {
                    if (param.format_values[i].contains("xls")) {
                        reformatedParamValues[i] = "Excel (." + param.format_values[i] + ")";
                        continue;
                    }
                    if (param.format_values[i].contains(TSV_EXTENSION)) {
                        reformatedParamValues[i] = "Tabulation separated values (." + param.format_values[i] + ")";
                        continue;
                    }
                    if (!param.format_values[i].contains("csv")) continue;
                    reformatedParamValues[i] = "Comma separated values (." + param.format_values[i] + ")";
                }
                this.m_exporTypeCombobox.setModel(new DefaultComboBoxModel<String>(reformatedParamValues));
            }
            if (param.date_format_values != null) {
                this.comboBox_DateFormat.setModel(new DefaultComboBoxModel<String>(param.date_format_values));
            }
            if (param.decimal_separator_values != null) {
                this.comboBox_NumberSeparator.setModel(new DefaultComboBoxModel<String>(param.decimal_separator_values));
            }
            this.comboBox_ProteinSets.setModel(new DefaultComboBoxModel<String>(new String[]{EXPORT_PROTEIN_ALL, EXPORT_PROTEIN_VALIDATED}));
            if (param.data_export.all_protein_set) {
                this.comboBox_ProteinSets.setSelectedIndex(0);
            } else {
                this.comboBox_ProteinSets.setSelectedIndex(1);
            }
            this.comboBox_exportProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Best", EXPORT_PROTEIN_ALL}));
            if (param.data_export.best_profile) {
                this.comboBox_exportProfile.setSelectedIndex(0);
            } else {
                this.comboBox_exportProfile.setSelectedIndex(1);
            }
        }
    }

    private void selectLoadedExportValues(ExportConfig param) {
        if (param != null) {
            if (param.date_format != null) {
                this.comboBox_DateFormat.setSelectedItem(param.date_format);
            }
            if (param.decimal_separator != null) {
                this.comboBox_NumberSeparator.setSelectedItem(param.decimal_separator);
            }
            if (param.data_export.all_protein_set) {
                this.comboBox_ProteinSets.setSelectedItem(EXPORT_PROTEIN_ALL);
            } else {
                this.comboBox_ProteinSets.setSelectedItem(EXPORT_PROTEIN_VALIDATED);
            }
            if (param.data_export.best_profile) {
                this.comboBox_exportProfile.setSelectedIndex(0);
            } else {
                this.comboBox_exportProfile.setSelectedIndex(1);
            }
        }
    }

    private void fillExportFormatTable(ExportConfig defaultParam, ExportConfig param) {
        ExportExcelSheet sheet;
        int i;
        this.m_updateInProgress = true;
        this.m_tabbedPane.removeAll();
        this.m_tabTitleIdHashMap.clear();
        for (int i2 = 0; i2 < defaultParam.sheets.length; ++i2) {
            this.m_tabTitleIdHashMap.put(defaultParam.sheets[i2].title, defaultParam.sheets[i2].id);
        }
        ArrayList<String> addedTabs = new ArrayList<String>();
        if (param != null) {
            for (i = 0; i < param.sheets.length; ++i) {
                sheet = param.sheets[i];
                if (!this.m_tabTitleIdHashMap.containsValue(sheet.id)) continue;
                addedTabs.add(sheet.id);
                JTable table = this.createSheetTab(sheet, true);
                CustomExportTableModel tableModel = new CustomExportTableModel();
                ArrayList<String> defaultFieldsList = this.getFieldsFromParamSheet(defaultParam.sheets, sheet.id);
                ArrayList<String> addedFieldsList = new ArrayList<String>();
                for (int j = 0; j < sheet.fields.length; ++j) {
                    ExportExcelSheetField field = sheet.fields[j];
                    if (!defaultFieldsList.contains(field.id)) continue;
                    tableModel.addRow(field, Boolean.TRUE);
                    addedFieldsList.add(field.id);
                }
                int sheetIndexInDefaultConfig = defaultParam.getIndexOfSheet(sheet.id);
                ExportExcelSheetField[] allFields = defaultParam.sheets[sheetIndexInDefaultConfig].fields;
                for (int j = 0; j < allFields.length; ++j) {
                    ExportExcelSheetField field = allFields[j];
                    if (addedFieldsList.contains(field.id)) continue;
                    tableModel.addRow(field, Boolean.FALSE);
                }
                table.setModel(tableModel);
            }
        }
        for (i = 0; i < defaultParam.sheets.length; ++i) {
            sheet = defaultParam.sheets[i];
            if (addedTabs.contains(sheet.id)) continue;
            boolean enabled = param != null ? false : sheet.default_displayed;
            JTable table = this.createSheetTab(sheet, enabled);
            CustomExportTableModel tableModel = new CustomExportTableModel();
            for (int j = 0; j < sheet.fields.length; ++j) {
                ExportExcelSheetField field = sheet.fields[j];
                tableModel.addRow(field);
            }
            table.setModel(tableModel);
        }
        this.m_updateInProgress = false;
    }

    private ArrayList<String> getFieldsFromParamSheet(ExportExcelSheet[] sheets, String sheetId) {
        ArrayList<String> fieldsId = new ArrayList<String>();
        for (int i = 0; i < sheets.length; ++i) {
            if (!sheets[i].id.equals(sheetId)) continue;
            for (int j = 0; j < sheets[i].fields.length; ++j) {
                fieldsId.add(sheets[i].fields[j].id);
            }
        }
        return fieldsId;
    }

    public final JPanel createCustomExportPanel(String defaultExportPath) {
        JPanel insidePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        JLabel lblExportToFile = new JLabel("Export to file:");
        insidePanel.add((Component)lblExportToFile, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_fileTextField = new JTextField(50);
        this.m_fileTextField.setText(defaultExportPath);
        insidePanel.add((Component)this.m_fileTextField, c);
        c.weightx = 0.0;
        final JButton addFileButton = new JButton(IconManager.getIcon(IconManager.IconType.OPEN_FILE));
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                String textFile;
                if (CustomExportDialog.this.m_exporTypeCombobox.getSelectedItem() != null) {
                    if (m_fileExportMode) {
                        CustomExportDialog.this.m_fchooser.setFileSelectionMode(0);
                        if (CustomExportDialog.this.m_exporTypeCombobox.getSelectedItem().toString().contains("xls")) {
                            CustomExportDialog.this.m_fchooser.setFileFilter(FILTER_EXCEL);
                        } else {
                            CustomExportDialog.this.m_fchooser.setFileFilter(FILTER_TSV);
                        }
                    } else {
                        CustomExportDialog.this.m_fchooser.setFileSelectionMode(1);
                    }
                }
                if ((textFile = CustomExportDialog.this.m_fileTextField.getText().trim()).length() > 0) {
                    File currentFile = new File(textFile);
                    if (currentFile.isDirectory()) {
                        CustomExportDialog.this.m_fchooser.setCurrentDirectory(currentFile);
                    } else if (m_fileExportMode) {
                        CustomExportDialog.this.m_fchooser.setSelectedFile(currentFile);
                    } else {
                        CustomExportDialog.this.m_fchooser.setCurrentDirectory(currentFile);
                    }
                }
                if ((result = CustomExportDialog.this.m_fchooser.showOpenDialog(addFileButton)) == 0) {
                    File file = CustomExportDialog.this.m_fchooser.getSelectedFile();
                    String absolutePath = file.getAbsolutePath();
                    String fileName = file.getName();
                    if (m_fileExportMode) {
                        if (fileName.indexOf(46) == -1) {
                            absolutePath = CustomExportDialog.this.isTsv() ? absolutePath + ".tsv" : absolutePath + ".xlsx";
                        }
                    } else if (!fileName.endsWith("\\")) {
                        absolutePath = absolutePath + "\\";
                    }
                    CustomExportDialog.this.m_fileTextField.setText(absolutePath);
                }
            }
        });
        ++c.gridx;
        insidePanel.add((Component)addFileButton, c);
        JLabel lbl_exportType = new JLabel("Export Type:");
        this.m_exporTypeCombobox = new JComboBox();
        this.m_exporTypeCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"xlsx", "xls", "csv", TSV_EXTENSION}));
        c.gridx = 0;
        ++c.gridy;
        insidePanel.add((Component)lbl_exportType, c);
        ++c.gridx;
        c.weightx = 1.0;
        insidePanel.add((Component)this.m_exporTypeCombobox, c);
        c.weightx = 0.0;
        this.m_optionPanel = this.createOptionPanel();
        c.gridx = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        CollapsablePanel collapsablePanel = new CollapsablePanel("Custom Options", this.m_optionPanel, false);
        insidePanel.add((Component)collapsablePanel, c);
        collapsablePanel.addCollapseListener(this);
        return insidePanel;
    }

    private JPanel createOptionPanel() {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        optionPanel.setVisible(false);
        optionPanel.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel lblDateFormat = new JLabel("Date format:");
        this.comboBox_DateFormat = new JComboBox();
        this.comboBox_DateFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"yyyyMMdd HH:mm:ss", "ddMMyyyy HH:mm:ss", "MMddyyyy HH:mm:ss"}));
        JLabel lblProteinSets = new JLabel("Protein sets:");
        this.comboBox_ProteinSets = new JComboBox();
        this.comboBox_ProteinSets.setModel(new DefaultComboBoxModel<String>(EXPORT_PROTEIN_VALUES));
        JLabel lblNumberSeparator = new JLabel("Number separator:");
        this.comboBox_NumberSeparator = new JComboBox();
        this.comboBox_NumberSeparator.setModel(new DefaultComboBoxModel<String>(new String[]{".", ","}));
        JLabel lblExportProfile = new JLabel("Export profile:");
        this.comboBox_exportProfile = new JComboBox();
        this.comboBox_exportProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Best", EXPORT_PROTEIN_ALL}));
        c.gridx = 0;
        c.gridy = 0;
        optionPanel.add((Component)lblDateFormat, c);
        ++c.gridx;
        optionPanel.add((Component)this.comboBox_DateFormat, c);
        ++c.gridx;
        optionPanel.add((Component)lblProteinSets, c);
        ++c.gridx;
        optionPanel.add((Component)this.comboBox_ProteinSets, c);
        c.gridx = 0;
        ++c.gridy;
        optionPanel.add((Component)lblNumberSeparator, c);
        ++c.gridx;
        optionPanel.add((Component)this.comboBox_NumberSeparator, c);
        ++c.gridx;
        optionPanel.add((Component)lblExportProfile, c);
        ++c.gridx;
        optionPanel.add((Component)this.comboBox_exportProfile, c);
        c.gridwidth = 4;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_tabbedPane = this.createTabbedPane();
        optionPanel.add((Component)this.m_tabbedPane, c);
        return optionPanel;
    }

    private JTabbedPane createTabbedPane() {
        DnDTabbedPane tabbedPane = new DnDTabbedPane(1);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CustomExportDialog.this.updatePresentationModeForNewlySelectedTab();
            }
        });
        TabTitleEditListener l = new TabTitleEditListener(tabbedPane, this);
        tabbedPane.addMouseListener(l);
        tabbedPane.setTabLayoutPolicy(1);
        return tabbedPane;
    }

    @Override
    protected boolean saveCalled() {
        this.saveConfigFile();
        return false;
    }

    @Override
    protected boolean loadCalled() {
        boolean loaded = this.loadConfigFile();
        if (loaded && !this.m_optionPanel.isVisible()) {
            this.collapse(false);
        }
        return false;
    }

    protected void recalculateTabTitleIdHashMap() {
        this.m_tabTitleIdHashMap.clear();
        for (int i = 0; i < this.m_tabbedPane.getTabCount(); ++i) {
            Component comp = this.m_tabbedPane.getTabComponentAt(i);
            if (comp == null || !(comp instanceof CheckboxTabPanel)) continue;
            CheckboxTabPanel c = (CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(i);
            this.m_tabTitleIdHashMap.put(c.getText(), ((CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(i)).getSheetId());
        }
    }

    protected void recalculateTabsIds() {
        if (this.m_exportDefaultConfig == null) {
            return;
        }
        if (this.m_exportDefaultConfig.sheets.length == 0) {
            return;
        }
        ArrayList<String> idFullList = new ArrayList<String>();
        for (int i = 0; i < this.m_exportDefaultConfig.sheets.length; ++i) {
            idFullList.add(this.m_exportDefaultConfig.sheets[i].id);
        }
        int removedAtIndex = -1;
        for (int i = 0; i < this.m_tabbedPane.getTabCount(); ++i) {
            String sheetId;
            Component comp = this.m_tabbedPane.getTabComponentAt(i);
            if (!(comp instanceof CheckboxTabPanel)) {
                return;
            }
            CheckboxTabPanel c = (CheckboxTabPanel)comp;
            String string = sheetId = c == null ? null : c.getSheetId();
            if (sheetId == null) {
                removedAtIndex = i;
                continue;
            }
            idFullList.remove(sheetId);
        }
        if (removedAtIndex > -1) {
            CheckboxTabPanel cRemoved;
            if (idFullList.size() > 1) {
                logger.warn("Problem: more than one missing ID");
            } else if (idFullList.size() == 1 && (cRemoved = (CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(removedAtIndex)) != null) {
                cRemoved.setSheetId(cRemoved.getSheetId());
            }
        }
    }

    protected boolean loadConfigFile() {
        int result;
        String configFile = this.m_configFile.trim();
        if (configFile.length() > 0) {
            File currentFile = new File(configFile);
            if (currentFile.isDirectory()) {
                this.m_exportFchooser.setCurrentDirectory(currentFile);
            } else {
                this.m_exportFchooser.setSelectedFile(currentFile);
            }
        }
        if ((result = this.m_exportFchooser.showOpenDialog(this)) == 0) {
            String absolutePath;
            File file = this.m_exportFchooser.getSelectedFile();
            this.m_configFile = absolutePath = file.getAbsolutePath();
            this.loadExportConfig();
            if (this.m_exportDefaultConfig != null) {
                this.fillExportFormatTable(this.m_exportDefaultConfig, this.m_exportConfig);
                this.updatePresentationModeForNewlySelectedTab();
                this.selectLoadedExportValues(this.m_exportConfig);
            }
            return true;
        }
        return false;
    }

    protected void updatePresentationModeForNewlySelectedTab() {
        if (!this.m_updateInProgress) {
            this.m_updateInProgress = true;
            this.recalculateTabsIds();
            this.recalculateTabTitleIdHashMap();
            this.m_updateInProgress = false;
        }
    }

    protected void saveConfigFile() {
        int result;
        String configFile = this.m_configFile.trim();
        if (configFile.length() > 0) {
            File currentFile = new File(configFile);
            if (currentFile.isDirectory()) {
                this.m_exportFchooser.setCurrentDirectory(currentFile);
            } else {
                this.m_exportFchooser.setSelectedFile(currentFile);
            }
        }
        if ((result = this.m_exportFchooser.showSaveDialog(this)) == 0) {
            File file = this.m_exportFchooser.getSelectedFile();
            String absolutePath = file.getAbsolutePath();
            if (!absolutePath.endsWith(".json")) {
                absolutePath = absolutePath + ".json";
            }
            this.m_configFile = absolutePath;
            File f = new File(absolutePath);
            if (f.exists()) {
                String message = "The file already exists. Do you want to overwrite it ?";
                String title = "Overwrite ?";
                Object[] options = new String[]{"Yes", "No"};
                int reply = JOptionPane.showOptionDialog(this, message, title, 0, 1, null, options, "Yes");
                if (reply != 0) {
                    return;
                }
                f.delete();
            }
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String jsonString = gson.toJson(this.generateConfigFileFromGUI());
                FilePreferences filePreferences = new FilePreferences(f, null, "");
                filePreferences.put(DEFAULT_SERVER_CONFIG_KEY, this.m_currentServerConfigStr);
                filePreferences.put(CURRENT_CONFIG_KEY, jsonString);
            }
            catch (Exception e) {
                logger.error("Error while saving the configuration " + e);
            }
        }
    }

    protected void presentationModeChanged() {
        this.recalculateTabsIds();
        this.recalculateTabTitleIdHashMap();
    }

    protected void orientationModeChanged(String sheetId) {
        int selectedTab = this.m_tabbedPane.getSelectedIndex();
        this.recalculateTabsIds();
        this.recalculateTabTitleIdHashMap();
    }

    protected String tabTitleToTabId(String title) {
        return this.m_tabTitleIdHashMap.get(title);
    }

    protected int tabTitleToTabPosition(String tabTitle) {
        for (int i = 0; i < this.m_tabbedPane.getTabCount(); ++i) {
            if (!((CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(i)).getText().equals(tabTitle)) continue;
            return i;
        }
        return this.m_tabbedPane.getTabCount();
    }

    protected int sheetNameToSheetIndex(String sheetTitle) {
        for (int i = 0; i < this.m_exportConfig.sheets.length; ++i) {
            if (!this.m_exportConfig.sheets[i].title.equals(sheetTitle)) continue;
            return i;
        }
        return this.m_exportConfig.sheets.length;
    }

    protected int sheetIdToSheetIndex(String sheetId) {
        for (int i = 0; i < this.m_exportConfig.sheets.length; ++i) {
            if (!this.m_exportConfig.sheets[i].id.equals(sheetId)) continue;
            return i;
        }
        return this.m_exportConfig.sheets.length;
    }

    protected ExportConfig generateConfigFileFromGUI() {
        ExportConfig ec = new ExportConfig();
        if (this.m_exporTypeCombobox.getSelectedIndex() == 0) {
            ec.format = "xlsx";
        } else if (this.m_exporTypeCombobox.getSelectedIndex() == 1) {
            ec.format = TSV_EXTENSION;
        }
        if (this.comboBox_NumberSeparator.getSelectedIndex() == 0) {
            ec.decimal_separator = ".";
        } else if (this.comboBox_NumberSeparator.getSelectedIndex() == 1) {
            ec.decimal_separator = ",";
        }
        ec.date_format = (String)this.comboBox_DateFormat.getSelectedItem();
        ec.data_export = new ExportDataExport();
        ec.data_export.all_protein_set = this.comboBox_ProteinSets.getSelectedItem().equals(EXPORT_PROTEIN_ALL);
        ec.data_export.best_profile = this.comboBox_exportProfile.getSelectedItem().equals("Best");
        ec.format_values = null;
        ec.decimal_separator_values = null;
        ec.date_format_values = null;
        ec.sheet_presentation_values = null;
        int nbActiveTabs = 0;
        for (int i = 0; i < this.m_tabbedPane.getTabCount(); ++i) {
            if (!this.m_tabbedPane.isEnabledAt(i)) continue;
            ++nbActiveTabs;
        }
        ec.sheets = new ExportExcelSheet[nbActiveTabs];
        int usedTabNumber = 0;
        for (int i = 0; i < this.m_tabbedPane.getTabCount(); ++i) {
            if (!this.m_tabbedPane.isEnabledAt(i)) continue;
            ec.sheets[usedTabNumber] = new ExportExcelSheet();
            JPanel panelTemp = (JPanel)this.m_tabbedPane.getComponentAt(i);
            JPanel sheetOptionPane = (JPanel)panelTemp.getComponent(0);
            JComboBox orientation = (JComboBox)sheetOptionPane.getComponent(1);
            if (orientation.getSelectedIndex() == 0) {
                ec.sheets[usedTabNumber].setPresentation(ORIENTATION_ROW);
            } else if (orientation.getSelectedIndex() == 1) {
                ec.sheets[usedTabNumber].setPresentation(ORIENTATION_COLUMNS);
            }
            JScrollPane jsp = (JScrollPane)panelTemp.getComponent(1);
            JTable tableRef = (JTable)jsp.getViewport().getComponents()[0];
            int nbRows = tableRef.getRowCount();
            int nbSelectedRows = 0;
            for (int row = 0; row < nbRows; ++row) {
                if (!tableRef.getValueAt(row, 2).equals(true)) continue;
                ++nbSelectedRows;
            }
            ec.sheets[usedTabNumber].id = this.tabTitleToTabId(((CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(i)).getText());
            ec.sheets[usedTabNumber].title = ((CheckboxTabPanel)this.m_tabbedPane.getTabComponentAt(i)).getText();
            ec.sheets[usedTabNumber].fields = new ExportExcelSheetField[nbSelectedRows];
            int newStructRow = 0;
            for (int currentRow = 0; currentRow < nbRows; ++currentRow) {
                if (!tableRef.getValueAt(currentRow, 2).equals(true)) continue;
                ec.sheets[usedTabNumber].fields[newStructRow] = new ExportExcelSheetField();
                ec.sheets[usedTabNumber].fields[newStructRow].id = tableRef.getValueAt(currentRow, 0).toString();
                ec.sheets[usedTabNumber].fields[newStructRow].title = tableRef.getValueAt(currentRow, 1).toString();
                ++newStructRow;
            }
            ++usedTabNumber;
        }
        return ec;
    }

    public String getFileName() {
        return this.m_fileTextField.getText().trim();
    }

    public ExporterFactory.ExporterInfo getExporterInfo() {
        return (ExporterFactory.ExporterInfo)this.m_exporTypeCombobox.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean okCalled() {
        ExportConfig config;
        String msgError;
        Object[] options2;
        String title;
        String message;
        int reply2;
        String fileName = this.m_fileTextField.getText().trim();
        if (fileName.length() == 0) {
            this.setStatus(true, "You must fill the file name.");
            this.highlight(this.m_fileTextField);
            return false;
        }
        File f = new File(fileName);
        if (this.isFileExportMode() && f.exists() && (reply2 = JOptionPane.showOptionDialog(this, message = "The file already exists. Do you want to overwrite it ?", title = "Overwrite ?", 0, 1, null, options2 = new String[]{"Yes", "No"}, "Yes")) != 0) {
            this.setStatus(true, "File already exists.");
            return false;
        }
        if (this.isFileExportMode()) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(f);
                fw.write("t");
            }
            catch (Exception e) {
                this.setStatus(true, fileName + " is not writable.");
                this.highlight(this.m_fileTextField);
                boolean options2 = false;
                return options2;
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    f.delete();
                }
                catch (Exception reply2) {}
            }
        }
        if (!f.canWrite()) {
            this.setStatus(true, "Cannot write in this directory");
            this.highlight(this.m_fileTextField);
            return false;
        }
        if (!(msgError = this.checkTitles(config = this.generateConfigFileFromGUI())).isEmpty()) {
            JOptionPane.showMessageDialog(this, msgError);
            return false;
        }
        this.startTask(CustomExportDialog.m_singletonDialog.m_task);
        Preferences preferences = NbPreferences.root();
        preferences.put("DefaultExcelExportPath", f.getAbsoluteFile().getParentFile().getAbsolutePath());
        String exportConfigStr = this.getExportConfig();
        this.m_configServerKey2configMap.put(this.m_currentServerConfigStr, exportConfigStr);
        return false;
    }

    @Override
    protected boolean cancelCalled() {
        return true;
    }

    public String getExportConfig() {
        logger.debug("getExportConfig");
        this.m_exportConfig = this.generateConfigFileFromGUI();
        return this.m_exportConfig == null ? null : new GsonBuilder().create().toJson(this.m_exportConfig);
    }

    public String getFileExtension() {
        this.m_exportConfig = this.generateConfigFileFromGUI();
        return this.m_exportConfig == null ? null : this.m_exportConfig.format;
    }

    public boolean setDefaultExportConfig(String serverConfigStr) {
        this.m_currentServerConfigStr = serverConfigStr;
        boolean mustUpdateConfig = false;
        String configStrToApply = this.m_configServerKey2configMap.get(serverConfigStr);
        if (configStrToApply == null) {
            configStrToApply = serverConfigStr;
            this.m_configServerKey2configMap.put(serverConfigStr, serverConfigStr);
        }
        mustUpdateConfig = serverConfigStr.compareTo(configStrToApply) != 0 || this.m_previousServerConfigStr == null || this.m_currentServerConfigStr.compareTo(this.m_previousServerConfigStr) != 0;
        this.m_previousServerConfigStr = this.m_currentServerConfigStr;
        if (mustUpdateConfig) {
            logger.debug("setDefaultExportConfig");
            this.m_configFile = "";
            this.m_exportDefaultConfig = new Gson().fromJson(serverConfigStr, ExportConfig.class);
            this.m_tabTitleIdHashMap.clear();
            for (int i = 0; i < this.m_exportDefaultConfig.sheets.length; ++i) {
                this.m_tabTitleIdHashMap.put(this.m_exportDefaultConfig.sheets[i].title, this.m_exportDefaultConfig.sheets[i].id);
            }
            this.fillExportPossibleValues(this.m_exportDefaultConfig);
            if (this.m_exportDefaultConfig != null) {
                this.fillExportFormatTable(this.m_exportDefaultConfig, this.m_exportConfig);
            }
            Gson gson = new Gson();
            String messageHashMapJsonString = configStrToApply;
            this.m_exportConfig = new ExportConfig();
            this.m_exportConfig = (ExportConfig)gson.fromJson(messageHashMapJsonString, this.m_exportConfig.getClass());
            this.fillExportFormatTable(this.m_exportDefaultConfig, this.m_exportConfig);
            this.updatePresentationModeForNewlySelectedTab();
            this.selectLoadedExportValues(this.m_exportConfig);
        }
        return mustUpdateConfig;
    }

    private String checkTitles(ExportConfig config) {
        String errorsOnConfig = "";
        ExportExcelSheet[] allSheets = config.sheets;
        int s = 1;
        for (ExportExcelSheet sheet : allSheets) {
            if (sheet.title == null || sheet.title.trim().isEmpty()) {
                errorsOnConfig = errorsOnConfig + "The sheet at position " + s + " has no title! \n";
            }
            ExportExcelSheetField[] allFields = sheet.fields;
            int f = 0;
            for (ExportExcelSheetField field : allFields) {
                if (field.title == null || field.title.trim().isEmpty()) {
                    errorsOnConfig = errorsOnConfig + "The field in the sheet " + sheet.title + " at position " + (f + 1) + " has no title! \n";
                } else if (sheet.containsFieldTitle(field.title, f)) {
                    errorsOnConfig = errorsOnConfig + "The field " + field.title + " in the sheet " + sheet.title + " (at position " + (f + 1) + ") is already defined. \n";
                }
                ++f;
            }
            ++s;
        }
        return errorsOnConfig;
    }

    public void updateFileExport(boolean mustUpdateConfig) {
        String text = this.m_fileTextField.getText().trim();
        if (!text.isEmpty()) {
            int id;
            boolean isDir = new File(text).isDirectory();
            if (!this.isFileExportMode() && !isDir && (id = text.lastIndexOf("\\")) != -1) {
                String newText = text.substring(0, id + 1);
                this.m_fileTextField.setText(newText);
            }
        }
    }

    @Override
    public void collapse(boolean collapse) {
        boolean isExpanded = !collapse;
        this.m_optionPanel.setVisible(isExpanded);
        this.setButtonEnabled(4, isExpanded);
        if (!isExpanded) {
            this.m_exportConfig = null;
            this.fillExportFormatTable(this.m_exportDefaultConfig, this.m_exportConfig);
            this.recalculateTabsIds();
            this.recalculateTabTitleIdHashMap();
        }
        m_singletonDialog.revalidate();
        m_singletonDialog.repack();
    }

    private void updateExportField(int indexCur, boolean isAllSelected) {
        JPanel panelTemp = (JPanel)this.m_tabbedPane.getComponentAt(indexCur);
        JScrollPane jsp = (JScrollPane)panelTemp.getComponent(1);
        JTable tableRef = (JTable)jsp.getViewport().getComponents()[0];
        for (int j = 0; j < tableRef.getRowCount(); ++j) {
            tableRef.setValueAt(isAllSelected, j, 2);
        }
    }

    private JPanel createSheetOptionPane(final ExportExcelSheet sheet) {
        JComboBox<String> orientationComboBox = new JComboBox<String>();
        JLabel orientationLabel = new JLabel(ORIENTATION_LABEL);
        orientationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ORIENTATION_ROW, ORIENTATION_COLUMNS}));
        String defaultOrientation = sheet.getPresentation();
        if (defaultOrientation.equals(ORIENTATION_ROW)) {
            orientationComboBox.setSelectedItem(ORIENTATION_ROW);
        } else {
            orientationComboBox.setSelectedItem(ORIENTATION_COLUMNS);
        }
        orientationComboBox.setName("");
        orientationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CustomExportDialog.this.m_updateInProgress) {
                    CustomExportDialog.this.orientationModeChanged(sheet.getId());
                }
            }
        });
        JLabel allSelectLabel = new JLabel(EXPORT_ALL_FIELD_LABEL);
        final JCheckBox allSelectedChkBox = new JCheckBox();
        allSelectedChkBox.setSelected(true);
        allSelectedChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = allSelectedChkBox.isSelected();
                int indexCur = -1;
                int nbTabs = CustomExportDialog.this.m_tabbedPane.getTabCount();
                for (int i = 0; i < nbTabs; ++i) {
                    CheckboxTabPanel tabComponent = (CheckboxTabPanel)CustomExportDialog.this.m_tabbedPane.getTabComponentAt(i);
                    String titleId = tabComponent.getSheetId();
                    if (!titleId.equals(sheet.getId())) continue;
                    indexCur = i;
                    break;
                }
                if (indexCur != -1) {
                    CustomExportDialog.this.updateExportField(indexCur, isSelected);
                }
            }
        });
        JPanel selectFieldPane = new JPanel();
        selectFieldPane.setLayout(new BoxLayout(selectFieldPane, 2));
        orientationLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        selectFieldPane.add(orientationLabel);
        selectFieldPane.add(orientationComboBox);
        selectFieldPane.add(Box.createHorizontalGlue());
        allSelectLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        selectFieldPane.add(allSelectLabel);
        selectFieldPane.add(allSelectedChkBox);
        selectFieldPane.add(Box.createRigidArea(new Dimension(80, 0)));
        return selectFieldPane;
    }

    private JTable createSheetTab(ExportExcelSheet sheet, boolean isSheetSelected) {
        JPanel tablePanel = new JPanel();
        this.m_tabbedPane.addTab(null, tablePanel);
        tablePanel.setLayout(new BorderLayout(0, 0));
        CheckboxTabPanel closableTabPanel = new CheckboxTabPanel(this.m_tabbedPane, sheet.title, sheet.id);
        int tabIndex = this.m_tabbedPane.getTabCount() - 1;
        this.m_tabbedPane.setTabComponentAt(tabIndex, closableTabPanel);
        this.m_tabbedPane.setEnabledAt(tabIndex, isSheetSelected);
        this.m_tabbedPane.setToolTipTextAt(tabIndex, sheet.id + " Rename the title by Right click to Enable/Disable");
        closableTabPanel.setSelected(isSheetSelected);
        JPanel selecAllFieldPane = this.createSheetOptionPane(sheet);
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.getViewport().setBackground(Color.white);
        tablePanel.add((Component)selecAllFieldPane, "North");
        tablePanel.add((Component)tableScrollPane, "Center");
        JTable table = new JTable();
        table.setDragEnabled(true);
        table.setDropMode(DropMode.INSERT_ROWS);
        table.setSelectionMode(0);
        table.setTransferHandler(new TableRowTransferHandler(table));
        table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                e.consume();
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, 2);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        tableScrollPane.setViewportView(table);
        return table;
    }
}

