/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.util.ArrayList;
import java.util.Map;

public class LogAdapterModel
implements ExtendedTableModelInterface {
    private ExtendedTableModelInterface m_innerModel = null;
    private int m_colX;
    private int m_colY;
    private POLICY m_policy;
    private Double m_replacementValue;
    private double[] m_dataX;
    private double[] m_dataY;
    private boolean[] m_error;
    private int[] m_row2sourceRowConversion;
    private int[] m_sourceRow2Conversion;
    private int m_rowCount;

    public LogAdapterModel(ExtendedTableModelInterface innerModel) {
        this.m_innerModel = innerModel;
    }

    public void update(POLICY policy, int colX, int colY, Double replacementValue) {
        this.m_policy = policy;
        this.m_colX = colX;
        this.m_colY = colY;
        this.m_replacementValue = replacementValue;
        int nb = this.m_innerModel.getRowCount();
        this.m_dataX = new double[nb];
        this.m_dataY = new double[nb];
        this.m_error = this.m_policy == POLICY.REPLACE_BY_VALUE ? new boolean[nb] : null;
        this.m_row2sourceRowConversion = new int[nb];
        this.m_sourceRow2Conversion = new int[nb];
        int row = 0;
        for (int i = 0; i < nb; ++i) {
            Object value;
            Object value2;
            Double x = null;
            if (colX != -1 && (x = Double.valueOf((value2 = this.m_innerModel.getDataValueAt(i, colX)) == null || !Number.class.isAssignableFrom(value2.getClass()) ? Double.NaN : ((Number)value2).doubleValue())) <= 0.0) {
                x = Double.NaN;
            }
            Double y = null;
            if (colY != -1 && (y = Double.valueOf((value = this.m_innerModel.getDataValueAt(i, colY)) == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue())) <= 0.0) {
                y = Double.NaN;
            }
            boolean error = false;
            if (colX != -1 && x.isNaN()) {
                error = true;
                if (this.m_policy == POLICY.REPLACE_BY_VALUE) {
                    x = this.m_replacementValue;
                }
            }
            if (colY != -1 && y.isNaN()) {
                error = true;
                if (this.m_policy == POLICY.REPLACE_BY_VALUE) {
                    y = this.m_replacementValue;
                }
            }
            if (error && this.m_policy == POLICY.REMOVE_INCORRECT_VALUES) continue;
            if (this.m_policy == POLICY.REPLACE_BY_VALUE) {
                this.m_error[row] = error;
            }
            if (colX != -1) {
                this.m_dataX[row] = x;
            }
            if (colY != -1) {
                this.m_dataY[row] = y;
            }
            this.m_row2sourceRowConversion[row] = i;
            this.m_sourceRow2Conversion[row] = i;
            ++row;
        }
        this.m_rowCount = row;
    }

    public ExtendedTableModelInterface getInnerModel() {
        return this.m_innerModel;
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    public boolean isOnError(int rowIndex) {
        if (this.m_policy == POLICY.REMOVE_INCORRECT_VALUES) {
            return false;
        }
        return this.m_error[rowIndex];
    }

    @Override
    public int getColumnCount() {
        return this.m_innerModel.getColumnCount();
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_innerModel.getDataColumnIdentifier(columnIndex);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        if (this.m_colX == columnIndex || this.m_colY == columnIndex) {
            return Double.class;
        }
        return this.m_innerModel.getDataColumnClass(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        if (this.m_colX == columnIndex) {
            return this.m_dataX[rowIndex];
        }
        if (this.m_colY == columnIndex) {
            return this.m_dataY[rowIndex];
        }
        return this.m_innerModel.getDataValueAt(this.m_row2sourceRowConversion[rowIndex], columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return this.m_innerModel.getKeysColumn();
    }

    @Override
    public int getInfoColumn() {
        return this.m_innerModel.getInfoColumn();
    }

    @Override
    public void setName(String name) {
        this.m_innerModel.setName(name);
    }

    @Override
    public String getName() {
        return this.m_innerModel.getName();
    }

    @Override
    public Map<String, Object> getExternalData() {
        return this.m_innerModel.getExternalData();
    }

    @Override
    public PlotInformation getPlotInformation() {
        return this.m_innerModel.getPlotInformation();
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return this.m_innerModel.row2UniqueId(this.m_row2sourceRowConversion[rowIndex]);
    }

    @Override
    public int uniqueId2Row(long id) {
        return this.m_sourceRow2Conversion[this.m_innerModel.uniqueId2Row(id)];
    }

    @Override
    public PlotDataSpec getDataSpecAt(int rowIndex) {
        return this.m_innerModel.getDataSpecAt(this.m_row2sourceRowConversion[rowIndex]);
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_innerModel.getExtraDataTypes();
    }

    @Override
    public Object getValue(Class c) {
        return this.m_innerModel.getValue(c);
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return this.m_innerModel.getRowValue(c, row);
    }

    @Override
    public Object getColValue(Class c, int col) {
        return this.m_innerModel.getColValue(c, col);
    }

    @Override
    public void addSingleValue(Object v) {
        this.m_innerModel.addSingleValue(v);
    }

    @Override
    public Object getSingleValue(Class c) {
        return this.m_innerModel.getSingleValue(c);
    }

    public static enum POLICY {
        REMOVE_INCORRECT_VALUES,
        REPLACE_BY_VALUE;

    }
}

