/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DoubleFilter
extends Filter {
    private static final Integer VALUE_MIN = 0;
    private static final Integer VALUE_MAX = 1;
    private Double m_min;
    private Double m_max;

    public DoubleFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_valueKeys = new ArrayList(2);
        this.m_valueKeys.add(VALUE_MIN);
        this.m_valueKeys.add(VALUE_MAX);
    }

    @Override
    public Filter cloneFilter4Search() {
        DoubleFilter clone = new DoubleFilter(this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_min = this.m_min;
        clone.m_max = this.m_max;
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public FilterStatus checkValues() {
        Double max;
        Double min;
        String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
        if (minValue == null || minValue.length() == 0) {
            min = null;
        } else {
            try {
                min = Double.parseDouble(minValue);
            }
            catch (NumberFormatException nfe) {
                return new FilterStatus("Min Value is  not a Number", (Component)this.m_components.get(VALUE_MIN));
            }
        }
        String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
        if (maxValue == null || maxValue.length() == 0) {
            max = null;
        } else {
            try {
                max = Double.parseDouble(maxValue);
            }
            catch (NumberFormatException nfe) {
                return new FilterStatus("Max Value is  not a Number", (Component)this.m_components.get(VALUE_MAX));
            }
        }
        if (min != null && max != null && min > max) {
            return new FilterStatus("Min Value is greater than Max Value", (Component)this.m_components.get(VALUE_MIN));
        }
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            Double lastMinValue = this.m_min;
            Double lastMaxValue = this.m_max;
            String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
            if (minValue == null || minValue.length() == 0) {
                this.m_min = null;
            } else {
                try {
                    this.m_min = Double.parseDouble(minValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
            if (maxValue == null || maxValue.length() == 0) {
                this.m_max = null;
            } else {
                try {
                    this.m_max = Double.parseDouble(maxValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (lastMinValue == null && this.m_min != null || lastMinValue != null && this.m_min == null) {
                hasChanged = true;
            } else if (lastMaxValue == null && this.m_max != null || lastMaxValue != null && this.m_max == null) {
                hasChanged = true;
            } else if (lastMinValue != null && lastMinValue.doubleValue() != this.m_min.doubleValue()) {
                hasChanged = true;
            } else if (lastMaxValue != null && lastMaxValue.doubleValue() != this.m_max.doubleValue()) {
                hasChanged = true;
            }
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        double value = ((Number)v1).doubleValue();
        if (value != value) {
            return false;
        }
        if (this.m_min != null && value < this.m_min) {
            return false;
        }
        return this.m_max == null || !(value > this.m_max);
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField minTextField = (JTextField)this.getComponent(VALUE_MIN);
        if (minTextField == null) {
            minTextField = new JTextField(4);
            if (this.m_min != null) {
                minTextField.setText(this.m_min.toString());
            }
            this.registerComponent(VALUE_MIN, minTextField);
        }
        p.add((Component)minTextField, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        nameLabel.setHorizontalAlignment(0);
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField maxTextField = (JTextField)this.getComponent(VALUE_MAX);
        if (maxTextField == null) {
            maxTextField = new JTextField(4);
            if (this.m_max != null) {
                maxTextField.setText(this.m_max.toString());
            }
            this.registerComponent(VALUE_MAX, maxTextField);
        }
        p.add((Component)maxTextField, c);
        ++c.gridx;
    }

    @Override
    public void reset() {
        this.m_min = null;
        this.m_max = null;
    }
}

