/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterDialog;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterButton
extends JButton
implements ActionListener {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    private FilterTableModelInterface m_tableModelFilterInterface;

    public FilterButton(FilterTableModelInterface tableModelFilterInterface) {
        this.setModelFilterInterface(tableModelFilterInterface);
        this.setIcon(IconManager.getIcon(IconManager.IconType.FUNNEL));
        this.setFocusPainted(false);
        this.setToolTipText("Filter...");
        this.addActionListener(this);
    }

    public final void setModelFilterInterface(FilterTableModelInterface tableModelFilterInterface) {
        this.m_tableModelFilterInterface = tableModelFilterInterface;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultDialog dialog;
        if (!this.m_tableModelFilterInterface.isLoaded()) {
            dialog = ProgressBarDialog.getDialog(WindowManager.getDefault().getMainWindow(), this.m_tableModelFilterInterface, "Data loading", "Filtering is not available while data is loading. Please Wait.");
            dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
            ((ProgressBarDialog)dialog).setVisible(true);
            if (!((ProgressBarDialog)dialog).isWaitingFinished()) {
                return;
            }
        }
        dialog = FilterDialog.getDialog(WindowManager.getDefault().getMainWindow());
        dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
        LinkedHashMap<Integer, Filter> filtersMap = this.m_tableModelFilterInterface.getFilters();
        Filter[] filters = new Filter[filtersMap.size()];
        int index = 0;
        for (Map.Entry<Integer, Filter> entry : filtersMap.entrySet()) {
            filters[index++] = entry.getValue();
        }
        ((FilterDialog)dialog).setFilters(filters);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            boolean filterIsUsed = false;
            int nbFilter = filters.length;
            for (int i = 0; i < nbFilter; ++i) {
                if (!filters[i].isUsed()) continue;
                filterIsUsed = true;
                break;
            }
            ImageIcon funnelIcon = filterIsUsed ? IconManager.getIcon(IconManager.IconType.FUNNEL_ACTIVATED) : IconManager.getIcon(IconManager.IconType.FUNNEL);
            this.setIcon(funnelIcon);
            this.m_tableModelFilterInterface.filter();
            this.filteringDone();
        }
    }

    protected abstract void filteringDone();
}

