/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterDialog;
import fr.proline.studio.filter.FilterStatus;
import fr.proline.studio.utils.StringUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFilter
extends Filter {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    protected static final Integer SEARCH_TEXT = 0;
    protected static final Integer SEARCH_TEXT_AREA = 1;
    protected static final String OPTION_EQUAL = "=";
    protected static final String OPTION_NOT = "!=";
    protected static final String OPTION_IN = "IN";
    protected String m_filterText;
    protected Pattern m_searchPattern;
    protected String m_selectItem;
    protected JComboBox m_cbOp;
    protected JTextField m_field;
    protected JScrollPane m_area;
    protected String m_filterAreaText;
    protected ArrayList<Pattern> m_searchPatternList;
    protected String[] m_optionList = new String[2];

    public StringFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_optionList[0] = OPTION_EQUAL;
        this.m_optionList[1] = OPTION_IN;
        this.m_selectItem = OPTION_EQUAL;
        this.m_cbOp = null;
        this.m_field = null;
        this.m_area = null;
        this.m_filterText = "";
        this.m_filterAreaText = "";
        this.m_searchPattern = null;
        this.m_searchPatternList = null;
    }

    @Override
    public Filter cloneFilter4Search() {
        StringFilter clone = new StringFilter(this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_optionList = new String[1];
        clone.m_optionList[0] = OPTION_EQUAL;
        clone.reset();
        this.setValuesForClone(clone);
        clone.m_filterText = this.m_filterText;
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        String value = (String)v1;
        boolean found = false;
        switch (this.m_selectItem) {
            case "=": {
                if (this.m_filterText.length() == 0) {
                    return true;
                }
                Matcher matcher = this.m_searchPattern.matcher(value);
                found = matcher.matches();
                return found;
            }
            case "IN": {
                if (this.m_filterAreaText.length() == 0) {
                    return true;
                }
                found = false;
                for (Pattern rx : this.m_searchPatternList) {
                    if (!rx.matcher(value).matches()) continue;
                    return true;
                }
                return false;
            }
        }
        return found;
    }

    @Override
    public FilterStatus checkValues() {
        String selectItem = this.m_cbOp.getSelectedItem().toString();
        String stringF = this.m_field.getText().trim();
        String stringA = ((JTextArea)this.m_area.getViewport().getView()).getText();
        try {
            if (!selectItem.equals(OPTION_IN)) {
                if (stringF.length() == 0) {
                    return null;
                }
                this.m_searchPattern = StringUtils.compileRegex(stringF);
            } else {
                String[] filterAList;
                if (stringA.length() == 0) {
                    return null;
                }
                String delims = "[\n]+";
                for (String s : filterAList = stringA.split(delims)) {
                    StringUtils.compileRegex(s);
                }
            }
        }
        catch (Exception e) {
            return new FilterStatus("Regex Pattern Error", this.getComponent(SEARCH_TEXT));
        }
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            String lastSelItem = this.m_selectItem;
            this.m_selectItem = this.m_cbOp.getSelectedItem().toString();
            if (!this.m_selectItem.equals(OPTION_IN)) {
                String lastValue = this.m_filterText;
                this.m_filterText = this.m_field.getText().trim();
                this.m_searchPattern = StringUtils.compileRegex(this.m_filterText);
                hasChanged = lastValue.compareTo(this.m_filterText) != 0 || lastSelItem != this.m_selectItem;
            } else {
                String lastValue = this.m_filterAreaText;
                this.m_filterAreaText = ((JTextArea)this.m_area.getViewport().getView()).getText().trim();
                String delims = "[\n]+";
                String[] m_filterStringList = this.m_filterAreaText.split(delims);
                this.m_searchPatternList = new ArrayList();
                for (String m_filterStringList1 : m_filterStringList) {
                    this.m_searchPatternList.add(StringUtils.compileRegex(m_filterStringList1));
                }
                hasChanged = lastValue.compareTo(this.m_filterAreaText) != 0 || lastSelItem != this.m_selectItem;
            }
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        final FilterDialog ctrlDialog = FilterDialog.getDialog(WindowManager.getDefault().getMainWindow());
        JLabel nameLabel = new JLabel(this.getName());
        this.m_cbOp = new JComboBox<String>(this.m_optionList);
        this.m_cbOp.setSelectedItem(this.m_selectItem);
        this.m_cbOp.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                String selectItem = (String)combo.getSelectedItem();
                if (selectItem.equals(StringFilter.OPTION_IN) & !StringFilter.this.m_selectItem.equals(StringFilter.OPTION_IN)) {
                    StringFilter.this.m_field.setVisible(false);
                    StringFilter.this.m_area.setVisible(true);
                    StringFilter.this.m_selectItem = selectItem;
                    if (ctrlDialog != null) {
                        ctrlDialog.repack();
                    }
                } else if (StringFilter.this.m_selectItem.equals(StringFilter.OPTION_IN) & !selectItem.equals(StringFilter.OPTION_IN)) {
                    StringFilter.this.m_field.setVisible(true);
                    StringFilter.this.m_area.setVisible(false);
                    StringFilter.this.m_selectItem = selectItem;
                    if (ctrlDialog != null) {
                        ctrlDialog.repack();
                    }
                }
            }
        });
        this.m_field = (JTextField)this.getComponent(SEARCH_TEXT);
        if (this.m_field == null) {
            this.m_field = this.createPasteTextField(this.m_filterText);
            this.registerComponent(SEARCH_TEXT, this.m_field);
        }
        this.m_area = (JScrollPane)this.getComponent(SEARCH_TEXT_AREA);
        if (this.m_area == null) {
            JTextArea textArea = this.createPasteArea(this.m_filterAreaText);
            this.m_area = new JScrollPane(textArea);
            this.registerComponent(SEARCH_TEXT_AREA, this.m_area);
        }
        ++c.gridx;
        JPanel textPane = new JPanel();
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 18;
        c1.fill = 1;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 1.0;
        c1.gridwidth = 2;
        textPane.add((Component)nameLabel, c);
        c1.gridx += 2;
        c1.gridwidth = 1;
        c1.weightx = 0.0;
        textPane.add((Component)this.m_cbOp, c1);
        ++c1.gridx;
        c1.weightx = 1.0;
        c1.gridwidth = 6;
        textPane.add((Component)this.m_field, c1);
        textPane.add((Component)this.m_area, c1);
        c.gridwidth = 9;
        c.weightx = 1.0;
        p.add((Component)textPane, c);
        c.gridx += 9;
        if (this.m_selectItem.equals(OPTION_IN)) {
            this.m_field.setVisible(false);
            this.m_area.setVisible(true);
        } else {
            this.m_field.setVisible(true);
            this.m_area.setVisible(false);
        }
    }

    @Override
    public void reset() {
        this.m_selectItem = OPTION_EQUAL;
        this.m_cbOp = null;
        this.m_filterText = "";
        this.m_filterAreaText = "";
        this.m_field = null;
        this.m_area = null;
        this.m_searchPattern = null;
        this.m_searchPatternList = null;
    }

    @Override
    public void clearComponents() {
        if (this.m_components == null) {
            return;
        }
        this.m_components.clear();
    }

    protected JTextField createPasteTextField(String filterText) {
        JTextField vTextField = new JTextField(12);
        String msg = NbBundle.getMessage(this.getClass(), (String)"Filter_String_RegularExpression.tooltip.text");
        vTextField.setToolTipText(msg);
        if (filterText != null) {
            vTextField.setText(filterText);
        }
        KeyStroke pasteKeyStrock = KeyStroke.getKeyStroke(86, 2, false);
        vTextField.getInputMap().put(pasteKeyStrock, "paste");
        PasteAction pasteAction = new PasteAction(vTextField);
        vTextField.getActionMap().put("paste", pasteAction);
        return vTextField;
    }

    protected JTextArea createPasteArea(String filterAreaText) {
        JTextArea vArea = new JTextArea(5, 20);
        String msg = NbBundle.getMessage(this.getClass(), (String)"Filter_String_RegularExpression.tooltip.text");
        vArea.setToolTipText(msg);
        if (filterAreaText != null) {
            vArea.setText(filterAreaText);
        }
        KeyStroke pasteKeyStrock = KeyStroke.getKeyStroke(86, 2, false);
        vArea.getInputMap().put(pasteKeyStrock, "paste");
        PasteAction pasteAction = new PasteAction(vArea);
        vArea.getActionMap().put("paste", pasteAction);
        return vArea;
    }

    protected class PasteAction
    extends AbstractAction {
        JTextComponent textComponent;

        public PasteAction(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String msg = "";
            try {
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                boolean b = c.isDataFlavorAvailable(DataFlavor.stringFlavor);
                if (b) {
                    String content;
                    String text = c.getData(DataFlavor.stringFlavor).toString().trim();
                    msg = content = StringUtils.extractTextFromHtml(text).trim();
                } else {
                    Transferable t = c.getContents(null);
                    msg = t.getTransferData(t.getTransferDataFlavors()[0]).toString();
                }
            }
            catch (UnsupportedFlavorException ex) {
                msg = "UnsupportedFlavorException";
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                msg = "IOException";
                Exceptions.printStackTrace((Throwable)ex);
            }
            int position = this.textComponent.getCaretPosition();
            String content = this.textComponent.getText();
            String beginText = content.substring(0, position);
            String endText = content.substring(position);
            this.textComponent.setText(beginText + msg + endText);
        }
    }
}

