/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.AxisDataStore;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class BasePlotPanelViewAll
implements MoveableInterface {
    private BasePlotPanel m_basePlotPanel;
    private Rectangle m_previousBasePlotArea = new Rectangle();
    private Rectangle m_plotAreaViewAllMap = null;
    private BufferedImage m_viewAllDoubleBuffer = null;
    private boolean m_updateViewAllDoubleBuffer = false;
    private boolean m_selected = false;
    private boolean m_isDisplayed = false;
    private Handle[] m_handles = new Handle[4];
    private static final BasicStroke STROKE_1 = new BasicStroke(1.0f, 0, 0);
    private static final float[] dash = new float[]{2.0f, 2.0f};
    private static final BasicStroke STROKE_1_DASHED = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    private static final int MINIMAL_SIZE = 20;

    public BasePlotPanelViewAll(BasePlotPanel basePlotPanel) {
        this.m_basePlotPanel = basePlotPanel;
        this.m_handles[0] = new Handle(Handle.HandleType.LEFT_TOP, this);
        this.m_handles[1] = new Handle(Handle.HandleType.RIGHT_TOP, this);
        this.m_handles[2] = new Handle(Handle.HandleType.RIGHT_BOTTOM, this);
        this.m_handles[3] = new Handle(Handle.HandleType.LEFT_BOTTOM, this);
    }

    public void setDisplay(boolean b) {
        this.m_isDisplayed = b;
        this.m_basePlotPanel.repaint();
    }

    public boolean isDisplayed() {
        return this.m_isDisplayed;
    }

    public void updateDoubleBuffer() {
        this.m_updateViewAllDoubleBuffer = true;
    }

    public int convertToBasePlotX(int x) {
        if (x > this.m_plotAreaViewAllMap.x + this.m_plotAreaViewAllMap.width) {
            x = this.m_plotAreaViewAllMap.x + this.m_plotAreaViewAllMap.width;
        }
        if (x < this.m_plotAreaViewAllMap.x) {
            x = this.m_plotAreaViewAllMap.x;
        }
        double percentage = (double)(x - this.m_plotAreaViewAllMap.x) / (double)this.m_plotAreaViewAllMap.width;
        Rectangle plotArea = this.m_basePlotPanel.getPlotArea();
        return (int)Math.round((double)plotArea.x + percentage * (double)plotArea.width);
    }

    public int convertToBasePlotY(int y) {
        if (y > this.m_plotAreaViewAllMap.y + this.m_plotAreaViewAllMap.height) {
            y = this.m_plotAreaViewAllMap.y + this.m_plotAreaViewAllMap.height;
        }
        if (y < this.m_plotAreaViewAllMap.y) {
            y = this.m_plotAreaViewAllMap.y;
        }
        double percentage = (double)(y - this.m_plotAreaViewAllMap.y) / (double)this.m_plotAreaViewAllMap.height;
        Rectangle plotArea = this.m_basePlotPanel.getPlotArea();
        return (int)Math.round((double)plotArea.y + percentage * (double)plotArea.height);
    }

    public void moveHandle(int deltaX, int deltaY, boolean left, boolean top) {
        Rectangle plotArea = this.m_basePlotPanel.getPlotArea();
        if (left) {
            if (deltaX > 0 && this.m_plotAreaViewAllMap.width - deltaX < 20) {
                deltaX = this.m_plotAreaViewAllMap.width - 20;
            } else if (deltaX < 0 && this.m_plotAreaViewAllMap.x + deltaX < plotArea.x) {
                deltaX = plotArea.x - this.m_plotAreaViewAllMap.x;
            }
            this.m_plotAreaViewAllMap.x += deltaX;
            this.m_plotAreaViewAllMap.width -= deltaX;
        } else {
            if (deltaX < 0 && this.m_plotAreaViewAllMap.width + deltaX < 20) {
                deltaX = 20 - this.m_plotAreaViewAllMap.width;
            } else if (deltaX > 0 && this.m_plotAreaViewAllMap.x + this.m_plotAreaViewAllMap.width + deltaX > plotArea.x + plotArea.width - 1) {
                deltaX = plotArea.x + plotArea.width - 1 - this.m_plotAreaViewAllMap.x - this.m_plotAreaViewAllMap.width;
            }
            this.m_plotAreaViewAllMap.width += deltaX;
        }
        if (top) {
            if (deltaY > 0 && this.m_plotAreaViewAllMap.height - deltaY < 20) {
                deltaY = this.m_plotAreaViewAllMap.height - 20;
            } else if (deltaY < 0 && this.m_plotAreaViewAllMap.y + deltaY < plotArea.y) {
                deltaY = plotArea.y - this.m_plotAreaViewAllMap.y;
            }
            this.m_plotAreaViewAllMap.y += deltaY;
            this.m_plotAreaViewAllMap.height -= deltaY;
        } else {
            if (deltaY < 0 && this.m_plotAreaViewAllMap.height + deltaY < 20) {
                deltaY = 20 - this.m_plotAreaViewAllMap.height;
            } else if (deltaY > 0 && this.m_plotAreaViewAllMap.y + this.m_plotAreaViewAllMap.height + deltaY > plotArea.y + plotArea.height - 1) {
                deltaY = plotArea.y + plotArea.height - 1 - this.m_plotAreaViewAllMap.y - this.m_plotAreaViewAllMap.height;
            }
            this.m_plotAreaViewAllMap.height += deltaY;
        }
    }

    public MoveableInterface getOverMovable(int x, int y) {
        if (!this.m_isDisplayed) {
            return null;
        }
        for (int i = 0; i < this.m_handles.length; ++i) {
            if (!this.m_handles[i].insideXY(x, y)) continue;
            return this.m_handles[i];
        }
        if (this.insideXY(x, y)) {
            return this;
        }
        return null;
    }

    public void paintBufferedViewAllMap(Graphics2D g2d) {
        boolean createDoubleBuffer;
        if (!this.m_isDisplayed) {
            return;
        }
        XAxis xAxis = this.m_basePlotPanel.getXAxis();
        YAxis yAxis = this.m_basePlotPanel.getYAxis();
        YAxis rightYAxis = this.m_basePlotPanel.getYAxisRight();
        AxisDataStore.storeValues(xAxis, yAxis, rightYAxis);
        this.preparePaintZone();
        double y2 = yAxis.getMinValue();
        double y1 = yAxis.getMaxValue();
        double x1 = xAxis.getMinValue();
        double x2 = xAxis.getMaxValue();
        double[] resMinMax = this.m_basePlotPanel.getMinMaxPlots(xAxis);
        xAxis.setRange(resMinMax[0], resMinMax[1]);
        xAxis.m_x = this.m_plotAreaViewAllMap.x;
        xAxis.m_y = this.m_plotAreaViewAllMap.y + this.m_plotAreaViewAllMap.height;
        xAxis.m_width = this.m_plotAreaViewAllMap.width;
        xAxis.m_height = 1;
        resMinMax = this.m_basePlotPanel.getMinMaxPlots(yAxis);
        yAxis.setRange(resMinMax[0], resMinMax[1]);
        yAxis.m_x = this.m_plotAreaViewAllMap.x;
        yAxis.m_y = this.m_plotAreaViewAllMap.y;
        yAxis.m_width = 1;
        yAxis.m_height = this.m_plotAreaViewAllMap.height;
        if (rightYAxis.hasPlots()) {
            resMinMax = this.m_basePlotPanel.getMinMaxPlots(rightYAxis);
            rightYAxis.setRange(resMinMax[0], resMinMax[1]);
            rightYAxis.m_x = this.m_plotAreaViewAllMap.x + this.m_plotAreaViewAllMap.width;
            rightYAxis.m_y = this.m_plotAreaViewAllMap.y;
            rightYAxis.m_width = 1;
            rightYAxis.m_height = this.m_plotAreaViewAllMap.height;
        }
        boolean bl = createDoubleBuffer = this.m_viewAllDoubleBuffer == null || this.m_viewAllDoubleBuffer.getWidth() != this.m_plotAreaViewAllMap.width || this.m_viewAllDoubleBuffer.getHeight() != this.m_plotAreaViewAllMap.height;
        if (createDoubleBuffer) {
            this.m_viewAllDoubleBuffer = new BufferedImage(this.m_plotAreaViewAllMap.width, this.m_plotAreaViewAllMap.height, 2);
        }
        if (createDoubleBuffer || this.m_updateViewAllDoubleBuffer) {
            Graphics2D graphicBufferG2d = (Graphics2D)this.m_viewAllDoubleBuffer.getGraphics();
            graphicBufferG2d.translate(-this.m_plotAreaViewAllMap.x, -this.m_plotAreaViewAllMap.y);
            this.paintViewAllMap(graphicBufferG2d, xAxis, yAxis, rightYAxis);
            this.m_updateViewAllDoubleBuffer = false;
        }
        g2d.drawImage((Image)this.m_viewAllDoubleBuffer, this.m_plotAreaViewAllMap.x, this.m_plotAreaViewAllMap.y, null);
        this.paintViewAllMapOver(g2d, xAxis, yAxis, rightYAxis, x1, y1, x2, y2);
        AxisDataStore.restoreValues(xAxis, yAxis, rightYAxis);
    }

    private void preparePaintZone() {
        Rectangle plotArea = this.m_basePlotPanel.getPlotArea();
        if (this.m_plotAreaViewAllMap == null) {
            this.m_plotAreaViewAllMap = new Rectangle();
            this.m_plotAreaViewAllMap.width = (int)Math.round(plotArea.getWidth() * 0.2);
            this.m_plotAreaViewAllMap.height = (int)Math.round(plotArea.getHeight() * 0.2);
            this.m_plotAreaViewAllMap.x = plotArea.x + plotArea.width - 5 - this.m_plotAreaViewAllMap.width;
            this.m_plotAreaViewAllMap.y = plotArea.y + plotArea.height - 5 - this.m_plotAreaViewAllMap.height;
            this.m_previousBasePlotArea.x = plotArea.x;
            this.m_previousBasePlotArea.y = plotArea.y;
            this.m_previousBasePlotArea.width = plotArea.width;
            this.m_previousBasePlotArea.height = plotArea.height;
        } else if (this.m_previousBasePlotArea.x != plotArea.x || this.m_previousBasePlotArea.y != plotArea.y || this.m_previousBasePlotArea.width != plotArea.width || this.m_previousBasePlotArea.height != plotArea.height) {
            double percentage = ((double)this.m_plotAreaViewAllMap.x - (double)this.m_previousBasePlotArea.x) / (double)this.m_previousBasePlotArea.width;
            int x1 = (int)Math.round((double)plotArea.x + (double)plotArea.width * percentage);
            percentage = ((double)this.m_plotAreaViewAllMap.x + (double)this.m_plotAreaViewAllMap.width - (double)this.m_previousBasePlotArea.x) / (double)this.m_previousBasePlotArea.width;
            int x2 = (int)Math.round((double)plotArea.x + (double)plotArea.width * percentage);
            percentage = ((double)this.m_plotAreaViewAllMap.y - (double)this.m_previousBasePlotArea.y) / (double)this.m_previousBasePlotArea.height;
            int y1 = (int)Math.round((double)plotArea.y + (double)plotArea.height * percentage);
            percentage = ((double)this.m_plotAreaViewAllMap.y + (double)this.m_plotAreaViewAllMap.height - (double)this.m_previousBasePlotArea.y) / (double)this.m_previousBasePlotArea.height;
            int y2 = (int)Math.round((double)plotArea.y + (double)plotArea.height * percentage);
            this.m_plotAreaViewAllMap.x = x1;
            this.m_plotAreaViewAllMap.y = y1;
            this.m_plotAreaViewAllMap.width = x2 - x1;
            this.m_plotAreaViewAllMap.height = y2 - y1;
            this.m_previousBasePlotArea.x = plotArea.x;
            this.m_previousBasePlotArea.y = plotArea.y;
            this.m_previousBasePlotArea.width = plotArea.width;
            this.m_previousBasePlotArea.height = plotArea.height;
        }
    }

    private void paintViewAllMap(Graphics2D g2d, XAxis xAxis, YAxis yAxis, YAxis rightYAxis) {
        if (!this.m_isDisplayed) {
            return;
        }
        g2d.setColor(Color.white);
        g2d.fillRect(this.m_plotAreaViewAllMap.x, this.m_plotAreaViewAllMap.y, this.m_plotAreaViewAllMap.width, this.m_plotAreaViewAllMap.height);
        for (PlotBaseAbstract plot : yAxis.getPlots()) {
            plot.paint(g2d, xAxis, yAxis);
        }
        if (rightYAxis != null) {
            for (PlotBaseAbstract plot : rightYAxis.getPlots()) {
                plot.paint(g2d, xAxis, rightYAxis);
            }
        }
    }

    private void paintViewAllMapOver(Graphics2D g2d, XAxis xAxis, YAxis yAxis, YAxis rightYAxis, double x1, double y1, double x2, double y2) {
        if (!this.m_isDisplayed) {
            return;
        }
        Shape previousClipping = g2d.getClip();
        g2d.setClip(this.m_plotAreaViewAllMap);
        g2d.setColor(Color.red);
        g2d.setStroke(STROKE_1_DASHED);
        int zoomX = xAxis.valueToPixel(x1);
        int zoomY = yAxis.valueToPixel(y1);
        int zoomWidth = xAxis.valueToPixel(x2) - zoomX;
        int zoomHeight = yAxis.valueToPixel(y2) - zoomY;
        g2d.drawRect(zoomX, zoomY, zoomWidth, zoomHeight);
        g2d.setColor(Color.black);
        g2d.setStroke(STROKE_1);
        int delta = 0;
        g2d.drawRect(this.m_plotAreaViewAllMap.x + delta, this.m_plotAreaViewAllMap.y + delta, this.m_plotAreaViewAllMap.width - 1 - delta * 2, this.m_plotAreaViewAllMap.height - 1 - delta * 2);
        g2d.setClip(previousClipping);
        if (this.m_selected) {
            for (int i = 0; i < this.m_handles.length; ++i) {
                this.m_handles[i].paint(g2d, this.m_plotAreaViewAllMap);
            }
        }
    }

    @Override
    public boolean insideXY(int x, int y) {
        if (!this.m_isDisplayed) {
            return false;
        }
        for (int i = 0; i < this.m_handles.length; ++i) {
            if (!this.m_handles[i].insideXY(x, y)) continue;
            return true;
        }
        return this.m_plotAreaViewAllMap.contains(x, y);
    }

    @Override
    public void moveDXY(int deltaX, int deltaY) {
        this.m_plotAreaViewAllMap.x += deltaX;
        this.m_plotAreaViewAllMap.y += deltaY;
        Rectangle plotArea = this.m_basePlotPanel.getPlotArea();
        if (this.m_plotAreaViewAllMap.x < plotArea.x) {
            this.m_plotAreaViewAllMap.x = plotArea.x;
        } else if (this.m_plotAreaViewAllMap.x + this.m_plotAreaViewAllMap.width > plotArea.x + plotArea.width - 1) {
            this.m_plotAreaViewAllMap.x = plotArea.x + plotArea.width - this.m_plotAreaViewAllMap.width - 1;
        }
        if (this.m_plotAreaViewAllMap.y < plotArea.y) {
            this.m_plotAreaViewAllMap.y = plotArea.y;
        } else if (this.m_plotAreaViewAllMap.y + this.m_plotAreaViewAllMap.height > plotArea.y + plotArea.height - 1) {
            this.m_plotAreaViewAllMap.y = plotArea.y + plotArea.height - this.m_plotAreaViewAllMap.height - 1;
        }
        this.m_basePlotPanel.repaint();
    }

    @Override
    public boolean isMoveable() {
        return true;
    }

    @Override
    public void snapToData(boolean isCtrlOrShiftDown) {
    }

    @Override
    public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
        this.m_selected = s;
    }

    public static class Handle
    implements MoveableInterface {
        private static final int SIZE = 7;
        private HandleType m_type;
        private Rectangle m_handleRectangle = new Rectangle();
        private BasePlotPanelViewAll m_viewAll;

        public Handle(HandleType type, BasePlotPanelViewAll viewAll) {
            this.m_type = type;
            this.m_handleRectangle.width = 7;
            this.m_handleRectangle.height = 7;
            this.m_viewAll = viewAll;
        }

        public void paint(Graphics2D g2d, Rectangle r) {
            switch (this.m_type) {
                case LEFT_TOP: {
                    this.m_handleRectangle.x = r.x - 3;
                    this.m_handleRectangle.y = r.y - 3;
                    break;
                }
                case RIGHT_TOP: {
                    this.m_handleRectangle.x = r.x + r.width - 1 - 3;
                    this.m_handleRectangle.y = r.y - 3;
                    break;
                }
                case RIGHT_BOTTOM: {
                    this.m_handleRectangle.x = r.x + r.width - 1 - 3;
                    this.m_handleRectangle.y = r.y + r.height - 1 - 3;
                    break;
                }
                case LEFT_BOTTOM: {
                    this.m_handleRectangle.x = r.x - 3;
                    this.m_handleRectangle.y = r.y + r.height - 1 - 3;
                }
            }
            g2d.setColor(Color.white);
            g2d.fillRect(this.m_handleRectangle.x, this.m_handleRectangle.y, this.m_handleRectangle.width, this.m_handleRectangle.height);
            g2d.setColor(Color.black);
            g2d.drawRect(this.m_handleRectangle.x, this.m_handleRectangle.y, this.m_handleRectangle.width, this.m_handleRectangle.height);
        }

        @Override
        public boolean insideXY(int x, int y) {
            return this.m_handleRectangle.contains(x, y);
        }

        @Override
        public void moveDXY(int deltaX, int deltaY) {
            switch (this.m_type) {
                case LEFT_TOP: {
                    this.m_viewAll.moveHandle(deltaX, deltaY, true, true);
                    break;
                }
                case RIGHT_TOP: {
                    this.m_viewAll.moveHandle(deltaX, deltaY, false, true);
                    break;
                }
                case RIGHT_BOTTOM: {
                    this.m_viewAll.moveHandle(deltaX, deltaY, false, false);
                    break;
                }
                case LEFT_BOTTOM: {
                    this.m_viewAll.moveHandle(deltaX, deltaY, true, false);
                }
            }
        }

        @Override
        public boolean isMoveable() {
            return true;
        }

        @Override
        public void snapToData(boolean isCtrlOrShiftDown) {
        }

        @Override
        public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
            this.m_viewAll.setSelected(true, false);
        }

        public static enum HandleType {
            LEFT_TOP,
            RIGHT_TOP,
            RIGHT_BOTTOM,
            LEFT_BOTTOM;

        }
    }
}

