/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.StatsModel;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.ColorButtonAndPalettePanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.GraphicDataGroup;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.XDeltaMarker;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.graphics.marker.coordinates.PercentageCoordinates;
import fr.proline.studio.parameter.ColorParameter;
import fr.proline.studio.parameter.DefaultParameterDialog;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.openide.windows.WindowManager;

public class PlotHistogram
extends PlotXYAbstract {
    private double m_xMin;
    private double m_xMax;
    private double m_yMax;
    private double[] m_dataX;
    private double[] m_dataY;
    private int[] m_dataCountY;
    private double[] m_selected;
    private long[] m_ids;
    private HashMap<Long, Integer> m_idToIndex;
    private StatsModel m_values;
    private int m_bins;
    private final ColorParameter m_colorParameter;
    private final IntegerParameter m_binsParameter;
    private ArrayList<ParameterList> m_parameterListArray = null;
    private final LinkedList<GraphicDataGroup> m_dataGroup = new LinkedList();
    private final HashMap<GraphicDataGroup, LinkedHashMap<Integer, Double>> m_graphicDataGroupToIndex = new HashMap();
    private static final String PLOT_HISTOGRAM_COLOR_KEY = "PLOT_HISTOGRAM_COLOR";
    private static final String PLOT_HISTOGRAM_BIN_KEY = "PLOT_HISTOGRAM_BIN";
    public static String HISTOGRAM_COUNT = "Count";
    public static String HISTOGRAM_PERCENTAGE = "Percentage %";
    private boolean m_asPercentage = false;
    private StringBuilder m_sb = null;

    public PlotHistogram(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int colX, String paramZ) {
        super(plotPanel, PlotType.HISTOGRAM_PLOT, compareDataInterface, crossSelectionInterface);
        int[] cols = new int[]{colX, -1};
        this.update(cols, paramZ);
        ParameterList parameterColorList = new ParameterList("Colors");
        Color histogramColor = CyclicColorPalette.getColor(21);
        this.m_colorParameter = new ColorParameter(PLOT_HISTOGRAM_COLOR_KEY, "Histogram Plot Color", histogramColor, ColorButtonAndPalettePanel.class);
        parameterColorList.add(this.m_colorParameter);
        ParameterList parameterSettingsList = new ParameterList("Settings");
        this.m_binsParameter = new IntegerParameter(PLOT_HISTOGRAM_BIN_KEY, "Bins", JTextField.class, (Integer)this.m_bins, (Integer)5, (Integer)1000);
        parameterSettingsList.add(this.m_binsParameter);
        this.m_parameterListArray = new ArrayList(2);
        this.m_parameterListArray.add(parameterColorList);
        this.m_parameterListArray.add(parameterSettingsList);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP, true);
    }

    public static HashSet<Class> getAcceptedYValues() {
        HashSet<Class> acceptedValues = new HashSet<Class>();
        return acceptedValues;
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        return this.m_parameterListArray;
    }

    @Override
    public boolean select(double x, double y, boolean append) {
        double y2 = 0.0;
        int size = this.m_dataX.length;
        for (int i = 0; i < size - 1; ++i) {
            double y1;
            double x1 = this.m_dataX[i];
            double x2 = this.m_dataX[i + 1];
            double d = y1 = this.m_asPercentage ? this.m_dataY[i] : (double)this.m_dataCountY[i];
            if (x >= x1 && x <= x2 && y >= y2 && y <= y1) {
                this.m_selected[i] = 1.0;
                continue;
            }
            if (append) continue;
            this.m_selected[i] = 0.0;
        }
        return true;
    }

    @Override
    public boolean select(Path2D.Double path, double minX, double maxX, double minY, double maxY, boolean append) {
        double y2 = 0.0;
        int size = this.m_dataX.length;
        for (int i = 0; i < size - 1; ++i) {
            double y1;
            double x1 = this.m_dataX[i];
            double x2 = this.m_dataX[i + 1];
            double d = y1 = this.m_asPercentage ? this.m_dataY[i] : (double)this.m_dataCountY[i];
            if (path.intersects(x1, y2, x2 - x1, y1 - y2)) {
                this.m_selected[i] = 1.0;
                continue;
            }
            if (append) continue;
            this.m_selected[i] = 0.0;
        }
        return false;
    }

    private int findPoint(double x, double y) {
        double y2 = 0.0;
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i = 0; i < size - 1; ++i) {
            double y1;
            double x1 = this.m_dataX[i];
            double x2 = this.m_dataX[i + 1];
            double d = y1 = this.m_asPercentage ? this.m_dataY[i] : (double)this.m_dataCountY[i];
            if (!(x >= x1) || !(x <= x2) || !(y >= y2) || !(y <= y1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getNearestXData(double x) {
        return x;
    }

    @Override
    public double getNearestYData(double y) {
        return y;
    }

    @Override
    public ArrayList<Long> getSelectedIds() {
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        int size = this.m_values.getRowCount();
        for (int i = 0; i < size; ++i) {
            double v = this.m_values.getValue(i);
            int index = (int)((v - this.m_xMin) / (this.m_xMax - this.m_xMin) * (double)this.m_bins);
            if (index >= this.m_bins) {
                index = this.m_bins - 1;
            }
            if (!(this.m_selected[index] > 0.0)) continue;
            selectedIds.add(this.m_ids[i]);
        }
        return selectedIds;
    }

    @Override
    public void setSelectedIds(ArrayList<Long> selectedIds) {
        int i;
        int[] m_selectCount = new int[this.m_bins + 1];
        for (i = 0; i < selectedIds.size(); ++i) {
            Integer index = this.m_idToIndex.get(selectedIds.get(i));
            if (index == null) continue;
            double v = this.m_values.getValue(index);
            int binIndex = (int)((v - this.m_xMin) / (this.m_xMax - this.m_xMin) * (double)this.m_bins);
            if (binIndex >= this.m_bins) {
                binIndex = this.m_bins - 1;
            }
            int n = binIndex;
            m_selectCount[n] = m_selectCount[n] + 1;
        }
        for (i = 0; i < this.m_selected.length; ++i) {
            this.m_selected[i] = (double)m_selectCount[i] / (double)this.m_dataCountY[i];
        }
    }

    @Override
    public String getToolTipText(double x, double y) {
        int indexFound = this.findPoint(x, y);
        if (indexFound == -1) {
            return null;
        }
        if (this.m_sb == null) {
            this.m_sb = new StringBuilder();
        }
        this.m_sb.append(this.m_plotPanel.getXAxis().getTitle());
        this.m_sb.append(" : ");
        this.m_sb.append(this.m_plotPanel.getXAxis().getExternalDecimalFormat().format(this.m_dataX[indexFound]));
        this.m_sb.append(" to ");
        this.m_sb.append(this.m_plotPanel.getXAxis().getExternalDecimalFormat().format(this.m_dataX[indexFound + 1]));
        this.m_sb.append("<BR>");
        this.m_sb.append("Percentage : ");
        this.m_sb.append(this.m_plotPanel.getYAxis().getExternalDecimalFormat().format(this.m_dataY[indexFound]));
        this.m_sb.append(" % ");
        this.m_sb.append("<BR>");
        this.m_sb.append("Count : ");
        this.m_sb.append(this.m_dataCountY[indexFound]);
        String tooltip = this.m_sb.toString();
        this.m_sb.setLength(0);
        return tooltip;
    }

    @Override
    public void parametersChanged() {
        if (this.m_binsParameter == null) {
            return;
        }
        this.m_bins = (Integer)this.m_binsParameter.getObjectValue();
        this.updataDataAccordingToBins();
        this.m_plotPanel.updateAxis(this);
    }

    @Override
    public final void update() {
        int i;
        this.m_values = new StatsModel(this.m_compareDataInterface, this.m_cols[0]);
        this.m_asPercentage = this.m_parameterZ.compareTo(HISTOGRAM_PERCENTAGE) == 0;
        this.clearMarkers();
        int size = this.m_values.getRowCount();
        if (size == 0) {
            return;
        }
        double min = this.m_values.getValue(0);
        for (i = 1; min != min && i < size; ++i) {
            min = this.m_values.getValue(i);
        }
        double max = min;
        while (i < size) {
            double v = this.m_values.getValue(i);
            if (v < min) {
                min = v;
            } else if (v > max) {
                max = v;
            }
            ++i;
        }
        this.m_xMin = min;
        this.m_xMax = max;
        this.m_plotPanel.setXAxisTitle(this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[0]));
        this.m_plotPanel.setYAxisTitle(this.m_asPercentage ? HISTOGRAM_PERCENTAGE : HISTOGRAM_COUNT);
        double std = this.m_values.standardDeviationNaN();
        this.m_bins = (int)Math.round((max - min) / (3.5 * std * Math.pow(size, -0.3333333333333333)));
        if (this.m_bins < 10) {
            this.m_bins = 10;
        }
        this.updataDataAccordingToBins();
        double yStdevLabel = this.m_yMax * 0.1;
        double yMeanLabel = this.m_yMax * 1.1;
        this.m_yMax *= 1.2;
        this.m_plotPanel.updateAxis(this);
        double mean = this.m_values.meanNaN();
        this.addMarker(new XDeltaMarker(this.m_plotPanel, mean, mean + std, yStdevLabel));
        this.addMarker(new LineMarker(this.m_plotPanel, mean + std, 1));
        this.addMarker(new XDeltaMarker(this.m_plotPanel, mean, mean - std, yStdevLabel));
        this.addMarker(new LineMarker(this.m_plotPanel, mean - std, 1));
        this.addMarker(new LabelMarker(this.m_plotPanel, new DataCoordinates(mean + std / 2.0, yStdevLabel), "Stdev : " + std, 1, 3));
        this.addMarker(new LineMarker(this.m_plotPanel, mean, 1));
        this.addMarker(new LabelMarker(this.m_plotPanel, new DataCoordinates(mean, yMeanLabel), "Mean : " + mean, 1, 4));
        LabelMarker titleMarker = new LabelMarker(this.m_plotPanel, new PercentageCoordinates(0.2, 0.95), this.m_values.getDataColumnIdentifier(0) + " Histogram");
        titleMarker.setFont(LabelMarker.TITLE_FONT);
        titleMarker.setDrawFrame(false);
        this.addMarker(titleMarker);
        this.m_plotPanel.repaint();
    }

    private void updataDataAccordingToBins() {
        int i;
        int size = this.m_values.getRowCount();
        double[] data = new double[size];
        this.m_ids = new long[size];
        this.m_idToIndex = new HashMap(size);
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = this.m_values.getValue(i2);
            this.m_ids[i2] = this.m_values.row2UniqueId(i2);
            this.m_idToIndex.put(this.m_ids[i2], i2);
        }
        double delta = this.m_xMax - this.m_xMin;
        this.m_dataCountY = new int[this.m_bins];
        double[] histogram = new double[this.m_bins];
        for (i = 0; i < size; ++i) {
            double v = this.m_values.getValue(i);
            if (v != v) continue;
            int index = (int)((v - this.m_xMin) / delta * (double)this.m_bins);
            if (index >= this.m_bins) {
                index = this.m_bins - 1;
            }
            int n = index;
            this.m_dataCountY[n] = this.m_dataCountY[n] + 1;
        }
        this.m_yMax = 0.0;
        for (i = 0; i < this.m_bins; ++i) {
            double y;
            double percentage;
            histogram[i] = percentage = (double)this.m_dataCountY[i] / (double)size * 100.0;
            double d = y = this.m_asPercentage ? percentage : (double)this.m_dataCountY[i];
            if (!(y > this.m_yMax)) continue;
            this.m_yMax = y;
        }
        this.m_dataX = new double[this.m_bins + 1];
        this.m_dataY = new double[this.m_bins + 1];
        this.m_selected = new double[this.m_bins];
        double binDelta = delta / (double)this.m_bins;
        for (int i3 = 0; i3 < this.m_bins; ++i3) {
            this.m_dataX[i3] = this.m_xMin + (double)i3 * binDelta;
            this.m_dataY[i3] = histogram[i3];
            this.m_selected[i3] = 0.0;
        }
        this.m_dataX[this.m_bins] = this.m_dataX[this.m_bins - 1] + binDelta;
        this.m_dataY[this.m_bins] = this.m_dataY[this.m_bins - 1];
    }

    @Override
    public double getXMin() {
        return this.m_xMin;
    }

    @Override
    public double getXMax() {
        return this.m_xMax;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        return this.m_yMax;
    }

    @Override
    public void paint(Graphics2D g, XAxis xAxis, YAxis yAxis) {
        int i;
        int clipX = xAxis.valueToPixel(xAxis.getMinValue());
        int clipWidth = xAxis.valueToPixel(xAxis.getMaxValue()) - clipX;
        int clipY = yAxis.valueToPixel(yAxis.getMaxValue());
        int clipHeight = yAxis.valueToPixel(yAxis.getMinValue()) - clipY;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        int y2 = yAxis.valueToPixel(0.0);
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i2 = 0; i2 < size - 1; ++i2) {
            int x1 = xAxis.valueToPixel(this.m_dataX[i2]);
            int x2 = xAxis.valueToPixel(this.m_dataX[i2 + 1]);
            int y1 = yAxis.valueToPixel(this.m_asPercentage ? this.m_dataY[i2] : (double)this.m_dataCountY[i2]);
            g.setColor(this.m_colorParameter.getColor());
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
            g.setColor(Color.black);
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
        }
        int nbDataGroups = this.m_dataGroup.size();
        for (i = nbDataGroups - 1; i >= 0; --i) {
            GraphicDataGroup group = this.m_dataGroup.get(i);
            LinkedHashMap<Integer, Double> indexMap = this.m_graphicDataGroupToIndex.get(group);
            Set<Integer> idSet = indexMap.keySet();
            for (Integer index : idSet) {
                int x1 = xAxis.valueToPixel(this.m_dataX[index]);
                int x2 = xAxis.valueToPixel(this.m_dataX[index + 1]);
                int y1 = yAxis.valueToPixel(this.m_asPercentage ? this.m_dataY[index] : (double)this.m_dataCountY[index]);
                double percentage = indexMap.get(index);
                g.setColor(group.getColor());
                int height = (int)Math.round((1.0 - percentage) * (double)(y2 - y1));
                g.fillRect(x1, y1 + height, x2 - x1, y2 - y1 - height);
                g.setColor(Color.black);
                g.drawRect(x1, y1 + height, x2 - x1, y2 - y1 - height);
            }
        }
        for (i = 0; i < size - 1; ++i) {
            int x1 = xAxis.valueToPixel(this.m_dataX[i]);
            int x2 = xAxis.valueToPixel(this.m_dataX[i + 1]);
            int y1 = yAxis.valueToPixel(this.m_asPercentage ? this.m_dataY[i] : (double)this.m_dataCountY[i]);
            if (!(this.m_selected[i] > 0.0)) continue;
            g.setColor(CyclicColorPalette.getColor(5));
            int height = (int)Math.round((1.0 - this.m_selected[i]) * (double)(y2 - y1));
            g.fillRect(x1, y1 + height, x2 - x1, y2 - y1 - height);
            g.setColor(Color.black);
            g.drawRect(x1, y1 + height, x2 - x1, y2 - y1 - height);
        }
    }

    @Override
    public boolean needsXAxis() {
        return true;
    }

    @Override
    public boolean needsYAxis() {
        return true;
    }

    @Override
    public boolean canLogXAxis() {
        return false;
    }

    @Override
    public boolean canLogYAxis() {
        return false;
    }

    @Override
    public boolean isMouseOnPlot(double x, double y) {
        return this.findPoint(x, y) != -1;
    }

    @Override
    public boolean isMouseOnSelectedPlot(double x, double y) {
        int index = this.findPoint(x, y);
        if (index == -1) {
            return false;
        }
        return this.m_selected[index] > 0.0;
    }

    @Override
    public JPopupMenu getPopupMenu(double x, double y) {
        boolean onPoint = false;
        boolean onSelection = false;
        GraphicDataGroup onGroup = null;
        int index = this.findPoint(x, y);
        if (index != -1) {
            double ySelection;
            double yData1;
            onPoint = true;
            double d = yData1 = this.m_asPercentage ? this.m_dataY[index] : (double)this.m_dataCountY[index];
            onSelection = this.m_selected[index] > 0.0 ? y < (ySelection = this.m_selected[index] * yData1) : false;
            for (GraphicDataGroup group : this.m_dataGroup) {
                LinkedHashMap<Integer, Double> percentageMap = this.m_graphicDataGroupToIndex.get(group);
                double percentage = percentageMap.get(index);
                if (!(y < percentage * yData1)) continue;
                onGroup = group;
                break;
            }
        }
        AbstractAction addGroupAction = new AbstractAction("Add Group"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<ParameterList> parameterListArray = new ArrayList<ParameterList>(1);
                ParameterList groupParameterList = new ParameterList("Define Group");
                parameterListArray.add(groupParameterList);
                StringParameter groupNameParameter = new StringParameter("GroupName", "Group Name", JTextField.class, "", (Integer)0, (Integer)32);
                groupParameterList.add(groupNameParameter);
                Color defaultColor = CyclicColorPalette.getColor(18);
                ColorParameter colorParameter = new ColorParameter("GroupColorParameter", "Color", defaultColor, ColorButtonAndPalettePanel.class);
                groupParameterList.add(colorParameter);
                DefaultParameterDialog parameterDialog = new DefaultParameterDialog((Window)WindowManager.getDefault().getMainWindow(), "Plot Parameters", parameterListArray);
                parameterDialog.setLocationRelativeTo(PlotHistogram.this.m_plotPanel);
                parameterDialog.setVisible(true);
                if (parameterDialog.getButtonClicked() == 0) {
                    String groupName = groupNameParameter.getStringValue();
                    Color c = colorParameter.getColor();
                    GraphicDataGroup dataGroup = new GraphicDataGroup(groupName, c);
                    PlotHistogram.this.m_dataGroup.addFirst(dataGroup);
                    LinkedHashMap<Integer, Double> selectedIndexes = new LinkedHashMap<Integer, Double>();
                    for (int i = 0; i < PlotHistogram.this.m_selected.length; ++i) {
                        if (!(PlotHistogram.this.m_selected[i] > 0.0)) continue;
                        selectedIndexes.put(i, PlotHistogram.this.m_selected[i]);
                    }
                    PlotHistogram.this.m_graphicDataGroupToIndex.put(dataGroup, selectedIndexes);
                    String name = dataGroup.getName();
                    if (name != null && !name.isEmpty()) {
                        double percentageY = 1.0 - 0.1 * (double)PlotHistogram.this.m_dataGroup.size();
                        if (percentageY < 0.1) {
                            percentageY = 0.1;
                        }
                        LabelMarker marker = new LabelMarker(PlotHistogram.this.m_plotPanel, new PercentageCoordinates(0.9, percentageY), dataGroup.getName(), 2, 2, dataGroup.getColor());
                        dataGroup.setAssociatedMarker(marker);
                        PlotHistogram.this.addMarker(marker);
                    }
                    PlotHistogram.this.m_plotPanel.repaintUpdateDoubleBuffer();
                }
            }
        };
        addGroupAction.setEnabled(onSelection);
        final GraphicDataGroup _onGroup = onGroup;
        AbstractAction selectGroupAction = new AbstractAction("Select Group"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedHashMap percentageMap = (LinkedHashMap)PlotHistogram.this.m_graphicDataGroupToIndex.get(_onGroup);
                int size = PlotHistogram.this.m_selected.length;
                for (int i = 0; i < size; ++i) {
                    Double percentage = (Double)percentageMap.get(i);
                    ((PlotHistogram)PlotHistogram.this).m_selected[i] = percentage == null ? 0.0 : percentage;
                }
                PlotHistogram.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        };
        selectGroupAction.setEnabled(_onGroup != null);
        AbstractAction deleteGroupAction = new AbstractAction("Delete Group"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotHistogram.this.m_graphicDataGroupToIndex.remove(_onGroup);
                PlotHistogram.this.m_dataGroup.remove(_onGroup);
                AbstractMarker marker = _onGroup.getAssociatedMarker();
                if (marker != null) {
                    PlotHistogram.this.removeMarker(marker);
                }
                PlotHistogram.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        };
        deleteGroupAction.setEnabled(_onGroup != null);
        JPopupMenu menu = new JPopupMenu();
        menu.add(addGroupAction);
        menu.add(selectGroupAction);
        menu.add(deleteGroupAction);
        return menu;
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        return null;
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        return null;
    }
}

